/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.armor;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.fml.ModList;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.armor.MultiHeadGeoArmorItem;
import org.confluence.mod.common.item.armor.NormalGeoArmorItem;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.component.PrimitiveValueComponent;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terraentity.init.TEAttributes;
import org.jetbrains.annotations.Nullable;

public class BaseArmorItem
extends ArmorItem {
    @Nullable
    private List<Component> tooltips;
    @Nullable
    private String requiresModLoaded;
    private boolean golden;

    public BaseArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.tooltips != null) {
            tooltipComponents.addAll(this.tooltips);
        }
        if (this.requiresModLoaded != null && !ModList.get().isLoaded(this.requiresModLoaded)) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.terra_curio.requires_mod_loaded", (Object[])new Object[]{this.requiresModLoaded}));
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return this.golden;
    }

    public static Builder builder(String name, Holder<ArmorMaterial> material, ArmorItem.Type type) {
        return new Builder(name, material, type);
    }

    public static class Builder {
        private final String name;
        private final Holder<ArmorMaterial> material;
        private final ArmorItem.Type type;
        private final Item.Properties properties = new Item.Properties();
        private String geoName = null;
        private ModRarity rarity = ModRarity.WHITE;
        private int lineCount = 0;
        private int durability = 0;
        private Map<ValueType<?, ? extends PrimitiveValue<?>>, PrimitiveValue<?>> types = null;
        private boolean multiHead = false;
        private String requiresModLoaded = null;
        private ImmutableList.Builder<ItemAttributeModifiers.Entry> vanillaAttributes = null;
        private boolean golden;
        private transient ResourceLocation id;

        public Builder(String name, Holder<ArmorMaterial> material, ArmorItem.Type type) {
            this.name = name;
            this.material = material;
            this.type = type;
        }

        public ResourceLocation asId() {
            if (this.id == null) {
                this.id = Confluence.asResource(this.name);
            }
            return this.id;
        }

        public Builder properties(Consumer<Item.Properties> consumer) {
            consumer.accept(this.properties);
            return this;
        }

        public Builder geo(String geoName) {
            this.geoName = geoName;
            return this;
        }

        public Builder geo(String geoName, boolean multiHead) {
            this.geoName = geoName;
            this.multiHead = multiHead;
            return this;
        }

        public Builder rarity(ModRarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder tooltips(int lineCount) {
            this.lineCount = lineCount;
            return this;
        }

        public Builder durability(int value) {
            this.durability = value;
            return this;
        }

        public Builder armorBonus(PrimitiveValueComponent component) {
            if (this.types == null) {
                this.types = new HashMap();
            }
            this.types.putAll(component.types());
            return this;
        }

        public Builder additionalMana(int value) {
            return this.armorBonus(PrimitiveValueComponent.of(AccessoryItems.ADDITIONAL$MANA, (Object)value));
        }

        public Builder requiresModLoaded(String modid) {
            this.requiresModLoaded = modid;
            return this;
        }

        public Builder attribute(Holder<Attribute> attribute, double value, AttributeModifier.Operation operation) {
            if (this.vanillaAttributes == null) {
                this.vanillaAttributes = ImmutableList.builder();
            }
            this.vanillaAttributes.add((Object)new ItemAttributeModifiers.Entry(attribute, new AttributeModifier(this.asId(), value, operation), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot())));
            return this;
        }

        public Builder meleeDamage(double value) {
            return this.attribute((Holder<Attribute>)Attributes.ATTACK_DAMAGE, value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }

        public Builder rangedDamage(double value) {
            return this.attribute((Holder<Attribute>)TCAttributes.getRangedDamage(), value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }

        public Builder magicDamage(double value) {
            return this.attribute((Holder<Attribute>)TCAttributes.getMagicDamage(), value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }

        public Builder summonDamage(double value) {
            return this.attribute((Holder<Attribute>)TEAttributes.SUMMON_DAMAGE, value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }

        public Builder fourClassesDamage(double value) {
            return this.meleeDamage(value).rangedDamage(value).magicDamage(value).summonDamage(value);
        }

        public Builder criticalChance(double value) {
            return this.attribute((Holder<Attribute>)TCAttributes.getCriticalChance(), value, AttributeModifier.Operation.ADD_VALUE);
        }

        public Builder setGolden() {
            this.golden = true;
            return this;
        }

        public BaseArmorItem build() {
            this.properties.stacksTo(1);
            if (this.durability > 0) {
                this.properties.durability(this.durability);
            } else {
                this.properties.component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE);
            }
            if (this.types != null) {
                this.properties.component(ModDataComponentTypes.ARMOR_BONUS, (Object)new PrimitiveValueComponent(this.types));
            }
            BaseArmorItem item = this.geoName != null ? (this.multiHead ? new MultiHeadGeoArmorItem(this.geoName, this.rarity, this.material, this.type, this.properties) : new NormalGeoArmorItem(this.geoName, this.rarity, this.material, this.type, this.properties)) : new BaseArmorItem(this.material, this.type, this.properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)this.rarity));
            if (this.vanillaAttributes != null) {
                Supplier supplier = item.defaultModifiers;
                item.defaultModifiers = (Supplier)Suppliers.memoize(() -> this.lambda$build$0((Supplier)supplier));
            }
            if (this.lineCount > 0) {
                item.tooltips = TooltipItem.getTooltipsFromString((String)this.name, (int)this.lineCount, (ChatFormatting)ChatFormatting.GRAY);
            }
            item.requiresModLoaded = this.requiresModLoaded;
            item.golden = this.golden;
            return item;
        }

        private /* synthetic */ ItemAttributeModifiers lambda$build$0(Supplier supplier) {
            this.vanillaAttributes.addAll((Iterable)((ItemAttributeModifiers)supplier.get()).modifiers());
            return new ItemAttributeModifiers((List)this.vanillaAttributes.build(), true);
        }
    }
}

