/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.item.common.TreasureBagItem;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.terra_curio.common.init.TCCommonConfigs;
import org.confluence.terra_curio.common.init.TCItems;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class TreasureBagItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredItem<TreasureBagItem> KING_SLIME_TREASURE_BAG = ITEMS.register("king_slime_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/king_slime"), ModRarity.BLUE));
    public static final DeferredItem<TreasureBagItem> EYE_OF_CTHULHU_TREASURE_BAG = ITEMS.register("eye_of_cthulhu_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/eye_of_cthulhu"), ModRarity.BLUE, (level, pos) -> {
        String difficulty = (String)LibUtils.switchByDifficulty((Level)level, (BlockPos)pos, (Object)"/classic", (Object)"/expert", (Object)"/master");
        long secretFlag = IMinecraftServer.of(level.getServer()).confluence$getSecretFlag();
        String biome = IMinecraftServer.equalsSecretFlag(secretFlag, 3L) || !IMinecraftServer.matchesSecretFlag(secretFlag, 3L) ? "_double_evil" : (IMinecraftServer.matchesSecretFlag(secretFlag, 1L) ? "_corruption" : (IMinecraftServer.matchesSecretFlag(secretFlag, 2L) ? "_crimson" : ""));
        return difficulty + biome;
    }));
    public static final DeferredItem<TreasureBagItem> EATER_OF_WORLDS_TREASURE_BAG = ITEMS.register("eater_of_worlds_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/eater_of_worlds"), ModRarity.GREEN));
    public static final DeferredItem<TreasureBagItem> BRAIN_OF_CTHULHU_TREASURE_BAG = ITEMS.register("brain_of_cthulhu_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/brain_of_cthulhu"), ModRarity.GREEN));
    public static final DeferredItem<TreasureBagItem> QUEEN_BEE_TREASURE_BAG = ITEMS.register("queen_bee_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/queen_bee"), ModRarity.ORANGE));
    public static final DeferredItem<TreasureBagItem> DEERCLOPS_TREASURE_BAG = ITEMS.register("deerclops_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/deerclops"), ModRarity.ORANGE));
    public static final DeferredItem<TreasureBagItem> SKELETRON_TREASURE_BAG = ITEMS.register("skeletron_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/skeletron"), ModRarity.ORANGE));
    public static final DeferredItem<TreasureBagItem> WALL_OF_FLESH_TREASURE_BAG = ITEMS.register("wall_of_flesh_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/wall_of_flesh"), ModRarity.LIGHT_RED){

        @Override
        @ParametersAreNonnullByDefault
        protected void collectItems(ServerLevel serverLevel, Player player, ItemStack itemStack, ObjectArrayList<ItemStack> items) {
            if (LibUtils.isAtLeastExpert((Level)serverLevel, (BlockPos)player.blockPosition())) {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
                    ICurioStacksHandler iCurioStacksHandler = (ICurioStacksHandler)iCuriosItemHandler.getCurios().get("accessory");
                    if ((Integer)TCCommonConfigs.MAX_ACCESSORIES.get() - iCurioStacksHandler.getSlots() > 0) {
                        items.add((Object)TCItems.DEMON_HEART.toStack());
                    }
                });
            }
        }
    });
    public static final DeferredItem<TreasureBagItem> HILL_OF_FLESH_TREASURE_BAG = ITEMS.register("hill_of_flesh_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/hill_of_flesh"), ModRarity.LIGHT_RED){

        @Override
        @ParametersAreNonnullByDefault
        protected void collectItems(ServerLevel serverLevel, Player player, ItemStack itemStack, ObjectArrayList<ItemStack> items) {
            if (LibUtils.isAtLeastExpert((Level)serverLevel, (BlockPos)player.blockPosition())) {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
                    ICurioStacksHandler iCurioStacksHandler = (ICurioStacksHandler)iCuriosItemHandler.getCurios().get("accessory");
                    if ((Integer)TCCommonConfigs.MAX_ACCESSORIES.get() - iCurioStacksHandler.getSlots() > 0) {
                        items.add((Object)TCItems.DEMON_HEART.toStack());
                    }
                });
            }
        }
    });
    public static final DeferredItem<TreasureBagItem> THE_TWINS_TREASURE_BAG = ITEMS.register("the_twins_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/the_twins"), ModRarity.PINK));
    public static final DeferredItem<TreasureBagItem> SKELETRON_PRIME_TREASURE_BAG = ITEMS.register("skeletron_prime_treasure_bag", () -> new TreasureBagItem(Confluence.asResource("treasure_bag/skeletron_prime"), ModRarity.PINK));
}

