/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModFluids;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.item.common.BinocularsItem;
import org.confluence.mod.common.item.common.BottomlessBucketItem;
import org.confluence.mod.common.item.common.BugNetItem;
import org.confluence.mod.common.item.common.DemonConch;
import org.confluence.mod.common.item.common.DungeonCompass;
import org.confluence.mod.common.item.common.EncumberingStoneItem;
import org.confluence.mod.common.item.common.GuideToCritterCompanionshipItem;
import org.confluence.mod.common.item.common.GuideToEnvironmentalPreservationItem;
import org.confluence.mod.common.item.common.GuideToPeacefulCoexistenceItem;
import org.confluence.mod.common.item.common.HoneyBucketItem;
import org.confluence.mod.common.item.common.MagicConch;
import org.confluence.mod.common.item.common.MagicDropperItem;
import org.confluence.mod.common.item.common.NPCInvitationItem;
import org.confluence.mod.common.item.common.RopeCoilItem;
import org.confluence.mod.common.item.common.SpongeItem;
import org.confluence.mod.common.item.common.StaffOfRegrowth;
import org.confluence.mod.common.item.common.WireCutterItem;
import org.confluence.mod.common.item.common.WrenchItem;
import org.confluence.terra_curio.common.item.MagicMirror;

@ParametersAreNonnullByDefault
public class ToolItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredItem<HoneyBucketItem> HONEY_BUCKET = ITEMS.register("honey_bucket", HoneyBucketItem::new);
    public static final DeferredItem<BottomlessBucketItem> BOTTOMLESS_WATER_BUCKET = ITEMS.register("bottomless_water_bucket", () -> new BottomlessBucketItem(Fluids.WATER, ModRarity.LIME));
    public static final DeferredItem<BottomlessBucketItem> BOTTOMLESS_LAVA_BUCKET = ITEMS.register("bottomless_lava_bucket", () -> new BottomlessBucketItem(Fluids.LAVA, ModRarity.LIME));
    public static final DeferredItem<BottomlessBucketItem> BOTTOMLESS_HONEY_BUCKET = ITEMS.register("bottomless_honey_bucket", () -> new BottomlessBucketItem((FlowingFluid)ModFluids.HONEY.fluid().get(), ModRarity.LIME));
    public static final DeferredItem<BottomlessBucketItem> BOTTOMLESS_SHIMMER_BUCKET = ITEMS.register("bottomless_shimmer_bucket", () -> new BottomlessBucketItem((FlowingFluid)ModFluids.SHIMMER.fluid().get(), ModRarity.RED));
    public static final DeferredItem<SpongeItem> SUPER_ABSORBANT_SPONGE = ITEMS.register("super_absorbant_sponge", () -> new SpongeItem(ModRarity.LIME, "super_absorbant_sponge", 2, state -> state.is(Blocks.WATER) || state.is(ModBlocks.SHIMMER)));
    public static final DeferredItem<SpongeItem> HONEY_ABSORBANT_SPONGE = ITEMS.register("honey_absorbant_sponge", () -> new SpongeItem(ModRarity.LIME, "honey_absorbant_sponge", 2, state -> state.is(ModBlocks.HONEY)));
    public static final DeferredItem<SpongeItem> LAVA_ABSORBANT_SPONGE = ITEMS.register("lava_absorbant_sponge", () -> new SpongeItem(ModRarity.LIME, "lava_absorbant_sponge", 2, state -> state.is(Blocks.LAVA)));
    public static final DeferredItem<SpongeItem> ULTRA_ABSORBANT_SPONGE = ITEMS.register("ultra_absorbant_sponge", () -> new SpongeItem(ModRarity.YELLOW, "ultra_absorbant_sponge", 2, state -> state.is(Blocks.WATER) || state.is(ModBlocks.SHIMMER) || state.is(ModBlocks.HONEY) || state.is(Blocks.LAVA)));
    public static final DeferredItem<TooltipItem> GOLDEN_DUNGEON_KEY = ITEMS.register("golden_dungeon_key", () -> new TooltipItem(new Item.Properties(), ModRarity.WHITE, TooltipItem.getTooltipsFromString((String)"golden_dungeon_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> GOLDEN_KEY = ITEMS.register("golden_key", () -> new TooltipItem(new Item.Properties(), ModRarity.WHITE, TooltipItem.getTooltipsFromString((String)"golden_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> SHADOW_KEY = ITEMS.register("shadow_key", () -> new TooltipItem(new Item.Properties(), ModRarity.WHITE, TooltipItem.getTooltipsFromString((String)"shadow_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> TEMPLE_KEY = ITEMS.register("temple_key", () -> new TooltipItem(new Item.Properties(), ModRarity.LIME, TooltipItem.getTooltipsFromString((String)"temple_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> JUNGLE_KEY = ITEMS.register("jungle_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"jungle_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> CORRUPTION_KEY = ITEMS.register("corruption_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"corruption_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> CRIMSON_KEY = ITEMS.register("crimson_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"crimson_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> HALLOWED_KEY = ITEMS.register("hallowed_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"hallowed_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> FROZEN_KEY = ITEMS.register("frozen_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"frozen_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> DESERT_KEY = ITEMS.register("desert_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"desert_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> OCEAN_KEY = ITEMS.register("ocean_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"ocean_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> UNIVERSE_KEY = ITEMS.register("universe_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"universe_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> RUST_IRON_KEY = ITEMS.register("rust_iron_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"rust_iron_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> MECHANIC_SAFE_KEY = ITEMS.register("mechanic_safe_key", () -> new TooltipItem(new Item.Properties(), ModRarity.YELLOW, TooltipItem.getTooltipsFromString((String)"mechanic_safe_key", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> KEY_OF_LIGHT = ITEMS.register("key_of_light", () -> new TooltipItem(new Item.Properties(), ModRarity.WHITE, TooltipItem.getTooltipsFromString((String)"key_of_light", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<TooltipItem> KEY_OF_NIGHT = ITEMS.register("key_of_night", () -> new TooltipItem(new Item.Properties(), ModRarity.WHITE, TooltipItem.getTooltipsFromString((String)"key_of_night", (int)1, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<WrenchItem> RED_WRENCH = ITEMS.register("red_wrench", () -> new WrenchItem(0xFF0000));
    public static final DeferredItem<WrenchItem> GREEN_WRENCH = ITEMS.register("green_wrench", () -> new WrenchItem(65280));
    public static final DeferredItem<WrenchItem> BLUE_WRENCH = ITEMS.register("blue_wrench", () -> new WrenchItem(255));
    public static final DeferredItem<WrenchItem> YELLOW_WRENCH = ITEMS.register("yellow_wrench", () -> new WrenchItem(0xFFFF00));
    public static final DeferredItem<WireCutterItem> WIRE_CUTTER = ITEMS.register("wire_cutter", WireCutterItem::new);
    public static final DeferredItem<MagicMirror> ICE_MIRROR = ITEMS.register("ice_mirror", () -> new MagicMirror(ModRarity.BLUE));
    public static final DeferredItem<MagicConch> MAGIC_CONCH = ITEMS.register("magic_conch", () -> new MagicConch(new Item.Properties().stacksTo(1), ModRarity.BLUE));
    public static final DeferredItem<DemonConch> DEMON_CONCH = ITEMS.register("demon_conch", DemonConch::new);
    public static final DeferredItem<BugNetItem> BUG_NET = ITEMS.register("bug_net", () -> new BugNetItem(ModRarity.BLUE, TooltipItem.getTooltipsFromString((String)"bug_net", (int)1, (ChatFormatting)ChatFormatting.GRAY), 0.5, living -> LibUtils.isAnimal((LivingEntity)living) && !living.getType().is(ModTags.EntityTypes.LAVA_BUG_NET_ALLOWS)));
    public static final DeferredItem<BugNetItem> LAVAPROOF_BUG_NET = ITEMS.register("lavaproof_bug_net", () -> new BugNetItem(ModRarity.ORANGE, TooltipItem.getTooltipsFromString((String)"lavaproof_bug_net", (int)1, (ChatFormatting)ChatFormatting.GRAY), 0.5, LibUtils::isAnimal));
    public static final DeferredItem<BugNetItem> GOLDEN_BUG_NET = ITEMS.register("golden_bug_net", () -> new BugNetItem(ModRarity.QUEST, TooltipItem.getTooltipsFromString((String)"golden_bug_net", (int)2, (ChatFormatting)ChatFormatting.GRAY), 1.1, LibUtils::isAnimal));
    public static final DeferredItem<BugNetItem> DEV_BUG_NET = ITEMS.register("dev_bug_net", () -> new BugNetItem(ModRarity.MASTER, TooltipItem.getTooltipsFromString((String)"dev_bug_net", (int)1, (ChatFormatting)ChatFormatting.GRAY), Double.MAX_VALUE, living -> !(living instanceof Player)));
    public static final DeferredItem<RopeCoilItem> ROPE_COIL = ITEMS.register("rope_coil", () -> new RopeCoilItem(new Item.Properties(), (Block)ModBlocks.ROPE.get()));
    public static final DeferredItem<RopeCoilItem> VINE_ROPE_COIL = ITEMS.register("vine_rope_coil", () -> new RopeCoilItem(new Item.Properties(), (Block)ModBlocks.VINE_ROPE.get()));
    public static final DeferredItem<RopeCoilItem> SILK_ROPE_COIL = ITEMS.register("silk_rope_coil", () -> new RopeCoilItem(new Item.Properties(), (Block)ModBlocks.SILK_ROPE.get()));
    public static final DeferredItem<RopeCoilItem> WEB_ROPE_COIL = ITEMS.register("web_rope_coil", () -> new RopeCoilItem(new Item.Properties(), (Block)ModBlocks.WEB_ROPE.get()));
    public static final DeferredItem<TooltipItem> METEOR_COMPASS = ITEMS.register("meteor_compass", () -> new TooltipItem(new Item.Properties().stacksTo(1), ModRarity.BLUE, TooltipItem.getTooltipsFromString((String)"meteor_compass", (int)1, (ChatFormatting)ChatFormatting.AQUA)));
    public static final DeferredItem<BinocularsItem> BINOCULARS = ITEMS.register("binoculars", BinocularsItem::new);
    public static final DeferredItem<NPCInvitationItem> NPC_INVITATION = ITEMS.register("npc_invitation", NPCInvitationItem::new);
    public static final DeferredItem<DungeonCompass> DUNGEON_COMPASS = ITEMS.register("dungeon_compass", DungeonCompass::new);
    public static final DeferredItem<MagicDropperItem> EMPTY_DROPPER = ITEMS.register("empty_dropper", () -> new MagicDropperItem(null){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.empty_dropper.0"));
        }
    });
    public static final DeferredItem<MagicDropperItem> MAGIC_SAND_DROPPER = ITEMS.register("magic_sand_dropper", () -> new MagicDropperItem((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.SAND.defaultBlockState())));
    public static final DeferredItem<MagicDropperItem> MAGIC_HONEY_DROPPER = ITEMS.register("magic_honey_dropper", () -> new MagicDropperItem((ParticleOptions)ParticleTypes.DRIPPING_HONEY));
    public static final DeferredItem<MagicDropperItem> MAGIC_LAVA_DROPPER = ITEMS.register("magic_lava_dropper", () -> new MagicDropperItem((ParticleOptions)ParticleTypes.DRIPPING_LAVA));
    public static final DeferredItem<MagicDropperItem> MAGIC_WATER_DROPPER = ITEMS.register("magic_water_dropper", () -> new MagicDropperItem((ParticleOptions)ParticleTypes.DRIPPING_WATER));
    public static final DeferredItem<EncumberingStoneItem> ENCUMBERING_STONE = ITEMS.register("encumbering_stone", EncumberingStoneItem::new);
    public static final DeferredItem<GuideToCritterCompanionshipItem> GUIDE_TO_CRITTER_COMPANIONSHIP = ITEMS.register("guide_to_critter_companionship", GuideToCritterCompanionshipItem::new);
    public static final DeferredItem<GuideToEnvironmentalPreservationItem> GUIDE_TO_ENVIRONMENTAL_PRESERVATION = ITEMS.register("guide_to_environmental_preservation", GuideToEnvironmentalPreservationItem::new);
    public static final DeferredItem<GuideToPeacefulCoexistenceItem> GUIDE_TO_PEACEFUL_COEXISTENCE = ITEMS.register("guide_to_peaceful_coexistence", GuideToPeacefulCoexistenceItem::new);
    public static final DeferredItem<StaffOfRegrowth> STAFF_OF_REGROWTH = ITEMS.register("staff_of_regrowth", StaffOfRegrowth::new);
}

