/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.function.TriFunction;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.paint.EyedropperItem;
import org.confluence.mod.common.item.paint.PaintItem;
import org.confluence.mod.common.item.paint.PaintRollerItem;
import org.confluence.mod.common.item.paint.PaintScraperItem;
import org.confluence.mod.common.item.paint.PaintbrushItem;

public class PaintItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final List<PaintItem> PAINT_ITEMS = new ArrayList<PaintItem>();
    public static final DeferredItem<PaintbrushItem> PAINTBRUSH = PaintItems.registerTool("paintbrush", PaintbrushItem::new, false);
    public static final DeferredItem<PaintRollerItem> PAINT_ROLLER = PaintItems.registerTool("paint_roller", PaintRollerItem::new, false);
    public static final DeferredItem<PaintScraperItem> PAINT_SCRAPER = PaintItems.registerTool("paint_scraper", PaintScraperItem::new, false);
    public static final DeferredItem<PaintbrushItem> SPECTRE_PAINTBRUSH = PaintItems.registerTool("paintbrush", PaintbrushItem::new, true);
    public static final DeferredItem<PaintRollerItem> SPECTRE_PAINT_ROLLER = PaintItems.registerTool("paint_roller", PaintRollerItem::new, true);
    public static final DeferredItem<PaintScraperItem> SPECTRE_PAINT_SCRAPER = PaintItems.registerTool("paint_scraper", PaintScraperItem::new, true);
    public static final DeferredItem<EyedropperItem> EYEDROPPER = ITEMS.register("eyedropper", EyedropperItem::new);
    public static final DeferredItem<PaintItem> PAINT = PaintItems.registerPaint("paint", 3786171);
    public static final DeferredItem<PaintItem> RED_PAINT = PaintItems.registerPaint("red_paint", 14354697);
    public static final DeferredItem<PaintItem> DEEP_RED_PAINT = PaintItems.registerPaint("deep_red_paint", 5571869);
    public static final DeferredItem<PaintItem> ORANGE_PAINT = PaintItems.registerPaint("orange_paint", 15489543);
    public static final DeferredItem<PaintItem> DEEP_ORANGE_PAINT = PaintItems.registerPaint("deep_orange_paint", 7281667);
    public static final DeferredItem<PaintItem> YELLOW_PAINT = PaintItems.registerPaint("yellow_paint", 15773703);
    public static final DeferredItem<PaintItem> DEEP_YELLOW_PAINT = PaintItems.registerPaint("deep_yellow_paint", 7750659);
    public static final DeferredItem<PaintItem> LIME_PAINT = PaintItems.registerPaint("lime_paint", 12050451);
    public static final DeferredItem<PaintItem> DEEP_LIME_PAINT = PaintItems.registerPaint("deep_lime_paint", 4484614);
    public static final DeferredItem<PaintItem> GREEN_PAINT = PaintItems.registerPaint("green_paint", 2940681);
    public static final DeferredItem<PaintItem> DEEP_GREEN_PAINT = PaintItems.registerPaint("deep_green_paint", 286730);
    public static final DeferredItem<PaintItem> TEAL_PAINT = PaintItems.registerPaint("teal_paint", 247643);
    public static final DeferredItem<PaintItem> DEEP_TEAL_PAINT = PaintItems.registerPaint("deep_teal_paint", 86837);
    public static final DeferredItem<PaintItem> CYAN_PAINT = PaintItems.registerPaint("cyan_paint", 247714);
    public static final DeferredItem<PaintItem> DEEP_CYAN_PAINT = PaintItems.registerPaint("deep_cyan_paint", 286558);
    public static final DeferredItem<PaintItem> SKY_BLUE_PAINT = PaintItems.registerPaint("sky_blue_paint", 432590);
    public static final DeferredItem<PaintItem> DEEP_SKY_BLUE_PAINT = PaintItems.registerPaint("deep_sky_blue_paint", 342118);
    public static final DeferredItem<PaintItem> BLUE_PAINT = PaintItems.registerPaint("blue_paint", 2113214);
    public static final DeferredItem<PaintItem> DEEP_BLUE_PAINT = PaintItems.registerPaint("deep_blue_paint", 723019);
    public static final DeferredItem<PaintItem> PURPLE_PAINT = PaintItems.registerPaint("purple_paint", 6427862);
    public static final DeferredItem<PaintItem> DEEP_PURPLE_PAINT = PaintItems.registerPaint("deep_purple_paint", 2495083);
    public static final DeferredItem<PaintItem> VIOLET_PAINT = PaintItems.registerPaint("violet_paint", 12195030);
    public static final DeferredItem<PaintItem> DEEP_VIOLET_PAINT = PaintItems.registerPaint("deep_violet_paint", 4327255);
    public static final DeferredItem<PaintItem> PINK_PAINT = PaintItems.registerPaint("pink_paint", 15536332);
    public static final DeferredItem<PaintItem> DEEP_PINK_PAINT = PaintItems.registerPaint("deep_pink_paint", 6949214);
    public static final DeferredItem<PaintItem> BLACK_PAINT = PaintItems.registerPaint("black_paint", 1973536);
    public static final DeferredItem<PaintItem> GRAY_PAINT = PaintItems.registerPaint("gray_paint", 0x676764);
    public static final DeferredItem<PaintItem> WHITE_PAINT = PaintItems.registerPaint("white_paint", 0xFFFEF6);
    public static final DeferredItem<PaintItem> BROWN_PAINT = PaintItems.registerPaint("brown_paint", 9135423);
    public static final DeferredItem<PaintItem> SHADOW_PAINT = PaintItems.registerPaint("shadow_paint", 0);
    public static final DeferredItem<PaintItem> NEGATIVE_PAINT = PaintItems.registerPaint("negative_paint", -3);
    public static final DeferredItem<PaintItem> ILLUMINANT_COATING = PaintItems.registerPaint("illuminant_coating", -4);
    public static final DeferredItem<PaintItem> ECHO_COATING = PaintItems.registerPaint("echo_coating", -5);

    private static DeferredItem<PaintItem> registerPaint(String name, int color) {
        return ITEMS.register(name, () -> {
            PaintItem paintItem = new PaintItem(color);
            PAINT_ITEMS.add(paintItem);
            return paintItem;
        });
    }

    private static <T extends Item> DeferredItem<T> registerTool(String suffix, TriFunction<Item.Properties, ModRarity, List<Component>, T> factory, boolean spectre) {
        return ITEMS.register((String)(spectre ? "spectre_" + suffix : suffix), () -> {
            Item.Properties properties = new Item.Properties();
            if (spectre) {
                properties.attributes(ItemAttributeModifiers.builder().add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(ModItems.BASE_BLOCK_INTERACTION_RANGE_ID, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build());
            }
            return (Item)factory.apply((Object)properties, (Object)ModRarity.WHITE, (Object)TooltipItem.getTooltipsFromString((String)suffix, (int)2, (ChatFormatting)ChatFormatting.GRAY));
        });
    }
}

