/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.function.TriConsumer;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.item.common.HerbSeedItem;
import org.confluence.mod.common.item.food.BaseFoodItem;
import org.confluence.mod.common.item.food.ModFoodProperties;
import org.confluence.mod.common.item.food.ModFoodPropertiesBuilder;

public class FoodItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredItem<BaseFoodItem> COOKED_SHRIMP = FoodItems.registerNormalFood("cooked_shrimp", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> RAW_FROG = FoodItems.registerNormalFood("raw_frog", ModRarity.GREEN, () -> ModFoodProperties.noEffectProperties(2, 1.8f));
    public static final DeferredItem<BaseFoodItem> RAW_SQUIRREL = FoodItems.registerNormalFood("raw_squirrel", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 1.8f));
    public static final DeferredItem<BaseFoodItem> RAW_BIRD = FoodItems.registerNormalFood("raw_bird", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 1.8f));
    public static final DeferredItem<BaseFoodItem> RAW_DUCK = FoodItems.registerNormalFood("raw_duck", ModRarity.GREEN, () -> ModFoodProperties.noEffectProperties(3, 1.8f));
    public static final DeferredItem<BaseFoodItem> COOKED_FROG = FoodItems.registerNormalFood("cooked_frog", ModRarity.GREEN, () -> ModFoodProperties.noEffectProperties(4, 3.6f));
    public static final DeferredItem<BaseFoodItem> COOKED_SQUIRREL = FoodItems.registerNormalFood("cooked_squirrel", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(4, 3.6f));
    public static final DeferredItem<BaseFoodItem> COOKED_BIRD = FoodItems.registerNormalFood("cooked_bird", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(4, 3.6f));
    public static final DeferredItem<BaseFoodItem> COOKED_DUCK = FoodItems.registerNormalFood("cooked_duck", ModRarity.GREEN, () -> ModFoodProperties.noEffectProperties(6, 7.2f));
    public static final DeferredItem<BaseFoodItem> ESCARGOT = FoodItems.registerNormalFood("escargot", ModRarity.BLUE, () -> ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> FROGGLE_BUNWICH = FoodItems.registerNormalFood("froggle_bunwich", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(7200, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> GOLDEN_DELIGHT = FoodItems.registerNormalFood("golden_delight", ModRarity.LIGHT_PURPLE, () -> ModFoodProperties.GOLDEN_CARP);
    public static final DeferredItem<BaseFoodItem> GRILLED_SQUIRREL = FoodItems.registerNormalFood("grilled_squirrel", ModRarity.BLUE, () -> ModFoodProperties.preparedMeatProperties(8, 12.8f));
    public static final DeferredItem<BaseFoodItem> LOBSTER_TAIL = FoodItems.registerNormalFood("lobster_tail", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> MONSTER_LASAGNA = FoodItems.registerNormalFood("monster_lasagna", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(9600, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> COOK_FISH = FoodItems.registerNormalFood("cook_fish", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(9600, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> SASHIMI = FoodItems.registerNormalFood("sashimi", ModRarity.WHITE, () -> ModFoodProperties.plentySatisfiedProperties(9600, 5, 3.0f));
    public static final DeferredItem<BaseFoodItem> ROASTED_BIRD = FoodItems.registerNormalFood("roasted_bird", ModRarity.BLUE, () -> ModFoodProperties.preparedMeatProperties(6, 3.6f));
    public static final DeferredItem<BaseFoodItem> ROASTED_DUCK = FoodItems.registerNormalFood("roasted_duck", ModRarity.GREEN, () -> ModFoodProperties.preparedMeatProperties(8, 7.2f));
    public static final DeferredItem<BaseFoodItem> SAUTEED_FROG_LEGS = FoodItems.registerNormalFood("sauteed_frog_legs", ModRarity.BLUE, () -> ModFoodProperties.preparedMeatProperties(8, 12.8f));
    public static final DeferredItem<BaseFoodItem> SEAFOOD_DINNER = FoodItems.registerNormalFood("seafood_dinner", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(16800, 8, 12.8f));
    public static final DeferredItem<BaseFoodItem> BACON = FoodItems.registerNormalFood("bacon", ModRarity.LIGHT_RED, () -> ModFoodProperties.exquisitelyStuffedProperties(28800, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> BANANA_SPLIT = FoodItems.registerNormalFood("banana_split", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(12000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> BBQ_RIBS = FoodItems.registerNormalFood("bbq_ribs", ModRarity.LIGHT_RED, () -> ModFoodProperties.exquisitelyStuffedProperties(28800, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> BURGER = FoodItems.registerNormalFood("burger", ModRarity.ORANGE, () -> ModFoodProperties.exquisitelyStuffedProperties(9600, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> CHICKEN_NUGGET = FoodItems.registerNormalFood("chicken_nugget", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(16800, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> CHOCOLATE_CHIP_COOKIE = FoodItems.registerNormalFood("chocolate_chip_cookie", ModRarity.ORANGE, () -> ModFoodProperties.plentySatisfiedProperties(24000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> FRIED_EGG = FoodItems.registerNormalFood("fried_egg", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(16800, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> FRIES = FoodItems.registerNormalFood("fries", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(12000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> HOTDOG = FoodItems.registerNormalFood("hotdog", ModRarity.ORANGE, () -> ModFoodProperties.exquisitelyStuffedProperties(24000, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> PIZZA = FoodItems.registerNormalFood("pizza", ModRarity.ORANGE, () -> ModFoodProperties.exquisitelyStuffedProperties(9600, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> POTATO_CHIPS = FoodItems.registerNormalFood("potato_chips", ModRarity.GREEN, () -> ModFoodProperties.wellFedProperties(30000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> SHRIMP_PO_BOY = FoodItems.registerNormalFood("shrimp_po_boy", ModRarity.ORANGE, () -> ModFoodProperties.plentySatisfiedProperties(21600, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> SHUCKED_OYSTER = FoodItems.registerNormalFood("shucked_oyster", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> SPAGHETTI = FoodItems.registerNormalFood("spaghetti", ModRarity.ORANGE, () -> ModFoodProperties.exquisitelyStuffedProperties(9600, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> SURPER_STEAK = FoodItems.registerNormalFood("surper_steak", ModRarity.LIGHT_RED, () -> ModFoodProperties.exquisitelyStuffedProperties(19200, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> APPLE_PIE = FoodItems.registerNormalFood("apple_pie", ModRarity.LIGHT_RED, () -> ModFoodProperties.exquisitelyStuffedProperties(19200, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> CHRISTMAS_PUDDING = FoodItems.registerNormalFood("christmas_pudding", ModRarity.ORANGE, () -> ModFoodProperties.exquisitelyStuffedProperties(4800, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> GINGERBREAD_COOKIE = FoodItems.registerNormalFood("gingerbread_cookie", ModRarity.ORANGE, () -> ModFoodProperties.exquisitelyStuffedProperties(4800, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> SUGAR_COOKIE = FoodItems.registerNormalFood("sugar_cookie", ModRarity.ORANGE, () -> ModFoodProperties.exquisitelyStuffedProperties(4800, 8, 5.5f));
    public static final DeferredItem<BaseFoodItem> MARSHMALLOW = FoodItems.registerNormalFood("marshmallow", ModRarity.WHITE, () -> ModFoodProperties.wellFedProperties(1200, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> COOKED_MARSHMALLOW = FoodItems.registerNormalFood("cooked_marshmallow", ModRarity.WHITE, () -> ModFoodProperties.wellFedProperties(2400, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> PAD_THAI = FoodItems.registerNormalFood("pad_thai", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(9600, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> BOWL_OF_SOUP = FoodItems.registerDrinkingFood("bowl_of_soup", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(9600, 6, 3.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> FRUIT_SALAD = FoodItems.registerDrinkingFood("fruit_salad", ModRarity.GREEN, () -> ModFoodProperties.wellFedProperties(30000, 4, 1.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> GRUB_SOUP = FoodItems.registerDrinkingFood("grub_soup", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(16000, 6, 3.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> NACHOS = FoodItems.registerDrinkingFood("nachos", ModRarity.ORANGE, () -> ModFoodProperties.plentySatisfiedProperties(19200, 6, 3.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> PHO = FoodItems.registerDrinkingFood("pho", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(12000, 6, 3.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> CLOUD_DOUGH = FoodItems.registerNormalFood("cloud_dough", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(1200, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> CLOUD_BREAD = FoodItems.registerNormalFood("cloud_bread", ModRarity.BLUE, () -> ModFoodProperties.hasEffectProperties(5, 0.6f, ModFoodPropertiesBuilder.EffectData.of(ModEffects.EXQUISITELY_STUFFED, 6000, 1), ModFoodPropertiesBuilder.EffectData.of((Holder<MobEffect>)MobEffects.SLOW_FALLING, 600, 1), ModFoodPropertiesBuilder.EffectData.of((Holder<MobEffect>)MobEffects.LEVITATION, 300, 1)));
    public static final DeferredItem<BaseFoodItem> FLUTTERING_LAMB_CHOPS = FoodItems.registerNormalFood("fluttering_lamb_chops", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(3, 1.8f));
    public static final DeferredItem<BaseFoodItem> COOKED_FLUTTERING_LAMB_CHOPS = FoodItems.registerNormalFood("cooked_fluttering_lamb_chops", ModRarity.BLUE, () -> ModFoodProperties.preparedMeatProperties(8, 12.8f));
    public static final DeferredItem<BaseFoodItem> BAOBAB_FRUIT = FoodItems.registerNormalFood("baobab_fruit", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(3, 1.8f));
    public static final DeferredItem<BaseFoodItem> COOKED_BAOBAB_FRUIT = FoodItems.registerNormalFood("cooked_baobab_fruit", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(5, 3.8f));
    public static final DeferredItem<BaseFoodItem.BItem> BOULDER_BREAD = FoodItems.registerBlockItemFood("boulder_bread", builder -> builder.rarity(ModRarity.GREEN).food(ModFoodProperties.hasEffectProperties(20, 2.5f, ModFoodPropertiesBuilder.EffectData.of(ModEffects.CHOKING, 6000))).duration(d -> 48).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT), ModBlocks.BOULDER_BREAD_BLOCK);
    public static final DeferredItem<BaseFoodItem> APRICOT = FoodItems.registerNormalFood("apricot", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> BANANA = FoodItems.registerNormalFood("banana", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> CHERRY = FoodItems.registerNormalFood("cherry", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> COCONUT = FoodItems.registerNormalFood("coconut", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> DRAGON_FRUIT = FoodItems.registerNormalFood("dragon_fruit", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> GRAPE_FRUIT = FoodItems.registerNormalFood("grape_fruit", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> LEMON = FoodItems.registerNormalFood("lemon", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> MANGO = FoodItems.registerNormalFood("mango", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> PEACH = FoodItems.registerNormalFood("peach", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> PINEAPPLE = FoodItems.registerNormalFood("pineapple", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> PLUM = FoodItems.registerNormalFood("plum", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> GRAPE = FoodItems.registerNormalFood("grape", ModRarity.BLUE, () -> ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> SPICY_PEPPER = FoodItems.registerNormalFood("spicy_pepper", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> STAR_FRUIT = FoodItems.registerNormalFood("star_fruit", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f));
    public static final DeferredItem<BaseFoodItem> POMEGRANATE = FoodItems.registerNormalFood("pomegranate", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> RAMBUTAN = FoodItems.registerNormalFood("rambutan", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> BLOOD_ORANGE = FoodItems.registerNormalFood("blood_orange", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> ELDERBERRY = FoodItems.registerNormalFood("elderberry", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> BLACKCURRANT = FoodItems.registerNormalFood("blackcurrant", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem> PEELED_SUGAR_TANGERINE = FoodItems.registerNormalFood("peeled_sugar_tangerine", ModRarity.RED, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem.BItem> SHIMMER_BERRIES = FoodItems.registerBlockItemFood("shimmer_berries", builder -> builder.rarity(ModRarity.GREEN).food(ModFoodProperties.noEffectProperties(3, 1.8f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT), NatureBlocks.SHIMMER_DROOPING_VINE);
    public static final DeferredItem<BaseFoodItem> FRUIT_JUICE = FoodItems.registerDrinkingFood("fruit_juice", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(18000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> APPLE_JUICE = FoodItems.registerDrinkingFood("apple_juice", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(12000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> FROZEN_BANANA_DAIQUIRI = FoodItems.registerDrinkingFood("frozen_banana_daiquiri", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(18000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> GRAPE_JUICE = FoodItems.registerDrinkingFood("grape_juice", ModRarity.LIGHT_RED, () -> ModFoodProperties.GOLDEN_CARP, 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> LEMONADE = FoodItems.registerDrinkingFood("lemonade", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(12000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> PEACH_SANGRIA = FoodItems.registerDrinkingFood("peach_sangria", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(12000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> PINA_COLADA = FoodItems.registerDrinkingFood("pina_colada", ModRarity.GREEN, () -> ModFoodProperties.wellFedProperties(24000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> PRISMATIC_PUNCH = FoodItems.registerDrinkingFood("prismatic_punch", ModRarity.ORANGE, () -> ModFoodProperties.plentySatisfiedProperties(24000, 6, 3.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> TROPICAL_SMOOTHIE = FoodItems.registerDrinkingFood("tropical_smoothie", ModRarity.GREEN, () -> ModFoodProperties.wellFedProperties(24000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> SMOOTHIE_OF_DARKNESS = FoodItems.registerDrinkingFood("smoothie_of_darkness", ModRarity.GREEN, () -> ModFoodProperties.wellFedProperties(24000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> BLOODY_MOSCATO = FoodItems.registerDrinkingFood("bloody_moscato", ModRarity.GREEN, () -> ModFoodProperties.wellFedProperties(24000, 4, 1.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> CREAM_SODA = FoodItems.registerDrinkingFood("cream_soda", ModRarity.ORANGE, () -> ModFoodProperties.plentySatisfiedProperties(19200, 6, 3.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> ICE_CREAM = FoodItems.registerDrinkingFood("ice_cream", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(16800, 6, 3.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> MILKSHAKE = FoodItems.registerDrinkingFood("milkshake", ModRarity.LIGHT_RED, () -> ModFoodProperties.exquisitelyStuffedProperties(19200, 8, 5.5f, (ItemLike)Items.GLASS_BOTTLE), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> BUNNY_STEW = FoodItems.registerDrinkingFood("bunny_stew", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(12000, 4, 1.5f, (ItemLike)Items.BOWL), 20, UseAnim.DRINK, SoundEvents.GENERIC_DRINK, SoundEvents.GENERIC_DRINK);
    public static final DeferredItem<BaseFoodItem> JOJA_COLA = FoodItems.registerDrinkingFood("joja_cola", ModRarity.WHITE, () -> ModFoodProperties.wellFedProperties(2400, 4, 1.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> CARTON_OF_MILK = FoodItems.registerDrinkingFood("carton_of_milk", ModRarity.GREEN, () -> ModFoodProperties.wellFedProperties(24000, 4, 1.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> TEACUP = FoodItems.registerDrinkingFood("teacup", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> COFFEE = FoodItems.registerDrinkingFood("coffee", ModRarity.GREEN, () -> ModFoodProperties.plentySatisfiedProperties(12000, 6, 3.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> SAKE = FoodItems.registerDrinkingFood("sake", ModRarity.BLUE, () -> ModFoodProperties.wellFedProperties(1200, 4, 1.5f), 20, UseAnim.DRINK, SoundEvents.HONEY_DRINK, SoundEvents.HONEY_DRINK);
    public static final DeferredItem<BaseFoodItem> GOLDFISH = FoodItems.registerNormalFood("goldfish", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> GOLD_GOLDFISH = FoodItems.registerNormalFood("gold_goldfish", ModRarity.ORANGE, () -> ModFoodProperties.GOLDEN_CARP);
    public static final DeferredItem<BaseFoodItem> SEA_BASS = FoodItems.registerNormalFood("sea_bass", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> ATLANTIC_COD = FoodItems.registerNormalFood("atlantic_cod", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> FROSTY_MINNOW = FoodItems.registerNormalFood("frosty_minnow", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> PISCES_FIN_COD = FoodItems.registerNormalFood("pisces_fin_cod", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> PARTIAL_MOUTH_FISH = FoodItems.registerNormalFood("partial_mouth_fish", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> ROCK_LOBSTER = FoodItems.registerNormalFood("rock_lobster", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> SHRIMP = FoodItems.registerNormalFood("shrimp", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> SALMON = FoodItems.registerNormalFood("salmon", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> TUNA = FoodItems.registerNormalFood("tuna", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> RED_SNAPPER = FoodItems.registerNormalFood("red_snapper", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> TROUT = FoodItems.registerNormalFood("trout", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> ARMORED_CAVE_FISH = FoodItems.registerNormalFood("armored_cave_fish", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> MIRROR_FISH = FoodItems.registerNormalFood("mirror_fish", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> STINKY_FISH = FoodItems.registerNormalFood("stinky_fish", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> NEON_GREASE_CARP = FoodItems.registerNormalFood("neon_grease_carp", ModRarity.WHITE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> DAMSEL_FISH = FoodItems.registerNormalFood("damsel_fish", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> EBONY_KOI = FoodItems.registerNormalFood("ebony_koi", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> SCARLET_TIGER_FISH = FoodItems.registerNormalFood("scarlet_tiger_fish", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> BLOODY_PIRANHAS = FoodItems.registerNormalFood("bloody_piranhas", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> PRINCESS_FISH = FoodItems.registerNormalFood("princess_fish", ModRarity.GREEN, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> COLORFUL_MINERAL_FISH = FoodItems.registerNormalFood("colorful_mineral_fish", ModRarity.ORANGE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> CHAOS_FISH = FoodItems.registerNormalFood("chaos_fish", ModRarity.LIGHT_RED, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> MOTTLED_OILFISH = FoodItems.registerNormalFood("mottled_oilfish", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> YELLOW_EEL = FoodItems.registerNormalFood("yellow_eel", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> TILAPIA = FoodItems.registerNormalFood("tilapia", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(2, 0.4f));
    public static final DeferredItem<BaseFoodItem> RED_PLEATFISH = FoodItems.registerNormalFood("red_pleatfish", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(4, 1.8f));
    public static final DeferredItem<BaseFoodItem> BROWN_STALKSPINE = FoodItems.registerNormalFood("brown_stalkspine", ModRarity.BLUE, () -> ModFoodProperties.noEffectProperties(4, 1.8f));
    public static final DeferredItem<BaseFoodItem> GOLDEN_CARP = FoodItems.registerNormalFood("golden_carp", ModRarity.LIGHT_RED, () -> ModFoodProperties.GOLDEN_CARP);
    public static final DeferredItem<BaseFoodItem> OBSIDIFISH = FoodItems.registerFood("obsidifish", builder -> builder.rarity(ModRarity.WHITE).food(ModFoodProperties.noEffectProperties(2, 0.4f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT).isFireResistant());
    public static final DeferredItem<BaseFoodItem> FLASHFIN_KOI = FoodItems.registerFood("flashfin_koi", builder -> builder.rarity(ModRarity.GREEN).food(ModFoodProperties.noEffectProperties(2, 0.4f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT).isFireResistant());
    public static final DeferredItem<BaseFoodItem> HONEYFIN = FoodItems.registerFood("honeyfin", builder -> builder.rarity(ModRarity.BLUE).food(ModFoodProperties.noEffectProperties(1, 1.0f)).setFinishUsingCallback((TriConsumer<ItemStack, Level, LivingEntity>)((TriConsumer)(k, l, p) -> {
        if (!l.isClientSide && !p.hasEffect(ModEffects.POTION_SICKNESS)) {
            p.heal(24.0f);
            p.addEffect(new MobEffectInstance(ModEffects.POTION_SICKNESS, 1200));
        }
    })));
    public static final DeferredItem<BaseFoodItem> PINK_COLA = FoodItems.registerToolTipFood("pink_cola", builder -> builder.rarity(ModRarity.EXPERT).food(ModFoodProperties.hasEffectProperties(1, 0.5f, ModFoodPropertiesBuilder.EffectData.of((Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 1200), ModFoodPropertiesBuilder.EffectData.of((Holder<MobEffect>)MobEffects.REGENERATION, 1200))).drinkingSound(s -> SoundEvents.GENERIC_DRINK).duration(d -> 15).useAnim(u -> UseAnim.DRINK), 1, ChatFormatting.GRAY);
    public static final DeferredItem<BaseFoodItem> DONGDONGS_FLATBREAD = FoodItems.registerToolTipFood("dongdongs_flatbread", builder -> builder.rarity(ModRarity.EXPERT).food(ModFoodProperties.hasEffectProperties(5, 0.2f, ModFoodPropertiesBuilder.EffectData.of(ModEffects.EXQUISITELY_STUFFED, 3000))).eatingSound(s -> SoundEvents.GENERIC_EAT).duration(d -> 15).useAnim(u -> UseAnim.EAT), 1, ChatFormatting.GRAY);
    public static final DeferredItem<BaseFoodItem> PIGLIN_STEW = FoodItems.registerToolTipFood("piglin_stew", builder -> builder.rarity(ModRarity.EXPERT).food(ModFoodProperties.hasEffectProperties(20, 80.0f, ModFoodPropertiesBuilder.EffectData.of((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 1200, 4))).eatingSound(s -> SoundEvents.GENERIC_EAT).duration(d -> 15).useAnim(u -> UseAnim.EAT), 1, ChatFormatting.GRAY);
    public static final DeferredItem<BaseFoodItem> ZONGZI = FoodItems.registerFood("zongzi", builder -> builder.rarity(ModRarity.RED).food(ModFoodProperties.wellFedProperties(6000, 4, 1.5f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT).isFireResistant());
    public static final DeferredItem<BaseFoodItem> MEAT_STUFFED_ZONGZI = FoodItems.registerFood("meat_stuffed_zongzi", builder -> builder.rarity(ModRarity.RED).food(ModFoodProperties.wellFedProperties(6000, 5, 3.0f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT).isFireResistant());
    public static final DeferredItem<BaseFoodItem> HONEY_MOONCAKES = FoodItems.registerFood("honey_mooncakes", builder -> builder.rarity(ModRarity.RED).food(ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT).isFireResistant());
    public static final DeferredItem<BaseFoodItem> HONEY_MOONCAKES_CHUNKS = FoodItems.registerFood("honey_mooncakes_chunks", builder -> builder.rarity(ModRarity.RED).food(ModFoodProperties.noEffectProperties(1, 0.75f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT).isFireResistant());
    public static final DeferredItem<BaseFoodItem> EGG_YOLK_MOONCAKES = FoodItems.registerFood("egg_yolk_mooncakes", builder -> builder.rarity(ModRarity.RED).food(ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT).isFireResistant());
    public static final DeferredItem<BaseFoodItem> EGG_YOLK_MOONCAKES_CHUNKS = FoodItems.registerFood("egg_yolk_mooncakes_chunks", builder -> builder.rarity(ModRarity.RED).food(ModFoodProperties.plentySatisfiedProperties(6000, 6, 3.5f)).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT).isFireResistant());
    public static final DeferredItem<BaseFoodItem> LONGEVITY_NOODLES = FoodItems.registerNormalFood("longevity_noodles", ModRarity.RED, () -> ModFoodProperties.wellFedProperties(6000, 4, 1.5f));
    public static final DeferredItem<BaseFoodItem.BItem> GREEN_DUMPLING = FoodItems.registerBlockItemFood("green_dumpling", builder -> builder.rarity(ModRarity.RED).food(ModFoodProperties.plentySatisfiedProperties(6000, 3, 1.5f)).duration(d -> 48).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT), ModBlocks.GREEN_DUMPLING_BLOCK);
    public static final DeferredItem<Item> STELLAR_BLOSSOM_SEED = ITEMS.register("stellar_blossom_seed", () -> new ItemNameBlockItem((Block)NatureBlocks.STELLAR_BLOSSOM.get(), new Item.Properties()));
    public static final DeferredItem<Item> CLOUDWEAVER_SEED = ITEMS.register("cloudweaver_seed", () -> new ItemNameBlockItem((Block)NatureBlocks.CLOUDWEAVER.get(), new Item.Properties()));
    public static final DeferredItem<Item> FLOATING_WHEAT_SEED = ITEMS.register("floating_wheat_seed", () -> new ItemNameBlockItem((Block)NatureBlocks.FLOATING_WHEAT.get(), new Item.Properties()));
    public static final DeferredItem<Item> WATERLEAF_SEED = ITEMS.register("waterleaf_seed", () -> new HerbSeedItem((Block)ModBlocks.WATERLEAF.get()));
    public static final DeferredItem<Item> FIREBLOSSOM_SEED = ITEMS.register("fireblossom_seed", () -> new HerbSeedItem((Block)ModBlocks.FIREBLOSSOM.get(), new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> MOONGLOW_SEED = ITEMS.register("moonglow_seed", () -> new HerbSeedItem((Block)ModBlocks.MOONGLOW.get()));
    public static final DeferredItem<Item> BLINKROOT_SEED = ITEMS.register("blinkroot_seed", () -> new HerbSeedItem((Block)ModBlocks.BLINKROOT.get()));
    public static final DeferredItem<Item> SHIVERTHORN_SEED = ITEMS.register("shiverthorn_seed", () -> new HerbSeedItem((Block)ModBlocks.SHIVERTHORN.get()));
    public static final DeferredItem<Item> DAYBLOOM_SEED = ITEMS.register("daybloom_seed", () -> new HerbSeedItem((Block)ModBlocks.DAYBLOOM.get()));
    public static final DeferredItem<Item> DEATHWEED_SEED = ITEMS.register("deathweed_seed", () -> new HerbSeedItem((Block)ModBlocks.DEATHWEED.get()));

    public static DeferredItem<BaseFoodItem> registerFood(String name, Consumer<BaseFoodItem.Builder> consumer) {
        return ITEMS.register(name, () -> {
            BaseFoodItem.Builder builder = BaseFoodItem.builder().stackTo(64);
            consumer.accept(builder);
            return builder.build();
        });
    }

    public static DeferredItem<BaseFoodItem.BItem> registerBlockItemFood(String name, Consumer<BaseFoodItem.Builder> consumer, Supplier<? extends Block> block) {
        return ITEMS.register(name, () -> {
            BaseFoodItem.Builder builder = BaseFoodItem.builder().stackTo(64);
            consumer.accept(builder);
            return new BaseFoodItem.BItem((Block)block.get(), builder.getProperties());
        });
    }

    public static DeferredItem<BaseFoodItem> registerToolTipFood(String name, Consumer<BaseFoodItem.Builder> consumer, int line, ChatFormatting chatFormatting) {
        return ITEMS.register(name, () -> {
            BaseFoodItem.Builder builder = BaseFoodItem.builder().stackTo(64).tooltip(name, line, chatFormatting);
            consumer.accept(builder);
            return builder.build();
        });
    }

    public static DeferredItem<BaseFoodItem> registerNormalFood(String name, ModRarity rarity, Supplier<FoodProperties> foodProperties) {
        return ITEMS.register(name, () -> {
            BaseFoodItem.Builder builder = BaseFoodItem.builder().rarity(rarity).stackTo(64).food((FoodProperties)foodProperties.get()).duration(d -> 15).useAnim(u -> UseAnim.EAT).eatingSound(s -> SoundEvents.GENERIC_EAT);
            return builder.build();
        });
    }

    public static DeferredItem<BaseFoodItem> registerDrinkingFood(String name, ModRarity rarity, Supplier<FoodProperties> foodProperties, int duration, UseAnim useAnim, SoundEvent drinkingSoundType, SoundEvent eatingSoundType) {
        return ITEMS.register(name, () -> {
            BaseFoodItem.Builder builder = BaseFoodItem.builder().rarity(rarity).stackTo(64).food((FoodProperties)foodProperties.get()).duration(d -> duration).useAnim(u -> useAnim).drinkingSound(s -> drinkingSoundType).eatingSound(e -> eatingSoundType);
            return builder.build();
        });
    }
}

