/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.confluence.mod.common.init.item.ArrowItems;
import org.confluence.mod.common.init.item.BoatItems;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.item.common.SpongeItem;

public class DispenserRegistration {
    public static void boostrap() {
        final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();
        DefaultDispenseItemBehavior simpleFluidOut = new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource source, ItemStack itemStack) {
                DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)itemStack.getItem();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = source.level();
                if (dispensiblecontaineritem.emptyContents(null, (Level)level, blockpos, null, itemStack)) {
                    dispensiblecontaineritem.checkExtraContent(null, (Level)level, itemStack, blockpos);
                    return this.consumeWithRemainder(source, itemStack, new ItemStack((ItemLike)Items.BUCKET));
                }
                return defaultBehavior.dispense(source, itemStack);
            }
        };
        DefaultDispenseItemBehavior bottomlessFluidOut = new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource source, ItemStack itemStack) {
                DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)itemStack.getItem();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = source.level();
                if (dispensiblecontaineritem.emptyContents(null, (Level)level, blockpos, null, itemStack)) {
                    dispensiblecontaineritem.checkExtraContent(null, (Level)level, itemStack, blockpos);
                    return itemStack;
                }
                return defaultBehavior.dispense(source, itemStack);
            }
        };
        DefaultDispenseItemBehavior spongeAbsorbLiquid = new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource source, ItemStack itemStack) {
                SpongeItem spongeItem = (SpongeItem)itemStack.getItem();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = source.level();
                spongeItem.tryAbsorbLiquid((Level)level, blockpos);
                return itemStack;
            }
        };
        DispenserBlock.registerBehavior((ItemLike)ToolItems.HONEY_BUCKET.asItem(), (DispenseItemBehavior)simpleFluidOut);
        DispenserBlock.registerBehavior((ItemLike)ToolItems.BOTTOMLESS_WATER_BUCKET.asItem(), (DispenseItemBehavior)bottomlessFluidOut);
        DispenserBlock.registerBehavior((ItemLike)ToolItems.BOTTOMLESS_LAVA_BUCKET.asItem(), (DispenseItemBehavior)bottomlessFluidOut);
        DispenserBlock.registerBehavior((ItemLike)ToolItems.BOTTOMLESS_HONEY_BUCKET.asItem(), (DispenseItemBehavior)bottomlessFluidOut);
        DispenserBlock.registerBehavior((ItemLike)ToolItems.BOTTOMLESS_SHIMMER_BUCKET.asItem(), (DispenseItemBehavior)bottomlessFluidOut);
        DispenserBlock.registerBehavior((ItemLike)ToolItems.SUPER_ABSORBANT_SPONGE.asItem(), (DispenseItemBehavior)spongeAbsorbLiquid);
        DispenserBlock.registerBehavior((ItemLike)ToolItems.HONEY_ABSORBANT_SPONGE.asItem(), (DispenseItemBehavior)spongeAbsorbLiquid);
        DispenserBlock.registerBehavior((ItemLike)ToolItems.LAVA_ABSORBANT_SPONGE.asItem(), (DispenseItemBehavior)spongeAbsorbLiquid);
        DispenserBlock.registerBehavior((ItemLike)ToolItems.ULTRA_ABSORBANT_SPONGE.asItem(), (DispenseItemBehavior)spongeAbsorbLiquid);
        BoatItems.BOAT_ITEMS.getEntries().stream().map(DeferredHolder::get).forEach(boatItem -> DispenserBlock.registerBehavior((ItemLike)boatItem, (DispenseItemBehavior)new BoatDispenseItemBehavior(((BoatItem)boatItem).type)));
        BoatItems.CHEST_BOAT_ITEMS.getEntries().stream().map(DeferredHolder::get).forEach(chestBoatItem -> DispenserBlock.registerBehavior((ItemLike)chestBoatItem, (DispenseItemBehavior)new BoatDispenseItemBehavior(((BoatItem)chestBoatItem).type, true)));
        ArrowItems.ITEMS.getEntries().stream().map(DeferredHolder::get).forEach(DispenserBlock::registerProjectileBehavior);
    }
}

