/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.entity.fishing.CurioFishingHook;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.accessory.FishingBobber;
import org.confluence.mod.common.item.accessory.GuideVooDooDollItem;
import org.confluence.mod.common.item.accessory.MechanicalLens;
import org.confluence.mod.common.item.accessory.PickupRangeAbilityValue;
import org.confluence.mod.common.item.accessory.RadioThing;
import org.confluence.mod.common.item.accessory.SpectreGoggles;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terra_curio.api.primitive.CombineRule;
import org.confluence.terra_curio.api.primitive.FloatValue;
import org.confluence.terra_curio.api.primitive.IntegerValue;
import org.confluence.terra_curio.api.primitive.MayFlyAbilityValue;
import org.confluence.terra_curio.api.primitive.UnitValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.component.PrimitiveValueComponent;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.init.TCTags;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terra_curio.common.item.curio.health.BandOfRegeneration;
import org.confluence.terra_curio.util.TCUtils;
import org.confluence.terraentity.init.TEAttributes;

public class AccessoryItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final List<DeferredItem<BaseCurioItem>> WINGS = new ArrayList<DeferredItem<BaseCurioItem>>();
    public static final ValueType<Unit, UnitValue> LUCKY$COIN = ValueType.ofUnit((String)"lucky_coin");
    public static final ValueType<Unit, UnitValue> VINE$ROPE = ValueType.ofUnit((String)"vine_rope");
    public static final ValueType<Unit, UnitValue> AUTO$GET$MANA = ValueType.ofUnit((String)"auto_get_mama");
    public static final ValueType<Unit, UnitValue> HURT$GET$MANA = ValueType.ofUnit((String)"hurt_get_mana");
    public static final ValueType<Unit, UnitValue> FAST$MANA$GENERATION = ValueType.ofUnit((String)"faset_mana_regeneration");
    public static final ValueType<Unit, UnitValue> HIGH$TEST$FISHING$LINE = ValueType.ofUnit((String)"high_test_fishing_line");
    public static final ValueType<Unit, UnitValue> TACKLE$BOX = ValueType.ofUnit((String)"tackle_box");
    public static final ValueType<Unit, UnitValue> LAVAPROOF$FISHING$HOOK = ValueType.ofUnit((String)"lavaproof_fishing_hook");
    public static final ValueType<Unit, UnitValue> SPECTRE$GOGGLES = ValueType.ofUnit((String)"spectre_goggles");
    public static final ValueType<Unit, UnitValue> PAINT$SPRAYER = ValueType.ofUnit((String)"paint_sprayer");
    public static final ValueType<Unit, UnitValue> CLOTHIER$KILLER = ValueType.ofUnit((String)"clothier_killer");
    public static final ValueType<Float, FloatValue> MANA$USE$REDUCE = ValueType.ofFloat((String)"mana_use_reduce", (CombineRule)FloatValue.ADDITION_WITHIN_0_TO_1, (float)0.0f);
    public static final ValueType<Float, FloatValue> REDUCE$HEALING$COOLDOWN = ValueType.ofFloat((String)"reduce_healing_cooldown", (CombineRule)FloatValue.ADDITION_WITHIN_0_TO_1, (float)0.0f);
    public static final ValueType<Float, FloatValue> FISHING$POWER = ValueType.ofFloat((String)"fishing_power", (CombineRule)FloatValue.ADDITION, (float)0.0f);
    public static final ValueType<Integer, IntegerValue> ADDITIONAL$MANA = ValueType.ofInteger((String)"additional_mana", (CombineRule)IntegerValue.ADDITION, (int)0);
    public static final ValueType<Integer, IntegerValue> SPECIAL$PRICE = ValueType.ofInteger((String)"special_price", (CombineRule)IntegerValue.GET_MAX, (int)0);
    public static final ValueType<Tuple<Float, Integer>, PickupRangeAbilityValue> MANA$PICKUP$RANGE = ValueType.create((String)"mana_pickup_range", PickupRangeAbilityValue.COMBINE_RULE, PickupRangeAbilityValue.CODEC, (Object)new Tuple((Object)Float.valueOf(1.75f), (Object)0), PickupRangeAbilityValue::new);
    public static final ValueType<Tuple<Float, Integer>, PickupRangeAbilityValue> COIN$PICKUP$RANGE = ValueType.create((String)"coin_pickup_range", PickupRangeAbilityValue.COMBINE_RULE, PickupRangeAbilityValue.CODEC, (Object)new Tuple((Object)Float.valueOf(2.0f), (Object)0), PickupRangeAbilityValue::new);
    public static final DeferredItem<BaseCurioItem> ADHESIVE_BANDAGE = AccessoryItems.registerCurio("adhesive_bandage", builder -> builder.rarity(ModRarity.LIGHT_RED).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(ModEffects.BLEEDING)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> MEDICATED_BANDAGE = AccessoryItems.registerCurio("medicated_bandage", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(MobEffects.POISON, ModEffects.BLEEDING)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> POCKET_MIRROR = AccessoryItems.registerCurio("pocket_mirror", builder -> builder.rarity(ModRarity.ORANGE).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(ModEffects.STONED)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> REFLECTIVE_SHADES = AccessoryItems.registerCurio("reflective_shades", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(MobEffects.BLINDNESS, ModEffects.STONED)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> ARMOR_POLISH = AccessoryItems.registerCurio("armor_polish", builder -> builder.rarity(ModRarity.LIGHT_RED).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(ModEffects.BROKEN_ARMOR)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> ARMOR_BRACING = AccessoryItems.registerCurio("armor_bracing", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(MobEffects.WEAKNESS, ModEffects.BROKEN_ARMOR)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> MEGAPHONE = AccessoryItems.registerCurio("megaphone", builder -> builder.rarity(ModRarity.LIGHT_RED).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(ModEffects.SILENCED)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> NAZAR = AccessoryItems.registerCurio("nazar", builder -> builder.rarity(ModRarity.GREEN).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(ModEffects.CURSED)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> COUNTERCURSE_MANTRA = AccessoryItems.registerCurio("countercurse_mantra", builder -> builder.rarity(ModRarity.LIGHT_RED).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(ModEffects.SILENCED, ModEffects.CURSED)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> NATURES_GIFT = AccessoryItems.registerCurio("natures_gift", builder -> builder.rarity(ModRarity.ORANGE).accessories(PrimitiveValueComponent.of(MANA$USE$REDUCE, (Object)Float.valueOf(0.06f)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> MANA_FLOWER = AccessoryItems.registerCurio("mana_flower", builder -> builder.tooltips(1).rarity(ModRarity.LIGHT_RED).accessories(PrimitiveValueComponent.units(AUTO$GET$MANA, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(MANA$USE$REDUCE, (Object)Float.valueOf(0.08f))}));
    public static final DeferredItem<BaseCurioItem> CELESTIAL_MAGNET = AccessoryItems.registerCurio("celestial_magnet", builder -> builder.rarity(ModRarity.LIGHT_RED).accessories(PrimitiveValueComponent.of(MANA$PICKUP$RANGE, (Object)new Tuple((Object)Float.valueOf(12.5f), (Object)0)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> CELESTIAL_EMBLEM = AccessoryItems.registerCurio("celestial_emblem", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.of(MANA$PICKUP$RANGE, (Object)new Tuple((Object)Float.valueOf(12.5f), (Object)0)), new PrimitiveValueComponent[0]).attribute(TCAttributes.getMagicDamage(), 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredItem<BaseCurioItem> MAGNET_FLOWER = AccessoryItems.registerCurio("magnet_flower", builder -> builder.tooltips(2).rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.units(AUTO$GET$MANA, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(MANA$USE$REDUCE, (Object)Float.valueOf(0.08f)), PrimitiveValueComponent.of(MANA$PICKUP$RANGE, (Object)new Tuple((Object)Float.valueOf(12.5f), (Object)0))}));
    public static final DeferredItem<BaseCurioItem> ARCANE_FLOWER = AccessoryItems.registerCurio("arcane_flower", builder -> builder.tooltips(2).rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.units(AUTO$GET$MANA, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(MANA$USE$REDUCE, (Object)Float.valueOf(0.08f))}).attribute((Holder)TCAttributes.AGGRO, -400.0, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseCurioItem> BAND_OF_STARPOWER = AccessoryItems.registerCurio("band_of_starpower", builder -> builder.accessories(PrimitiveValueComponent.of(ADDITIONAL$MANA, (Object)20), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> MANA_REGENERATION_BAND = AccessoryItems.registerCurio("mana_regeneration_band", builder -> builder.tooltips(1).accessories(PrimitiveValueComponent.units(FAST$MANA$GENERATION, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(ADDITIONAL$MANA, (Object)20)}));
    public static final DeferredItem<BaseCurioItem> MAGIC_CUFFS = AccessoryItems.registerCurio("magic_cuffs", builder -> builder.tooltips(1).rarity(ModRarity.GREEN).accessories(PrimitiveValueComponent.units(HURT$GET$MANA, (ValueType[])new ValueType[]{FAST$MANA$GENERATION}), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(ADDITIONAL$MANA, (Object)20)}));
    public static final DeferredItem<BaseCurioItem> CELESTIAL_CUFFS = AccessoryItems.registerCurio("celestial_cuffs", builder -> builder.tooltips(2).rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.units(HURT$GET$MANA, (ValueType[])new ValueType[]{FAST$MANA$GENERATION}), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(ADDITIONAL$MANA, (Object)20), PrimitiveValueComponent.of(MANA$PICKUP$RANGE, (Object)new Tuple((Object)Float.valueOf(12.5f), (Object)0))}));
    public static final DeferredItem<BaseCurioItem> MANA_CLOAK = AccessoryItems.registerCurio("mana_cloak", builder -> builder.tooltips(3).rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.units(AUTO$GET$MANA, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[]{PrimitiveValueComponent.of((ValueType)TCItems.STAR$CLOCK, (Object)true), PrimitiveValueComponent.of(MANA$USE$REDUCE, (Object)Float.valueOf(0.08f))}));
    public static final DeferredItem<BaseCurioItem> PHILOSOPHERS_STONE = AccessoryItems.registerCurio("philosophers_stone", builder -> builder.rarity(ModRarity.LIGHT_RED).accessories(PrimitiveValueComponent.of(REDUCE$HEALING$COOLDOWN, (Object)Float.valueOf(0.25f)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> CHARM_OF_MYTHS = AccessoryItems.registerDirectly("charm_of_myths", name -> new BandOfRegeneration(BaseCurioItem.builder((String)name).rarity(ModRarity.LIGHT_PURPLE).accessories(PrimitiveValueComponent.of(REDUCE$HEALING$COOLDOWN, (Object)Float.valueOf(0.25f)), new PrimitiveValueComponent[0])));
    public static final DeferredItem<BaseCurioItem> HIGH_TEST_FISHING_LINE = AccessoryItems.registerCurio("high_test_fishing_line", builder -> builder.accessories(PrimitiveValueComponent.units(HIGH$TEST$FISHING$LINE, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> TACKLE_BOX = AccessoryItems.registerCurio("tackle_box", builder -> builder.accessories(PrimitiveValueComponent.units(TACKLE$BOX, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> ANGLER_TACKLE_BAG = AccessoryItems.registerCurio("angler_tackle_bag", builder -> builder.rarity(ModRarity.ORANGE).accessories(PrimitiveValueComponent.units(HIGH$TEST$FISHING$LINE, (ValueType[])new ValueType[]{TACKLE$BOX}), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(FISHING$POWER, (Object)Float.valueOf(10.0f))}));
    public static final DeferredItem<BaseCurioItem> LAVAPROOF_FISHING_HOOK = AccessoryItems.registerCurio("lavaproof_fishing_hook", builder -> builder.rarity(ModRarity.LIME).accessories(PrimitiveValueComponent.units(LAVAPROOF$FISHING$HOOK, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> LAVAPROOF_TACKLE_BAG = AccessoryItems.registerCurio("lavaproof_tackle_bag", builder -> builder.rarity(ModRarity.YELLOW).tooltips(1).accessories(PrimitiveValueComponent.units(HIGH$TEST$FISHING$LINE, (ValueType[])new ValueType[]{TACKLE$BOX, LAVAPROOF$FISHING$HOOK}), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(FISHING$POWER, (Object)Float.valueOf(10.0f))}));
    public static final DeferredItem<BaseCurioItem> FISHING_BOBBER = ITEMS.register("fishing_bobber", () -> new FishingBobber(CurioFishingHook.Variant.COMMON));
    public static final DeferredItem<BaseCurioItem> GLOWING_FISHING_BOBBER = ITEMS.register("glowing_fishing_bobber", () -> new FishingBobber(CurioFishingHook.Variant.GLOWING));
    public static final DeferredItem<BaseCurioItem> LAVA_MOSS_FISHING_BOBBER = ITEMS.register("lava_moss_fishing_bobber", () -> new FishingBobber(CurioFishingHook.Variant.LAVA));
    public static final DeferredItem<BaseCurioItem> HELIUM_MOSS_FISHING_BOBBER = ITEMS.register("helium_moss_fishing_bobber", () -> new FishingBobber(CurioFishingHook.Variant.HELIUM));
    public static final DeferredItem<BaseCurioItem> NEON_MOSS_FISHING_BOBBER = ITEMS.register("neon_moss_fishing_bobber", () -> new FishingBobber(CurioFishingHook.Variant.NEON));
    public static final DeferredItem<BaseCurioItem> ARGON_MOSS_FISHING_BOBBER = ITEMS.register("argon_moss_fishing_bobber", () -> new FishingBobber(CurioFishingHook.Variant.ARGON));
    public static final DeferredItem<BaseCurioItem> KRYPTON_MOSS_FISHING_BOBBER = ITEMS.register("krypton_moss_fishing_bobber", () -> new FishingBobber(CurioFishingHook.Variant.KRYPTON));
    public static final DeferredItem<BaseCurioItem> XENON_MOSS_FISHING_BOBBER = ITEMS.register("xenon_moss_fishing_bobber", () -> new FishingBobber(CurioFishingHook.Variant.XENON));
    public static final DeferredItem<BaseCurioItem> MECHANICAL_LENS = AccessoryItems.registerDirectly("mechanical_lens", name -> new MechanicalLens(BaseCurioItem.builder((String)"mechanical_lens").rarity(ModRarity.ORANGE).tooltips(1).accessories(PrimitiveValueComponent.of((ValueType)TCItems.INFORMATION, List.of(TCItems.MECHANICAL$LENS)), new PrimitiveValueComponent[0])));
    public static final DeferredItem<BaseCurioItem> PAINT_SPRAYER = AccessoryItems.registerCurio("paint_sprayer", builder -> builder.rarity(ModRarity.ORANGE).accessories(PrimitiveValueComponent.units(PAINT$SPRAYER, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> LUCKY_COIN = AccessoryItems.registerCurio("lucky_coin", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.units(LUCKY$COIN, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[0]).attribute(Attributes.LUCK, 0.05, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseCurioItem> GOLD_RING = AccessoryItems.registerCurio("gold_ring", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.of(COIN$PICKUP$RANGE, (Object)new Tuple((Object)Float.valueOf(14.67f), (Object)0)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> COIN_RING = AccessoryItems.registerCurio("coin_ring", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.units(LUCKY$COIN, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(COIN$PICKUP$RANGE, (Object)new Tuple((Object)Float.valueOf(14.67f), (Object)0))}).attribute(Attributes.LUCK, 0.05, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseCurioItem> DISCOUNT_CARD = AccessoryItems.registerCurio("discount_card", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.of(SPECIAL$PRICE, (Object)1), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> GREEDY_RING = AccessoryItems.registerCurio("greedy_ring", builder -> builder.rarity(ModRarity.LIGHT_PURPLE).accessories(PrimitiveValueComponent.units(LUCKY$COIN, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[]{PrimitiveValueComponent.of(COIN$PICKUP$RANGE, (Object)new Tuple((Object)Float.valueOf(14.67f), (Object)0)), PrimitiveValueComponent.of(SPECIAL$PRICE, (Object)1)}).attribute(Attributes.LUCK, 0.05, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseCurioItem> GUIDE_TO_PLANT_FIBER_CORDAGE = AccessoryItems.registerCurio("guide_to_plant_fiber_cordage", builder -> builder.accessories(PrimitiveValueComponent.units(VINE$ROPE, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> RADIO_THING = AccessoryItems.registerDirectly("radio_thing", name -> new RadioThing(BaseCurioItem.builder((String)name).rarity(ModRarity.BLUE).tooltips(1)));
    public static final DeferredItem<BaseCurioItem> SPECTRE_GOGGLES = AccessoryItems.registerDirectly("spectre_goggles", name -> new SpectreGoggles(BaseCurioItem.builder((String)name).rarity(ModRarity.PINK).tooltips(1).accessories(PrimitiveValueComponent.units(SPECTRE$GOGGLES, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[0])));
    public static final DeferredItem<BaseCurioItem> CHROMATIC_CLOAK = AccessoryItems.registerCurio("chromatic_cloak", builder -> builder.rarity(ModRarity.PINK).accessories(PrimitiveValueComponent.of((ValueType)TCItems.EFFECT$IMMUNITIES, Set.of(ModEffects.SHIMMER)), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> SUMMONER_EMBLEM = AccessoryItems.registerCurio("summoner_emblem", builder -> builder.noTooltip().rarity(ModRarity.LIGHT_RED).attribute(TEAttributes.SUMMON_DAMAGE, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredItem<BaseCurioItem> APPRENTICES_SCARF = AccessoryItems.registerCurio("apprentices_scarf", builder -> builder.noTooltip().rarity(ModRarity.PINK).attribute(TEAttributes.SENTRY_CAPACITY, 1.0, AttributeModifier.Operation.ADD_VALUE).attribute(TEAttributes.SUMMON_DAMAGE, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredItem<BaseCurioItem> SQUIRES_SHIELD = AccessoryItems.registerCurio("squires_shield", builder -> builder.noTooltip().rarity(ModRarity.PINK).attribute(TEAttributes.SENTRY_CAPACITY, 1.0, AttributeModifier.Operation.ADD_VALUE).attribute(TEAttributes.SUMMON_DAMAGE, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredItem<BaseCurioItem> HUNTRESSS_BUCKLER = AccessoryItems.registerCurio("huntresss_buckler", builder -> builder.noTooltip().rarity(ModRarity.PINK).attribute(TEAttributes.SENTRY_CAPACITY, 1.0, AttributeModifier.Operation.ADD_VALUE).attribute(TEAttributes.SUMMON_DAMAGE, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredItem<BaseCurioItem> MONKS_BELT = AccessoryItems.registerCurio("monks_belt", builder -> builder.rarity(ModRarity.PINK).noTooltip().attribute(TEAttributes.SENTRY_CAPACITY, 1.0, AttributeModifier.Operation.ADD_VALUE).attribute(TEAttributes.SUMMON_DAMAGE, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredItem<BaseCurioItem> HERCULES_BEETLE = AccessoryItems.registerCurio("hercules_beetle", builder -> builder.noTooltip().rarity(ModRarity.LIME).attribute(TEAttributes.SUMMON_DAMAGE, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).attribute(TEAttributes.SUMMON_KNOCKBACK, 2.0, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseCurioItem> NECROMANTIC_SCROLL = AccessoryItems.registerCurio("necromantic_scroll", builder -> builder.noTooltip().rarity(ModRarity.YELLOW).attribute(TEAttributes.MINION_CAPACITY, 1.0, AttributeModifier.Operation.ADD_VALUE).attribute(TEAttributes.SUMMON_DAMAGE, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredItem<BaseCurioItem> PAPYRUS_SCARAB = AccessoryItems.registerCurio("papyrus_scarab", builder -> builder.noTooltip().rarity(ModRarity.YELLOW).attribute(TEAttributes.MINION_CAPACITY, 1.0, AttributeModifier.Operation.ADD_VALUE).attribute(TEAttributes.SUMMON_DAMAGE, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).attribute(TEAttributes.SUMMON_KNOCKBACK, 2.0, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseCurioItem> PYGMY_NECKLACE = AccessoryItems.registerCurio("pygmy_necklace", builder -> builder.noTooltip().rarity(ModRarity.LIME).attribute(TEAttributes.MINION_CAPACITY, 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseCurioItem> FLEDGLING_WINGS = AccessoryItems.registerWings("fledgling_wings", ModRarity.WHITE, 0.3f, 28, true, false);
    public static final DeferredItem<BaseCurioItem> ANGEL_WINGS = AccessoryItems.registerWings("angel_wings", ModRarity.PINK, 0.6f, 50, true, false);
    public static final DeferredItem<BaseCurioItem> DEMON_WINGS = AccessoryItems.registerWings("demon_wings", ModRarity.PINK, 0.6f, 50, true, false);
    public static final DeferredItem<BaseCurioItem> FAIRY_WINGS = AccessoryItems.registerWings("fairy_wings", ModRarity.PINK, 0.65f, 56, true, false);
    public static final DeferredItem<BaseCurioItem> FIN_WINGS = AccessoryItems.registerWings("fin_wings", ModRarity.LIGHT_RED, 0.65f, 56, true, false);
    public static final DeferredItem<BaseCurioItem> FROZEN_WINGS = AccessoryItems.registerWings("frozen_wings", ModRarity.PINK, 0.65f, 56, true, false);
    public static final DeferredItem<BaseCurioItem> HARPY_WINGS = AccessoryItems.registerWings("harpy_wings", ModRarity.PINK, 0.65f, 56, true, false);
    public static final DeferredItem<BaseCurioItem> JETPACK = AccessoryItems.registerWings("jetpack", ModRarity.PINK, 0.65f, 63, true, false);
    public static final DeferredItem<BaseCurioItem> LEAF_WINGS = AccessoryItems.registerWings("leaf_wings", ModRarity.PINK, 0.6f, 50, true, false);
    public static final DeferredItem<BaseCurioItem> BAT_WINGS = AccessoryItems.registerWings("bat_wings", ModRarity.PINK, 0.68f, 62, true, false);
    public static final DeferredItem<BaseCurioItem> BEE_WINGS = AccessoryItems.registerWings("bee_wings", ModRarity.PINK, 0.68f, 62, true, false);
    public static final DeferredItem<BaseCurioItem> BUTTERFLY_WINGS = AccessoryItems.registerWings("butterfly_wings", ModRarity.PINK, 0.68f, 62, true, false);
    public static final DeferredItem<BaseCurioItem> FLAME_WINGS = AccessoryItems.registerWings("flame_wings", ModRarity.PINK, 0.68f, 62, true, false);
    public static final DeferredItem<BaseCurioItem> HOVERBOARD = AccessoryItems.registerWings("hoverboard", ModRarity.PINK, 0.68f, 74, true, true);
    public static final DeferredItem<BaseCurioItem> BONE_WINGS = AccessoryItems.registerWings("bone_wings", ModRarity.PINK, 0.68f, 74, true, false);
    public static final DeferredItem<BaseCurioItem> MOTHRON_WINGS = AccessoryItems.registerWings("mothron_wings", ModRarity.YELLOW, 0.68f, 74, true, false);
    public static final DeferredItem<BaseCurioItem> SPECTRE_WINGS = AccessoryItems.registerWings("spectre_wings", ModRarity.YELLOW, 0.68f, 74, true, false);
    public static final DeferredItem<BaseCurioItem> BEETLE_WINGS = AccessoryItems.registerWings("beetle_wings", ModRarity.LIME, 0.68f, 74, true, false);
    public static final DeferredItem<BaseCurioItem> FESTIVE_WINGS = AccessoryItems.registerWings("festive_wings", ModRarity.PINK, 0.7f, 84, true, false);
    public static final DeferredItem<BaseCurioItem> SPOOKY_WINGS = AccessoryItems.registerWings("spooky_wings", ModRarity.LIME, 0.7f, 84, true, false);
    public static final DeferredItem<BaseCurioItem> TATTERED_WINGS = AccessoryItems.registerWings("tattered_wings", ModRarity.LIME, 0.7f, 84, true, false);
    public static final DeferredItem<BaseCurioItem> STEAMPUNK_WINGS = AccessoryItems.registerWings("steampunk_wings", ModRarity.YELLOW, 0.7f, 84, true, false);
    public static final DeferredItem<BaseCurioItem> BETSYS_WINGS = AccessoryItems.registerWings("betsys_wings", ModRarity.YELLOW, 0.72f, 84, true, true);
    public static final DeferredItem<BaseCurioItem> EMPRESS_WINGS = AccessoryItems.registerWings("empress_wings", ModRarity.CYAN, 0.85f, 86, true, false);
    public static final DeferredItem<BaseCurioItem> FISHRON_WINGS = AccessoryItems.registerWings("fishron_wings", ModRarity.YELLOW, 0.85f, 92, true, false);
    public static final DeferredItem<BaseCurioItem> NEBULA_WINGS = AccessoryItems.registerWings("nebula_wings", ModRarity.RED, 0.85f, 92, true, true);
    public static final DeferredItem<BaseCurioItem> VORTEX_BOOSTER = AccessoryItems.registerWings("vortex_booster", ModRarity.RED, 0.85f, 92, true, true);
    public static final DeferredItem<BaseCurioItem> SOLAR_WINGS = AccessoryItems.registerWings("solar_wings", ModRarity.RED, 0.85f, 92, true, false);
    public static final DeferredItem<BaseCurioItem> STARDUST_WINGS = AccessoryItems.registerWings("stardust", ModRarity.RED, 0.85f, 92, true, false);
    public static final DeferredItem<BaseCurioItem> CLOTHIER_VOODOO_DOLL = AccessoryItems.registerCurio("clothier_voodoo_doll", builder -> builder.rarity(ModRarity.BLUE).accessories(PrimitiveValueComponent.units(CLOTHIER$KILLER, (ValueType[])new ValueType[0]), new PrimitiveValueComponent[0]));
    public static final DeferredItem<BaseCurioItem> GUIDE_VOODOO_DOLL = AccessoryItems.registerDirectly("guide_voodoo_doll", GuideVooDooDollItem::new);

    private static DeferredItem<BaseCurioItem> registerCurio(String name, Consumer<BaseCurioItem.Builder> consumer) {
        return ITEMS.register(name, () -> {
            BaseCurioItem.Builder builder = BaseCurioItem.builder((String)name);
            consumer.accept(builder);
            return builder.build();
        });
    }

    private static <I extends BaseCurioItem> DeferredItem<I> registerDirectly(String name, Function<String, I> function) {
        return ITEMS.register(name, () -> (BaseCurioItem)function.apply(name));
    }

    private static DeferredItem<BaseCurioItem> registerWings(String name, ModRarity rarity, float flySpeed, int flyTicks, boolean couldGlide, boolean horizontalFlight) {
        DeferredItem<BaseCurioItem> item = AccessoryItems.registerCurio(name, builder -> builder.rarity(rarity).accessories(PrimitiveValueComponent.of((ValueType)TCItems.MAY$FLY, (Object)MayFlyAbilityValue.of((String)name, (int)1100, (float)flySpeed, (int)flyTicks, (boolean)couldGlide, (boolean)horizontalFlight)), new PrimitiveValueComponent[0]).attribute(Attributes.FALL_DAMAGE_MULTIPLIER, -100.0, AttributeModifier.Operation.ADD_VALUE));
        WINGS.add(item);
        return item;
    }

    public static void applyLuckyCoin(ServerPlayer player, Entity target) {
        if (!((Boolean)CommonConfigs.ENEMY_DROPS_MONEY.get()).booleanValue()) {
            return;
        }
        RandomSource randomSource = player.getRandom();
        if (TCUtils.hasType((LivingEntity)player, LUCKY$COIN) && randomSource.nextFloat() < 0.2f) {
            float a = randomSource.nextFloat();
            Item item = a < 0.01f ? (Item)ModItems.GOLD_COIN.get() : (a < 0.099f ? (Item)ModItems.SILVER_COIN.get() : (Item)ModItems.COPPER_COIN.get());
            ItemStack itemStack = item.getDefaultInstance();
            itemStack.setCount(randomSource.nextInt(1, 3));
            LibUtils.createItemEntity((ItemStack)itemStack, (double)target.getX(), (double)target.getY(), (double)target.getZ(), (Level)player.level(), (int)0);
        }
    }

    public static void applyHurtGetMana(ServerPlayer player, DamageSource damageSource, float amount) {
        if (TCUtils.hasType((LivingEntity)player, HURT$GET$MANA) && !damageSource.is(DamageTypes.DROWN) && !damageSource.is(TCTags.HARMFUL_EFFECT)) {
            CompoundTag tag = LibUtils.getOrCreatePersistedData((Player)player);
            long last = tag.getLong("confluence:last_hurt_get_mana_time");
            long cur = player.level().getGameTime();
            if (cur - last >= 10L) {
                PlayerUtils.receiveMana(player, () -> amount);
                tag.putLong("confluence:last_hurt_get_mana_time", cur);
            }
        }
    }
}

