/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.block;

import com.mojang.datafixers.DSL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipBlockItem;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.lib.util.MobEffectInstanceData;
import org.confluence.mod.common.block.common.EnchantedBricksBlock;
import org.confluence.mod.common.block.common.EnchantedFragileBricksBlock;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.AmmoBoxBlock;
import org.confluence.mod.common.block.functional.AnnouncementBoxBlock;
import org.confluence.mod.common.block.functional.BaseSoulInABottleBlock;
import org.confluence.mod.common.block.functional.BehaviourPressurePlateBlock;
import org.confluence.mod.common.block.functional.BewitchingTableBlock;
import org.confluence.mod.common.block.functional.DartTrapBlock;
import org.confluence.mod.common.block.functional.DetonatorBlock;
import org.confluence.mod.common.block.functional.EchoBlock;
import org.confluence.mod.common.block.functional.EffectiveCandleBlock;
import org.confluence.mod.common.block.functional.EverPoweredRailBlock;
import org.confluence.mod.common.block.functional.FlameTrapBlock;
import org.confluence.mod.common.block.functional.FragileBlock;
import org.confluence.mod.common.block.functional.FragilePressureBlock;
import org.confluence.mod.common.block.functional.GeyserBlock;
import org.confluence.mod.common.block.functional.HeartLanternBlock;
import org.confluence.mod.common.block.functional.InstantExplosionBlock;
import org.confluence.mod.common.block.functional.LandMineBlock;
import org.confluence.mod.common.block.functional.LifeCampfireBlock;
import org.confluence.mod.common.block.functional.LockBlock;
import org.confluence.mod.common.block.functional.MechanicalFragileBlock;
import org.confluence.mod.common.block.functional.PiggyBankBlock;
import org.confluence.mod.common.block.functional.SafeBlock;
import org.confluence.mod.common.block.functional.SculkTrapBlock;
import org.confluence.mod.common.block.functional.SharpeningStationBlock;
import org.confluence.mod.common.block.functional.SignalAdapterBlock;
import org.confluence.mod.common.block.functional.SignalPressurePlateBlock;
import org.confluence.mod.common.block.functional.SillyBalloonMachineBlock;
import org.confluence.mod.common.block.functional.SpearTrapBlock;
import org.confluence.mod.common.block.functional.SpikeBlock;
import org.confluence.mod.common.block.functional.SpikyBallTrapBlock;
import org.confluence.mod.common.block.functional.StarInABottleBlock;
import org.confluence.mod.common.block.functional.StepOnTrapBlock;
import org.confluence.mod.common.block.functional.SuperDartTrapBlock;
import org.confluence.mod.common.block.functional.SwitchBlock;
import org.confluence.mod.common.block.functional.TimersBlock;
import org.confluence.mod.common.block.functional.TuffBoothBlock;
import org.confluence.mod.common.block.functional.WeatherVaneBlock;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.block.functional.boulder.BoulderBlock;
import org.confluence.mod.common.block.functional.boulder.RollingCactusBoulderBlock;
import org.confluence.mod.common.block.functional.crafting.AdamantiteForgeBlock;
import org.confluence.mod.common.block.functional.crafting.AlchemyTableBlock;
import org.confluence.mod.common.block.functional.crafting.AltarBlock;
import org.confluence.mod.common.block.functional.crafting.BaseCauldronBlock;
import org.confluence.mod.common.block.functional.crafting.ChlorophyteExtractinatorBlock;
import org.confluence.mod.common.block.functional.crafting.CookingPotBlock;
import org.confluence.mod.common.block.functional.crafting.CrystalBallBlock;
import org.confluence.mod.common.block.functional.crafting.DyeVatBlock;
import org.confluence.mod.common.block.functional.crafting.ExtractinatorBlock;
import org.confluence.mod.common.block.functional.crafting.HardmodeAnvilBlock;
import org.confluence.mod.common.block.functional.crafting.HardmodeForgeBlock;
import org.confluence.mod.common.block.functional.crafting.HeavyWorkBenchBlock;
import org.confluence.mod.common.block.functional.crafting.HellforgeBlock;
import org.confluence.mod.common.block.functional.crafting.KegBlock;
import org.confluence.mod.common.block.functional.crafting.LoomBlock;
import org.confluence.mod.common.block.functional.crafting.SawmillBlock;
import org.confluence.mod.common.block.functional.crafting.SingleItemStackSwapperBlock;
import org.confluence.mod.common.block.functional.crafting.SkyMillBlock;
import org.confluence.mod.common.block.functional.crafting.SolidifierBlock;
import org.confluence.mod.common.block.functional.crafting.TitaniumForgeBlock;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.natural.MagicMailBox;
import org.confluence.mod.common.block.natural.TreeHolesBlock;
import org.confluence.mod.common.entity.projectile.boulder.AbstractBoulderEntity;
import org.confluence.mod.common.entity.projectile.boulder.ExplodeBoulderEntity;
import org.confluence.mod.common.entity.projectile.boulder.FollowerBoulderEntity;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.ModItems;

public class FunctionalBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"confluence");
    static List<DeferredBlock<? extends Block>> MECHANICAL_BLOCKS = new ArrayList<DeferredBlock<? extends Block>>();
    public static final DeferredBlock<ExtractinatorBlock> EXTRACTINATOR = FunctionalBlocks.registerWithItem("extractinator", () -> new ExtractinatorBlock(BlockBehaviour.Properties.of().strength(2.2f, 5.0f).requiresCorrectToolForDrops()), ExtractinatorBlock.BItem::new);
    public static final Supplier<BlockEntityType<ExtractinatorBlock.BEntity>> EXTRACTINATOR_ENTITY = ModBlocks.BLOCK_ENTITIES.register("extractinator_entity", () -> BlockEntityType.Builder.of(ExtractinatorBlock.BEntity::new, (Block[])new Block[]{(Block)EXTRACTINATOR.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<AltarBlock> DEMON_ALTAR = FunctionalBlocks.registerWithItem("demon_altar", () -> new AltarBlock(BlockBehaviour.Properties.of().strength(3.0f, 18000.0f).lightLevel(state -> 5), AltarBlock.Variant.DEMON), AltarBlock.BItem::new);
    public static final DeferredBlock<AltarBlock> CRIMSON_ALTAR = FunctionalBlocks.registerWithItem("crimson_altar", () -> new AltarBlock(BlockBehaviour.Properties.of().strength(3.0f, 18000.0f).lightLevel(state -> 5), AltarBlock.Variant.CRIMSON), AltarBlock.BItem::new);
    public static final Supplier<BlockEntityType<AltarBlock.BEntity>> ALTAR_BLOCK_ENTITY = ModBlocks.BLOCK_ENTITIES.register("altar_block_entity", () -> BlockEntityType.Builder.of(AltarBlock.BEntity::new, (Block[])new Block[]{(Block)DEMON_ALTAR.get(), (Block)CRIMSON_ALTAR.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<SkyMillBlock> SKY_MILL = FunctionalBlocks.registerWithItem("sky_mill", () -> new SkyMillBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRINDSTONE)), SkyMillBlock.BItem::new);
    public static final Supplier<BlockEntityType<SkyMillBlock.BEntity>> SKY_MILL_ENTITY = ModBlocks.BLOCK_ENTITIES.register("sky_mill_entity", () -> BlockEntityType.Builder.of(SkyMillBlock.BEntity::new, (Block[])new Block[]{(Block)SKY_MILL.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<HeavyWorkBenchBlock> HEAVY_WORK_BENCH = FunctionalBlocks.registerWithItem("heavy_work_bench", () -> new HeavyWorkBenchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_BRICKS)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.heavy_work_bench.0"));
    public static final DeferredBlock<SawmillBlock> SAWMILL = FunctionalBlocks.registerWithItem("sawmill", () -> new SawmillBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.sawmill.0"));
    public static final DeferredBlock<HellforgeBlock> HELLFORGE = FunctionalBlocks.registerWithItem("hellforge", () -> new HellforgeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGMA_BLOCK).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 7).noOcclusion()), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.hellforge.0"));
    public static final Supplier<BlockEntityType<HellforgeBlock.BEntity>> HELLFORGE_ENTITY = ModBlocks.BLOCK_ENTITIES.register("hellforge_entity", () -> BlockEntityType.Builder.of(HellforgeBlock.BEntity::new, (Block[])new Block[]{(Block)HELLFORGE.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<CookingPotBlock> COOKING_POT = FunctionalBlocks.registerWithItem("cooking_pot", () -> new CookingPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)), block -> new CookingPotBlock.BItem((Block)block, new Item.Properties()));
    public static final Supplier<BlockEntityType<CookingPotBlock.BEntity>> COOKING_POT_ENTITY = ModBlocks.BLOCK_ENTITIES.register("cooking_pot_entity", () -> BlockEntityType.Builder.of(CookingPotBlock.BEntity::new, (Block[])new Block[]{(Block)COOKING_POT.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<BaseCauldronBlock> CAULDRON = FunctionalBlocks.registerWithItem("cauldron", () -> new BaseCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final Supplier<BlockEntityType<BaseCauldronBlock.BEntity>> CAULDRON_ENTITY = ModBlocks.BLOCK_ENTITIES.register("cauldron_entity", () -> BlockEntityType.Builder.of(BaseCauldronBlock.BEntity::new, (Block[])new Block[]{(Block)CAULDRON.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<AlchemyTableBlock> ALCHEMY_TABLE = FunctionalBlocks.registerWithItem("alchemy_table", () -> new AlchemyTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ENCHANTING_TABLE).lightLevel(state -> 0)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.BLUE, "tooltip.item.confluence.alchemy_table.0"));
    public static final DeferredBlock<SolidifierBlock> SOLIDIFIER = FunctionalBlocks.registerWithItem("solidifier", () -> new SolidifierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.solidifier.0"));
    public static final DeferredBlock<WeatherVaneBlock> WEATHER_VANE = FunctionalBlocks.registerWithItem("weather_vane", () -> new WeatherVaneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS)), block -> new BlockItem((Block)block, new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.BLUE)));
    public static final Supplier<BlockEntityType<WeatherVaneBlock.BEntity>> WEATHER_VANE_ENTITY = ModBlocks.BLOCK_ENTITIES.register("weather_vane_entity", () -> BlockEntityType.Builder.of(WeatherVaneBlock.BEntity::new, (Block[])new Block[]{(Block)WEATHER_VANE.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<TuffBoothBlock> TUFF_BOOTH = FunctionalBlocks.registerWithItem("tuff_booth", () -> new TuffBoothBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TUFF_BRICKS)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.tuff_booth.0"));
    public static final Supplier<BlockEntityType<TuffBoothBlock.TuffBoothBlockEntity>> TUFF_BOOTH_ENTITY = ModBlocks.BLOCK_ENTITIES.register("tuff_booth_entity", () -> BlockEntityType.Builder.of(TuffBoothBlock.TuffBoothBlockEntity::new, (Block[])new Block[]{(Block)TUFF_BOOTH.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<AnvilBlock> LEAD_ANVIL = FunctionalBlocks.registerWithItem("lead_anvil", () -> new AnvilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANVIL)));
    public static final DeferredBlock<AnvilBlock> CHIPPED_LEAD_ANVIL = FunctionalBlocks.registerWithItem("chipped_lead_anvil", () -> new AnvilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHIPPED_ANVIL)));
    public static final DeferredBlock<AnvilBlock> DAMAGED_LEAD_ANVIL = FunctionalBlocks.registerWithItem("damaged_lead_anvil", () -> new AnvilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DAMAGED_ANVIL)));
    public static final DeferredBlock<SharpeningStationBlock> SHARPENING_STATION = FunctionalBlocks.registerWithItem("sharpening_station", () -> new SharpeningStationBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONECUTTER)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.BLUE, "tooltip.item.confluence.sharpening_station.0"));
    public static final DeferredBlock<AmmoBoxBlock> AMMO_BOX = FunctionalBlocks.registerWithItem("ammo_box", () -> new AmmoBoxBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.LIGHT_PURPLE, "tooltip.item.confluence.ammo_box.0"));
    public static final DeferredBlock<BewitchingTableBlock> BEWITCHING_TABLE = FunctionalBlocks.registerWithItem("bewitching_table", () -> new BewitchingTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ENCHANTING_TABLE).lightLevel(state -> 0)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.BLUE, "tooltip.item.confluence.bewitching_table.0"));
    public static final Supplier<BlockEntityType<BewitchingTableBlock.BEntity>> BEWITCHING_TABLE_ENTITY = ModBlocks.BLOCK_ENTITIES.register("bewitching_table_entity", () -> BlockEntityType.Builder.of(BewitchingTableBlock.BEntity::new, (Block[])new Block[]{(Block)BEWITCHING_TABLE.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<KegBlock> KEG = FunctionalBlocks.registerWithItem("keg", () -> new KegBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.keg.0"));
    public static final DeferredBlock<CrystalBallBlock> CRYSTAL_BALL = FunctionalBlocks.registerWithItem("crystal_ball", () -> new CrystalBallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEACON).sound(SoundType.AMETHYST)), block -> new BlockItem((Block)block, new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.ORANGE)));
    public static final DeferredBlock<HardmodeAnvilBlock> MYTHRIL_ANVIL = FunctionalBlocks.registerWithItem("mythril_anvil", () -> new HardmodeAnvilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANVIL)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.ORANGE, "tooltip.item.confluence.hardmode_anvil.0"));
    public static final DeferredBlock<HardmodeAnvilBlock> ORICHALCUM_ANVIL = FunctionalBlocks.registerWithItem("orichalcum_anvil", () -> new HardmodeAnvilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANVIL)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.ORANGE, "tooltip.item.confluence.hardmode_anvil.0"));
    public static final DeferredBlock<ChlorophyteExtractinatorBlock> CHLOROPHYTE_EXTRACTINATOR = FunctionalBlocks.registerWithItem("chlorophyte_extractinator", () -> new ChlorophyteExtractinatorBlock(BlockBehaviour.Properties.of().strength(4.4f, 10.0f).requiresCorrectToolForDrops()), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.LIME, TooltipItem.getTooltipsFromString((String)"chlorophyte_extractinator", (int)3, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredBlock<SingleItemStackSwapperBlock> BLEND_O_MATIC = FunctionalBlocks.registerWithItem("blend_o_matic", () -> new SingleItemStackSwapperBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON), 1, itemStack -> itemStack.is(MaterialItems.RAW_ASPHALT) ? DecorativeBlocks.ASPHALT_BLOCK.toStack() : ItemStack.EMPTY), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.blend_o_matic.0"));
    public static final DeferredBlock<SingleItemStackSwapperBlock> MEAT_GRINDER = FunctionalBlocks.registerWithItem("meat_grinder", () -> new SingleItemStackSwapperBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON), 2, itemStack -> {
        if (itemStack.is(NatureBlocks.COBBLED_CRIMSTONE.asItem())) {
            return DecorativeBlocks.FLESH_BLOCK.toStack();
        }
        if (itemStack.is(NatureBlocks.COBBLED_EBONSTONE.asItem())) {
            return DecorativeBlocks.LESION_BLOCK.toStack();
        }
        return ItemStack.EMPTY;
    }), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.meat_grinder.0"));
    public static final DeferredBlock<AdamantiteForgeBlock> ADAMANTITE_FORGE = FunctionalBlocks.registerWithItem("adamantite_forge", AdamantiteForgeBlock::new, block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.ORANGE, "tooltip.item.confluence.hardmode_forge.0"));
    public static final DeferredBlock<TitaniumForgeBlock> TITANIUM_FORGE = FunctionalBlocks.registerWithItem("titanium_forge", TitaniumForgeBlock::new, block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.ORANGE, "tooltip.item.confluence.hardmode_forge.0"));
    public static final Supplier<BlockEntityType<HardmodeForgeBlock.BEntity>> HARDMODE_FORGE_ENTITY = ModBlocks.BLOCK_ENTITIES.register("hardmode_forge_entity", () -> BlockEntityType.Builder.of(HardmodeForgeBlock.BEntity::new, (Block[])new Block[]{(Block)ADAMANTITE_FORGE.get(), (Block)TITANIUM_FORGE.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<LoomBlock> LOOM = FunctionalBlocks.registerWithItem("loom", LoomBlock::new, block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.loom.0"));
    public static final Supplier<BlockEntityType<LoomBlock.BEntity>> LOOM_ENTITY = ModBlocks.BLOCK_ENTITIES.register("loom_entity", () -> BlockEntityType.Builder.of(LoomBlock.BEntity::new, (Block[])new Block[]{(Block)LOOM.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<DyeVatBlock> DYE_VAT = FunctionalBlocks.registerWithItem("dye_vat", DyeVatBlock::new, block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.dye_vat.0"));
    public static final DeferredBlock<LifeCampfireBlock> LIFE_CAMPFIRE = FunctionalBlocks.registerWithItem("life_campfire", () -> new LifeCampfireBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAMPFIRE)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.life_campfire.0"));
    public static final DeferredBlock<PiggyBankBlock> PIGGY_BANK = FunctionalBlocks.registerWithItem("piggy_bank", () -> new PiggyBankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, TooltipItem.getTooltipsFromString((String)"piggy_bank", (int)2, (ChatFormatting)ChatFormatting.GRAY)));
    public static final Supplier<BlockEntityType<PiggyBankBlock.BEntity>> PIGGY_BANK_ENTITY = ModBlocks.BLOCK_ENTITIES.register("piggy_bank_entity", () -> BlockEntityType.Builder.of(PiggyBankBlock.BEntity::new, (Block[])new Block[]{(Block)PIGGY_BANK.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<SafeBlock> SAFE = FunctionalBlocks.registerWithItem("safe", () -> new SafeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, TooltipItem.getTooltipsFromString((String)"safe", (int)2, (ChatFormatting)ChatFormatting.GRAY)));
    public static final Supplier<BlockEntityType<SafeBlock.BEntity>> SAFE_ENTITY = ModBlocks.BLOCK_ENTITIES.register("safe_entity", () -> BlockEntityType.Builder.of(SafeBlock.BEntity::new, (Block[])new Block[]{(Block)SAFE.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<EchoBlock> ECHO_BLOCK = FunctionalBlocks.registerWithItem("echo_block", EchoBlock::new, block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.BLUE, "tooltip.item.confluence.echo_block.0"));
    public static final DeferredBlock<EverPoweredRailBlock> EVER_POWERED_RAIL = FunctionalBlocks.registerWithItem("ever_powered_rail", () -> new EverPoweredRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACTIVATOR_RAIL)));
    public static final DeferredBlock<StepOnTrapBlock> SHIMMER_TRAP = FunctionalBlocks.registerWithItem("shimmer_trap", () -> new StepOnTrapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DISPENSER), StepOnTrapBlock.SHIMMER));
    public static final DeferredBlock<StepOnTrapBlock> GRAVITATION_TRAP = FunctionalBlocks.registerWithItem("gravitation_trap", () -> new StepOnTrapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DISPENSER), StepOnTrapBlock.GRAVITATION));
    public static final DeferredBlock<StepOnTrapBlock> PNEUMATIC_TRAP = FunctionalBlocks.registerWithItem("pneumatic_trap", () -> new StepOnTrapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DISPENSER), StepOnTrapBlock.PNEUMATIC));
    public static final DeferredBlock<SpikeBlock> SPIKE = FunctionalBlocks.registerWithItem("spike", () -> new SpikeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS), 12.0f));
    public static final DeferredBlock<SpikeBlock> WOODEN_SPIKE = FunctionalBlocks.registerWithItem("wooden_spike", () -> new SpikeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_PLANKS), 16.0f));
    public static final DeferredBlock<FragileBlock> FRAGILE_SANDSTONE = FunctionalBlocks.registerWithItem("fragile_sandstone", () -> new FragileBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE), () -> ((Block)Blocks.SANDSTONE).defaultBlockState()));
    public static final DeferredBlock<FragileBlock> FRAGILE_BLUE_BRICKS = FunctionalBlocks.registerWithItem("fragile_blue_bricks", () -> new FragileBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), () -> ((Block)DecorativeBlocks.BLUE_BRICKS.get()).defaultBlockState()));
    public static final DeferredBlock<FragileBlock> FRAGILE_GREEN_BRICKS = FunctionalBlocks.registerWithItem("fragile_green_bricks", () -> new FragileBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), () -> ((Block)DecorativeBlocks.GREEN_BRICKS.get()).defaultBlockState()));
    public static final DeferredBlock<FragileBlock> FRAGILE_PINK_BRICKS = FunctionalBlocks.registerWithItem("fragile_pink_bricks", () -> new FragileBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), () -> ((Block)DecorativeBlocks.PINK_BRICKS.get()).defaultBlockState()));
    public static final DeferredBlock<EnchantedFragileBricksBlock> ENCHANTED_FRAGILE_BLUE_BRICKS = FunctionalBlocks.registerWithItem("enchanted_fragile_blue_bricks", () -> new EnchantedFragileBricksBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), () -> ((EnchantedBricksBlock)((Object)((Object)((Object)DecorativeBlocks.ENCHANTED_BLUE_BRICKS.get())))).defaultBlockState()));
    public static final DeferredBlock<EnchantedFragileBricksBlock> ENCHANTED_FRAGILE_GREEN_BRICKS = FunctionalBlocks.registerWithItem("enchanted_fragile_green_bricks", () -> new EnchantedFragileBricksBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), () -> ((EnchantedBricksBlock)((Object)((Object)((Object)DecorativeBlocks.ENCHANTED_GREEN_BRICKS.get())))).defaultBlockState()));
    public static final DeferredBlock<EnchantedFragileBricksBlock> ENCHANTED_FRAGILE_PINK_BRICKS = FunctionalBlocks.registerWithItem("enchanted_fragile_pink_bricks", () -> new EnchantedFragileBricksBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), () -> ((EnchantedBricksBlock)((Object)((Object)((Object)DecorativeBlocks.ENCHANTED_PINK_BRICKS.get())))).defaultBlockState()));
    public static final DeferredBlock<SculkTrapBlock> SCULK_TRAP = FunctionalBlocks.registerWithItem("sculk_trap", () -> new SculkTrapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK_SENSOR)));
    public static final DeferredBlock<SillyBalloonMachineBlock> SILLY_BALLOON_MACHINE = FunctionalBlocks.registerWithItem("silly_balloon_machine", () -> new SillyBalloonMachineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final Supplier<BlockEntityType<SillyBalloonMachineBlock.BEntity>> SILLY_BALLOON_MACHINE_ENTITY = ModBlocks.BLOCK_ENTITIES.register("silly_balloon_machine_entity", () -> BlockEntityType.Builder.of(SillyBalloonMachineBlock.BEntity::new, (Block[])new Block[]{(Block)SILLY_BALLOON_MACHINE.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<BehaviourPressurePlateBlock> PLAYER_PRESSURE_PLATE = FunctionalBlocks.registerWithEntity("player_pressure_plate", () -> new BehaviourPressurePlateBlock(BehaviourPressurePlateBlock.PLAYER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE), BlockSetType.IRON));
    public static final DeferredBlock<SignalPressurePlateBlock> STONE_PRESSURE_PLATE = FunctionalBlocks.registerWithEntity("stone_pressure_plate", () -> new SignalPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_PRESSURE_PLATE)));
    public static final DeferredBlock<SignalPressurePlateBlock> DEEPSLATE_PRESSURE_PLATE = FunctionalBlocks.registerWithEntity("deepslate_pressure_plate", () -> new SignalPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_PRESSURE_PLATE).mapColor(MapColor.DEEPSLATE)));
    public static final DeferredBlock<FragilePressureBlock> STONE_PRESSURE_BLOCK = FunctionalBlocks.registerWithEntity("stone_pressure_block", () -> new FragilePressureBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), BlockSetType.STONE, () -> ((Block)Blocks.STONE).defaultBlockState()));
    public static final DeferredBlock<FragilePressureBlock> DEEPSLATE_PRESSURE_BLOCK = FunctionalBlocks.registerWithEntity("deepslate_pressure_block", () -> new FragilePressureBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE), BlockSetType.STONE, () -> ((Block)Blocks.DEEPSLATE).defaultBlockState()));
    public static final DeferredBlock<InstantExplosionBlock> INSTANTANEOUS_EXPLOSION_TNT = FunctionalBlocks.registerWithEntity("instantaneous_explosion_tnt", InstantExplosionBlock::new);
    public static final DeferredBlock<SwitchBlock> SWITCH = FunctionalBlocks.registerWithEntity("switch", SwitchBlock::new);
    public static final DeferredBlock<SwitchBlock> LEVER = FunctionalBlocks.registerWithEntity("lever", SwitchBlock::new);
    public static final DeferredBlock<SignalAdapterBlock> SIGNAL_ADAPTER = FunctionalBlocks.registerWithEntity("signal_adapter", SignalAdapterBlock::new);
    public static final DeferredBlock<DartTrapBlock> DART_TRAP = FunctionalBlocks.registerWithEntity("dart_trap", () -> new DartTrapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DISPENSER)));
    public static final DeferredBlock<DartTrapBlock> STONE_DART_TRAP = FunctionalBlocks.registerWithEntity("stone_dart_trap", () -> new DartTrapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DISPENSER)));
    public static final DeferredBlock<DartTrapBlock> DEEPSLATE_DART_TRAP = FunctionalBlocks.registerWithEntity("deepslate_dart_trap", () -> new DartTrapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DISPENSER)));
    public static final DeferredBlock<TimersBlock> TIMERS_BLOCK_1_1 = FunctionalBlocks.registerWithEntity("timers_1_1", () -> new TimersBlock(20));
    public static final DeferredBlock<TimersBlock> TIMERS_BLOCK_3_1 = FunctionalBlocks.registerWithEntity("timers_3_1", () -> new TimersBlock(60));
    public static final DeferredBlock<TimersBlock> TIMERS_BLOCK_5_1 = FunctionalBlocks.registerWithEntity("timers_5_1", () -> new TimersBlock(100));
    public static final DeferredBlock<TimersBlock> TIMERS_BLOCK_1_2 = FunctionalBlocks.registerWithEntity("timers_1_2", () -> new TimersBlock(10));
    public static final DeferredBlock<TimersBlock> TIMERS_BLOCK_1_4 = FunctionalBlocks.registerWithEntity("timers_1_4", () -> new TimersBlock(5));
    public static final DeferredBlock<GeyserBlock> GEYSER_BLOCK = FunctionalBlocks.registerWithEntity("geyser_block", GeyserBlock::new);
    public static final DeferredBlock<AbstractBoulderBlock<?>> NORMAL_BOULDER = FunctionalBlocks.registerWithEntity("normal_boulder", BoulderBlock::new);
    public static final DeferredBlock<AbstractBoulderBlock<?>> OAK_LOG_BOULDER = FunctionalBlocks.registerWithEntity("oak_log_boulder", BoulderBlock::new);
    public static final DeferredBlock<AbstractBoulderBlock<?>> FOLLOWER_BOULDER = FunctionalBlocks.registerBoulder("follower_boulder", BoulderBlock::new, FollowerBoulderEntity::new);
    public static final DeferredBlock<AbstractBoulderBlock<?>> EXPLODE_BOULDER = FunctionalBlocks.registerBoulder("explode_boulder", BoulderBlock::new, ExplodeBoulderEntity::new);
    public static final DeferredBlock<AbstractBoulderBlock<?>> ROLLING_CACTUS_BOULDER = FunctionalBlocks.registerWithEntity("rolling_cactus_boulder", RollingCactusBoulderBlock::new);
    public static final DeferredBlock<DetonatorBlock> DETONATOR = FunctionalBlocks.registerWithEntity("detonator", () -> new DetonatorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_TRAPDOOR)));
    public static final DeferredBlock<MechanicalFragileBlock> MECHANICAL_FRAGILE_SANDSTONE = FunctionalBlocks.registerWithEntity("mechanical_fragile_sandstone", () -> new MechanicalFragileBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE), () -> ((Block)Blocks.SANDSTONE).defaultBlockState()));
    public static final DeferredBlock<MechanicalFragileBlock> MECHANICAL_FRAGILE_OBSIDIAN_BRICKS = FunctionalBlocks.registerWithEntity("mechanical_fragile_obsidian_bricks", () -> new MechanicalFragileBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS), () -> ((Block)((Block)DecorativeBlocks.OBSIDIAN_BRICKS.get())).defaultBlockState()));
    public static final DeferredBlock<LandMineBlock> LAND_MINE = FunctionalBlocks.registerWithEntity("land_mine", () -> new LandMineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TNT)));
    public static final DeferredBlock<SuperDartTrapBlock> SUPER_DART_TRAP = FunctionalBlocks.registerWithEntity("super_dart_trap", () -> new SuperDartTrapBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).requiresCorrectToolForDrops().strength(100.0f, ModBlocks.getObsidianBasedExplosionResistance(1000.0f))));
    public static final DeferredBlock<FlameTrapBlock> FLAME_TRAP = FunctionalBlocks.registerWithEntity("flame_trap", () -> new FlameTrapBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).requiresCorrectToolForDrops().strength(100.0f, ModBlocks.getObsidianBasedExplosionResistance(1000.0f))));
    public static final DeferredBlock<SpikyBallTrapBlock> SPIKY_BALL_TRAP = FunctionalBlocks.registerWithEntity("spiky_ball_trap", () -> new SpikyBallTrapBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).requiresCorrectToolForDrops().strength(100.0f, ModBlocks.getObsidianBasedExplosionResistance(1000.0f))));
    public static final DeferredBlock<SpearTrapBlock> SPEAR_TRAP = FunctionalBlocks.registerWithEntity("spear_trap", () -> new SpearTrapBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).requiresCorrectToolForDrops().strength(100.0f, ModBlocks.getObsidianBasedExplosionResistance(1000.0f))));
    public static final DeferredBlock<EffectiveCandleBlock> WATER_CANDLE = FunctionalBlocks.registerCandle("water_candle", new MobEffectInstanceData(ModEffects.WATER_CANDLE, 100));
    public static final DeferredBlock<EffectiveCandleBlock> PEACE_CANDLE = FunctionalBlocks.registerCandle("peace_candle", new MobEffectInstanceData(ModEffects.PEACE_CANDLE, 100));
    public static final DeferredBlock<AnnouncementBoxBlock> ANNOUNCEMENT_BOX = BLOCKS.register("announcement_box", () -> new AnnouncementBoxBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f).noCollission().noOcclusion().sound(SoundType.METAL).isValidSpawn(Blocks::never)));
    public static final DeferredBlock<AnnouncementBoxBlock.Wall> WALL_ANNOUNCEMENT_BOX = BLOCKS.register("wall_announcement_box", () -> new AnnouncementBoxBlock.Wall(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ANNOUNCEMENT_BOX.get()))));
    public static final DeferredItem<SignItem> ANNOUNCEMENT_BOX_ITEM = ModItems.BLOCK_ITEMS.register("announcement_box", () -> new SignItem(new Item.Properties(), (Block)ANNOUNCEMENT_BOX.get(), (Block)WALL_ANNOUNCEMENT_BOX.get()));
    public static final Supplier<BlockEntityType<AnnouncementBoxBlock.BEntity>> ANNOUNCEMENT_BOX_ENTITY = ModBlocks.BLOCK_ENTITIES.register("announcement_box_entity", () -> BlockEntityType.Builder.of(AnnouncementBoxBlock.BEntity::new, (Block[])new Block[]{(Block)ANNOUNCEMENT_BOX.get(), (Block)WALL_ANNOUNCEMENT_BOX.get()}).build(DSL.remainderType()));
    public static final Supplier<BlockEntityType<AbstractMechanicalBlock.BEntity>> MECHANICAL_BLOCK_ENTITY = ModBlocks.BLOCK_ENTITIES.register("mechanical_block_entity", () -> {
        Block[] validBlocks = (Block[])MECHANICAL_BLOCKS.stream().map(DeferredHolder::get).toArray(Block[]::new);
        MECHANICAL_BLOCKS = null;
        return BlockEntityType.Builder.of(AbstractMechanicalBlock.BEntity::new, (Block[])validBlocks).build(DSL.remainderType());
    });
    public static final DeferredBlock<TreeHolesBlock> TREE_HOLES_BLOCK = FunctionalBlocks.registerWithItem("tree_holes", () -> new TreeHolesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL)));
    public static final Supplier<BlockEntityType<TreeHolesBlock.BEntity>> TREE_HOLES_ENTITY = ModBlocks.BLOCK_ENTITIES.register("tree_holes", () -> BlockEntityType.Builder.of(TreeHolesBlock.BEntity::new, (Block[])new Block[]{(Block)TREE_HOLES_BLOCK.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<MagicMailBox> MAGIC_MAIL_BOX = FunctionalBlocks.registerWithItem("magic_mail_box", MagicMailBox::new);
    public static final DeferredBlock<LockBlock> LOCK_BLOCK = FunctionalBlocks.registerWithItem("lock_block", () -> new LockBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK)));
    public static final Supplier<BlockEntityType<LockBlock.BEntity>> LOCK_BLOCK_ENTITY = ModBlocks.BLOCK_ENTITIES.register("lock_block_entity", () -> BlockEntityType.Builder.of(LockBlock.BEntity::new, (Block[])new Block[]{(Block)LOCK_BLOCK.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<HeartLanternBlock> HEART_LANTERN = FunctionalBlocks.registerWithItem("heart_lantern", () -> new HeartLanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_RED)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.heart_lantern.0"));
    public static final Supplier<BlockEntityType<HeartLanternBlock.BEntity>> HEART_LANTERN_ENTITY = ModBlocks.BLOCK_ENTITIES.register("heart_lantern_entity", () -> BlockEntityType.Builder.of(HeartLanternBlock.BEntity::new, (Block[])new Block[]{(Block)HEART_LANTERN.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<StarInABottleBlock> STAR_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("star_in_a_bottle", () -> new StarInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_YELLOW)), block -> new TooltipBlockItem((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.star_in_a_bottle.0"));
    public static final Supplier<BlockEntityType<StarInABottleBlock.BEntity>> STAR_IN_A_BOTTLE_ENTITY = ModBlocks.BLOCK_ENTITIES.register("star_in_a_bottle_entity", () -> BlockEntityType.Builder.of(StarInABottleBlock.BEntity::new, (Block[])new Block[]{(Block)STAR_IN_A_BOTTLE.get()}).build(DSL.remainderType()));
    public static final DeferredBlock<BaseSoulInABottleBlock> SOUL_OF_FLIGHT_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("soul_of_flight_in_a_bottle", () -> new BaseSoulInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_CYAN)));
    public static final DeferredBlock<BaseSoulInABottleBlock> SOUL_OF_LIGHT_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("soul_of_light_in_a_bottle", () -> new BaseSoulInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_PINK)));
    public static final DeferredBlock<BaseSoulInABottleBlock> SOUL_OF_FRIGHT_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("soul_of_fright_in_a_bottle", () -> new BaseSoulInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<BaseSoulInABottleBlock> SOUL_OF_NIGHT_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("soul_of_night_in_a_bottle", () -> new BaseSoulInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_PURPLE)));
    public static final DeferredBlock<BaseSoulInABottleBlock> SOUL_OF_MIGHT_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("soul_of_might_in_a_bottle", () -> new BaseSoulInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_BLUE)));
    public static final DeferredBlock<BaseSoulInABottleBlock> SOUL_OF_SIGHT_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("soul_of_sight_in_a_bottle", () -> new BaseSoulInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_LIGHT_GREEN)));
    public static final DeferredBlock<BaseSoulInABottleBlock> SOUL_OF_BRIGHT_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("soul_of_bright_in_a_bottle", () -> new BaseSoulInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_YELLOW)));
    public static final DeferredBlock<BaseSoulInABottleBlock> SOUL_OF_VOIGHT_IN_A_BOTTLE = FunctionalBlocks.registerWithItem("soul_of_voight_in_a_bottle", () -> new BaseSoulInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> 7).mapColor(MapColor.COLOR_PURPLE)));
    public static final Supplier<BlockEntityType<BaseSoulInABottleBlock.BEntity>> SOUL_BOTTLE_ENTITY = ModBlocks.BLOCK_ENTITIES.register("soul_bottle_entity", () -> BlockEntityType.Builder.of(BaseSoulInABottleBlock.BEntity::new, (Block[])new Block[]{(Block)SOUL_OF_FLIGHT_IN_A_BOTTLE.get(), (Block)SOUL_OF_LIGHT_IN_A_BOTTLE.get(), (Block)SOUL_OF_FRIGHT_IN_A_BOTTLE.get(), (Block)SOUL_OF_NIGHT_IN_A_BOTTLE.get(), (Block)SOUL_OF_MIGHT_IN_A_BOTTLE.get(), (Block)SOUL_OF_SIGHT_IN_A_BOTTLE.get(), (Block)SOUL_OF_VOIGHT_IN_A_BOTTLE.get(), (Block)SOUL_OF_BRIGHT_IN_A_BOTTLE.get()}).build(DSL.remainderType()));

    private static <B extends Block> DeferredBlock<B> registerWithItem(String id, Supplier<B> supplier) {
        DeferredBlock block = BLOCKS.register(id, supplier);
        ModItems.BLOCK_ITEMS.registerSimpleBlockItem((Holder)block);
        return block;
    }

    private static <B extends Block> DeferredBlock<B> registerWithItem(String id, Supplier<B> supplier, Function<B, BlockItem> function) {
        DeferredBlock block = BLOCKS.register(id, supplier);
        ModItems.BLOCK_ITEMS.register(id, () -> (BlockItem)function.apply((Block)block.get()));
        return block;
    }

    private static <B extends Block & INetworkBlock> DeferredBlock<B> registerWithEntity(String id, Supplier<B> supplier) {
        DeferredBlock<B> holder = FunctionalBlocks.registerWithItem(id, supplier);
        MECHANICAL_BLOCKS.add(holder);
        return holder;
    }

    private static <B extends Block & INetworkBlock> DeferredBlock<B> registerWithEntity(String id, Supplier<B> supplier, Function<B, BlockItem> function) {
        DeferredBlock<B> holder = FunctionalBlocks.registerWithItem(id, supplier, function);
        MECHANICAL_BLOCKS.add(holder);
        return holder;
    }

    private static DeferredBlock<EffectiveCandleBlock> registerCandle(String id, MobEffectInstanceData ... effectData) {
        return FunctionalBlocks.registerWithEntity(id, () -> new EffectiveCandleBlock(BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).noOcclusion().strength(0.1f).sound(SoundType.CANDLE).lightLevel(state -> (Boolean)state.getValue((Property)EffectiveCandleBlock.LIT) != false ? 15 : 0).pushReaction(PushReaction.DESTROY), 50.0f, effectData), block -> {
            List tooltips = TooltipItem.getTooltipsFromString((String)id, (int)1, (ChatFormatting)ChatFormatting.GRAY);
            return new EffectiveCandleBlock.BItem((Block)block, ModRarity.BLUE, tooltips, effectData);
        });
    }

    private static <B extends AbstractBoulderBlock<? extends E>, E extends AbstractBoulderEntity> DeferredBlock<B> registerBoulder(String id, Function<AbstractBoulderBlock.BoulderEntityFactory<E>, B> block, AbstractBoulderBlock.BoulderEntityFactory<E> entity) {
        return FunctionalBlocks.registerWithEntity(id, () -> (AbstractBoulderBlock)block.apply(entity));
    }
}

