/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.block;

import com.mojang.datafixers.DSL;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.block.common.BiomeChestBlock;
import org.confluence.mod.common.block.functional.DeathChestBlock;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.init.item.ToolItems;
import org.jetbrains.annotations.Nullable;

public class ChestBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"confluence");
    public static final ArrayList<DeferredBlock<BaseChestBlock>> NORMAL_CHESTS = new ArrayList();
    public static final ArrayList<DeferredBlock<DeathChestBlock>> DEATH_CHESTS = new ArrayList();
    public static final DeferredBlock<BaseChestBlock> GOLDEN_CHEST = ChestBlocks.registerNormal("golden_chest", stack -> {
        if (stack.is(ToolItems.GOLDEN_KEY)) {
            stack.shrink(1);
            return true;
        }
        return false;
    });
    public static final DeferredBlock<DeathChestBlock> DEATH_GOLDEN_CHEST = ChestBlocks.registerDeath("death_golden_chest");
    public static final DeferredBlock<BaseChestBlock> SHADOW_CHEST = ChestBlocks.registerNormal("shadow_chest", stack -> stack.is(ToolItems.SHADOW_KEY));
    public static final DeferredBlock<BaseChestBlock> FROZEN_CHEST = ChestBlocks.registerNormal("frozen_chest", null);
    public static final DeferredBlock<BaseChestBlock> IVY_CHEST = ChestBlocks.registerNormal("ivy_chest", null);
    public static final DeferredBlock<BaseChestBlock> RICH_MAHOGANY_CHEST = ChestBlocks.registerNormal("rich_mahogany_chest", null);
    public static final DeferredBlock<BaseChestBlock> MARBLE_CHEST = ChestBlocks.registerNormal("marble_chest", null);
    public static final DeferredBlock<BaseChestBlock> GRANITE_CHEST = ChestBlocks.registerNormal("granite_chest", null);
    public static final DeferredBlock<BaseChestBlock> WATER_CHEST = ChestBlocks.registerNormal("water_chest", null);
    public static final DeferredBlock<BaseChestBlock> SKYWARE_CHEST = ChestBlocks.registerNormal("skyware_chest", null);
    public static final DeferredBlock<DeathChestBlock> DEATH_WOODEN_CHEST = ChestBlocks.registerDeath("death_wooden_chest");
    public static final DeferredBlock<BaseChestBlock> SANDSTONE_CHEST = ChestBlocks.registerNormal("sandstone_chest", null);
    public static final DeferredBlock<BaseChestBlock> LIVING_WOOD_CHEST = ChestBlocks.registerNormal("living_wood_chest", null);
    public static final DeferredBlock<BaseChestBlock> DUNGEON_CHEST = ChestBlocks.registerNormal("dungeon_chest", stack -> {
        if (stack.is(ToolItems.GOLDEN_DUNGEON_KEY)) {
            stack.shrink(1);
            return true;
        }
        return false;
    });
    public static final Supplier<BlockEntityType<BaseChestBlock.BEntity>> BASE_CHEST_ENTITY = ModBlocks.BLOCK_ENTITIES.register("base_chest_entity", () -> BlockEntityType.Builder.of(BaseChestBlock.BEntity::new, (Block[])((Block[])NORMAL_CHESTS.stream().map(DeferredHolder::get).toArray(Block[]::new))).build(DSL.remainderType()));
    public static final Supplier<BlockEntityType<DeathChestBlock.BEntity>> DEATH_CHEST_ENTITY = ModBlocks.BLOCK_ENTITIES.register("death_chest_entity", () -> BlockEntityType.Builder.of(DeathChestBlock.BEntity::new, (Block[])((Block[])DEATH_CHESTS.stream().map(DeferredHolder::get).toArray(Block[]::new))).build(DSL.remainderType()));
    public static final DeferredBlock<BiomeChestBlock> JUNGLE_CHEST = ChestBlocks.registerWithItem("jungle_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.JUNGLE_KEY)));
    public static final DeferredBlock<BiomeChestBlock> CORRUPTION_CHEST = ChestBlocks.registerWithItem("corruption_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.CORRUPTION_KEY)));
    public static final DeferredBlock<BiomeChestBlock> CRIMSON_CHEST = ChestBlocks.registerWithItem("crimson_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.CRIMSON_KEY)));
    public static final DeferredBlock<BiomeChestBlock> HALLOWED_CHEST = ChestBlocks.registerWithItem("hallowed_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.HALLOWED_KEY)));
    public static final DeferredBlock<BiomeChestBlock> ICE_CHEST = ChestBlocks.registerWithItem("ice_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.FROZEN_KEY)));
    public static final DeferredBlock<BiomeChestBlock> DESERT_CHEST = ChestBlocks.registerWithItem("desert_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.DESERT_KEY)));
    public static final DeferredBlock<BiomeChestBlock> OCEAN_CHEST = ChestBlocks.registerWithItem("ocean_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.OCEAN_KEY)));
    public static final DeferredBlock<BiomeChestBlock> UNIVERSE_CHEST = ChestBlocks.registerWithItem("universe_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.UNIVERSE_KEY)));
    public static final DeferredBlock<BiomeChestBlock> MECHANIC_SAFE_CHEST = ChestBlocks.registerWithItem("mechanic_safe_chest", () -> new BiomeChestBlock(stack -> stack.is(ToolItems.MECHANIC_SAFE_KEY)));
    public static final Supplier<BlockEntityType<BiomeChestBlock.BEntity>> BIOME_CHEST_ENTITY = ModBlocks.BLOCK_ENTITIES.register("biome_chest_entity", () -> BlockEntityType.Builder.of(BiomeChestBlock.BEntity::new, (Block[])new Block[]{(Block)JUNGLE_CHEST.get(), (Block)CORRUPTION_CHEST.get(), (Block)CRIMSON_CHEST.get(), (Block)HALLOWED_CHEST.get(), (Block)ICE_CHEST.get(), (Block)DESERT_CHEST.get(), (Block)OCEAN_CHEST.get(), (Block)UNIVERSE_CHEST.get(), (Block)MECHANIC_SAFE_CHEST.get()}).build(DSL.remainderType()));

    private static DeferredBlock<BaseChestBlock> registerNormal(String id, @Nullable Predicate<ItemStack> predicate) {
        DeferredBlock block = BLOCKS.register(id, () -> new BaseChestBlock(predicate == null ? null : (stack, state, level, pos, player, hand, hitResult) -> {
            if (predicate.test(stack)) {
                boolean isDouble;
                Direction relativeDir = ChestBlock.getConnectedDirection((BlockState)state);
                boolean bl = isDouble = state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.playSound(null, pos, SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS);
                    double posX = (double)pos.getX() + 0.5;
                    double posZ = (double)pos.getZ() + 0.5;
                    if (isDouble) {
                        posX += (double)relativeDir.getStepX() * 0.5;
                        posZ += (double)relativeDir.getStepZ() * 0.5;
                    }
                    serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.CHAIN.defaultBlockState()), posX, (double)pos.getY() + 0.5, posZ, 200, 0.0625, 0.0625, 0.0625, 0.15);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BaseChestBlock.UNLOCKED, (Comparable)Boolean.valueOf(true)));
                }
                return true;
            }
            return false;
        }));
        ModItems.BLOCK_ITEMS.register(id, () -> new BaseChestBlock.BItem((Block)block.get(), new Item.Properties()));
        NORMAL_CHESTS.add((DeferredBlock<BaseChestBlock>)block);
        return block;
    }

    private static DeferredBlock<DeathChestBlock> registerDeath(String id) {
        DeferredBlock<DeathChestBlock> block = ChestBlocks.registerWithItem(id, DeathChestBlock::new);
        DEATH_CHESTS.add(block);
        return block;
    }

    private static <B extends Block> DeferredBlock<B> registerWithItem(String id, Supplier<B> supplier) {
        DeferredBlock block = BLOCKS.register(id, supplier);
        ModItems.BLOCK_ITEMS.registerSimpleBlockItem((Holder)block);
        return block;
    }
}

