/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.armor;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.MobEffectInstanceData;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.GetArmorSetBonusDataEvent;
import org.confluence.mod.api.event.RegisterArmorSetBonusEvent;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.entity.projectile.FlowerPetalProjectile;
import org.confluence.mod.common.entity.projectile.TitaniumShardsProjectile;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.armor.ArmorSetBonusData;
import org.confluence.mod.common.init.armor.ArmorSetBonusKey;
import org.confluence.mod.common.init.armor.MobEffectInstancesValue;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.ArmorItems;
import org.confluence.mod.mixed.IServerPlayer;
import org.confluence.terra_curio.api.primitive.AttributeModifiersValue;
import org.confluence.terra_curio.api.primitive.CombineRule;
import org.confluence.terra_curio.api.primitive.FloatValue;
import org.confluence.terra_curio.api.primitive.IntegerValue;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.UnitValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.component.PrimitiveValueComponent;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terraentity.init.TEAttributes;
import org.confluence.terraentity.init.TEEffects;
import org.jetbrains.annotations.Nullable;

public final class ModArmorBonus {
    private static final Object2ObjectMap<ArmorSetBonusKey, ArmorSetBonusData> VALUE_MAP = new Object2ObjectOpenHashMap();
    public static final ArmorSetBonusData WIZARD_HAT_SET_BONUS = new ArmorSetBonusData(PrimitiveValueComponent.entry((ValueType)TCItems.ATTRIBUTES, (PrimitiveValue)AttributeModifiersValue.simple((Holder)TCAttributes.getCriticalChance(), (ResourceLocation)Confluence.asResource("wizard_hat_set_bonus"), (double)0.1, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE)), 1);
    public static final ArmorSetBonusData MAGIC_HAT_SET_BONUS = new ArmorSetBonusData(PrimitiveValueComponent.of(AccessoryItems.ADDITIONAL$MANA, (Object)60), 1);
    public static final CombineRule<Integer, IntegerValue> AS_ENCHANTMENT_INT_CR = CombineRule.register((a, b) -> {
        if (a.equals(b)) {
            return a == 0 ? 0 : a + 1;
        }
        return Math.max(a, b);
    }, (ResourceLocation)Confluence.asResource("as_enchantment"));
    public static final ValueType.UnitType CACTUS$THORNS = ValueType.UnitType.of((ResourceLocation)Confluence.asResource("thorns"));
    public static final ValueType.FloatType SKIP$CONSUME$AMMO$CHANCE = ValueType.FloatType.of((ResourceLocation)Confluence.asResource("skip_consume_ammo_chance"), (CombineRule)FloatValue.ADDITION_WITHIN_0_TO_1, (float)0.0f);
    public static final ValueType.UnitType SPACE$GUN$FREE = ValueType.UnitType.of((ResourceLocation)Confluence.asResource("space_gun_free"));
    public static final ValueType.FloatType HEAL$AMOUNT$MULTIPLIER = ValueType.FloatType.of((ResourceLocation)Confluence.asResource("heal_amount_multiplier"), (CombineRule)FloatValue.ADDITION_WITHIN_0_TO_1, (float)0.0f);
    public static final ValueType<List<MobEffectInstanceData>, MobEffectInstancesValue> HURT$ENEMY$AWARD$EFFECTS = ValueType.create((ResourceLocation)Confluence.asResource("hurt_enemy_award_effects"), MobEffectInstancesValue.MERGE, MobEffectInstancesValue.CODEC, List.of(), MobEffectInstancesValue::new);
    public static final ValueType.UnitType FLOWER$PETAL = ValueType.UnitType.of((ResourceLocation)Confluence.asResource("flower_petal"));
    public static final ValueType.UnitType TITANIUM$SHARDS = ValueType.UnitType.of((ResourceLocation)Confluence.asResource("titanium_shards"));
    public static final ValueType.UnitType LAVA$IMMUNE = ValueType.UnitType.of((ResourceLocation)Confluence.asResource("lava_immune"));
    public static final ValueType.IntegerType DURABILITY$REPAIR$AMOUNT$PER$SECOND$IN$LAVA = ValueType.IntegerType.of((ResourceLocation)Confluence.asResource("durability_repair_amount_per_second_in_lava"), (CombineRule)IntegerValue.GET_MAX, (int)0);
    public static final ValueType.IntegerType FORTUNE = ValueType.IntegerType.of((ResourceLocation)Confluence.asResource("fortune"), AS_ENCHANTMENT_INT_CR, (int)0);
    public static ArmorSetBonusKey COLD_CRYSTAL_SET;
    public static ArmorSetBonusKey HEIM_SET;

    public static void registerArmorSetBonus() {
        ModArmorBonus.register("mining_set", 1, ArmorItems.MINING_HELMET, ArmorItems.MINING_CHESTPLATE, ArmorItems.MINING_LEGGINGS, ArmorItems.MINING_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)Attributes.BLOCK_BREAK_SPEED, (ResourceLocation)key.id, (double)0.1, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        ModArmorBonus.register("plank_set", 1, ArmorItems.PLANK_HELMET, ArmorItems.PLANK_CHESTPLATE, ArmorItems.PLANK_LEGGINGS, ArmorItems.PLANK_BOOTS, ModArmorBonus.armor(1.0));
        ModArmorBonus.register("ash_set", 1, ArmorItems.ASH_HELMET, ArmorItems.ASH_CHESTPLATE, ArmorItems.ASH_LEGGINGS, ArmorItems.ASH_BOOTS, (ArmorSetBonusKey key) -> {
            key.of(TCItems.LAVA$HURT$REDUCE, Float.valueOf(0.5f));
            key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)Attributes.BURNING_TIME, (ResourceLocation)key.id, (double)-0.35, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE));
        });
        ModArmorBonus.register("snow_set", 1, ArmorItems.SNOW_CAPS, ArmorItems.SNOW_SUITS, ArmorItems.INSULATED_PANTS, ArmorItems.INSULATED_SHOES, (ArmorSetBonusKey key) -> key.unit((ValueType<Unit, UnitValue>)TCItems.FROZEN$IMMUNE));
        ModArmorBonus.register("pink_snow_set", 1, ArmorItems.PINK_SNOW_CAPS, ArmorItems.PINK_SNOW_SUITS, ArmorItems.PINK_INSULATED_PANTS, ArmorItems.PINK_INSULATED_SHOES, (ArmorSetBonusKey key) -> key.unit((ValueType<Unit, UnitValue>)TCItems.FROZEN$IMMUNE));
        ModArmorBonus.register("angler_set", 1, ArmorItems.ANGLER_HAT, ArmorItems.ANGLER_VEST, ArmorItems.ANGLER_PANTS, (ItemLike)Items.AIR, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.builder().add((Holder)ConfluenceMagicLib.MOB_SPAWN_SPEED_MULTIPLIER, key.id, -0.23, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add((Holder)ConfluenceMagicLib.MOB_SPAWN_COUNT_MULTIPLIER, key.id, -0.3, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).build()));
        ModArmorBonus.register("cactus_set", 1, ArmorItems.CACTUS_HELMET, ArmorItems.CACTUS_CHESTPLATE, ArmorItems.CACTUS_LEGGINGS, ArmorItems.CACTUS_BOOTS, (ArmorSetBonusKey key) -> key.unit((ValueType<Unit, UnitValue>)CACTUS$THORNS));
        ModArmorBonus.register("copper_set", 1, ArmorItems.COPPER_HELMET, ArmorItems.COPPER_CHESTPLATE, ArmorItems.COPPER_LEGGINGS, ArmorItems.COPPER_BOOTS, ModArmorBonus.armor(1.0));
        ModArmorBonus.register("tin_set", 1, ArmorItems.TIN_HELMET, ArmorItems.TIN_CHESTPLATE, ArmorItems.TIN_LEGGINGS, ArmorItems.TIN_BOOTS, ModArmorBonus.armor(2.0));
        ModArmorBonus.register("pumpkin_set", 1, ArmorItems.PUMPKIN_HELMET, ArmorItems.PUMPKIN_CHESTPLATE, ArmorItems.PUMPKIN_LEGGINGS, ArmorItems.PUMPKIN_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.builder().add(Attributes.ATTACK_DAMAGE, key.id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(TCAttributes.getRangedDamage(), key.id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(TCAttributes.getMagicDamage(), key.id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(TEAttributes.SUMMON_DAMAGE, key.id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).build()));
        ModArmorBonus.register("ninja_set", 1, ArmorItems.NINJA_HELMET, ArmorItems.NINJA_CHESTPLATE, ArmorItems.NINJA_LEGGINGS, ArmorItems.NINJA_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)Attributes.MOVEMENT_SPEED, (ResourceLocation)key.id, (double)0.2, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        ModArmorBonus.register("lead_set", 1, ArmorItems.LEAD_HELMET, ArmorItems.LEAD_CHESTPLATE, ArmorItems.LEAD_LEGGINGS, ArmorItems.LEAD_BOOTS, ModArmorBonus.armor(1.0));
        ModArmorBonus.register("silver_set", 1, ArmorItems.SILVER_HELMET, ArmorItems.SILVER_CHESTPLATE, ArmorItems.SILVER_LEGGINGS, ArmorItems.SILVER_BOOTS, ModArmorBonus.armor(2.0));
        ModArmorBonus.register("tungsten_set", 1, ArmorItems.TUNGSTEN_HELMET, ArmorItems.TUNGSTEN_CHESTPLATE, ArmorItems.TUNGSTEN_LEGGINGS, ArmorItems.TUNGSTEN_BOOTS, ModArmorBonus.armor(1.0));
        ModArmorBonus.register("golden_set", 1, ArmorItems.GOLDEN_HELMET, ArmorItems.GOLDEN_CHESTPLATE, ArmorItems.GOLDEN_LEGGINGS, ArmorItems.GOLDEN_BOOTS, ModArmorBonus.armor(1.0));
        ModArmorBonus.register("platinum_set", 1, ArmorItems.PLATINUM_HELMET, ArmorItems.PLATINUM_CHESTPLATE, ArmorItems.PLATINUM_LEGGINGS, ArmorItems.PLATINUM_BOOTS, ModArmorBonus.armor(2.0));
        ModArmorBonus.register("fossil_set", 1, ArmorItems.FOSSIL_HELMET, ArmorItems.FOSSIL_CHESTPLATE, ArmorItems.FOSSIL_LEGGINGS, ArmorItems.FOSSIL_BOOTS, (ArmorSetBonusKey key) -> key.of(SKIP$CONSUME$AMMO$CHANCE, Float.valueOf(0.2f)));
        COLD_CRYSTAL_SET = ModArmorBonus.register("cold_crystal_set", 1, ArmorItems.COLD_CRYSTAL_HELMET, ArmorItems.COLD_CRYSTAL_CHESTPLATE, ArmorItems.COLD_CRYSTAL_LEGGINGS, ArmorItems.COLD_CRYSTAL_BOOTS, (ArmorSetBonusKey key) -> {});
        HEIM_SET = ModArmorBonus.register("heim_set", 1, ArmorItems.HEIM_HELMET, ArmorItems.HEIM_CHESTPLATE, ArmorItems.HEIM_LEGGINGS, ArmorItems.HEIM_BOOTS, (ArmorSetBonusKey key) -> {});
        ModArmorBonus.register("spore_root_set", 1, ArmorItems.SPORE_ROOT_HELMET, ArmorItems.SPORE_ROOT_CHESTPLATE, ArmorItems.SPORE_ROOT_LEGGINGS, ArmorItems.SPORE_ROOT_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)TEAttributes.MINION_CAPACITY, (ResourceLocation)key.id, (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE)));
        ModArmorBonus.register("bee_set", 1, ArmorItems.BEE_HELMET, ArmorItems.BEE_CHESTPLATE, ArmorItems.BEE_LEGGINGS, ArmorItems.BEE_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)TEAttributes.SUMMON_DAMAGE, (ResourceLocation)key.id, (double)0.1, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        ModArmorBonus.register("obsidian_set", 2, ArmorItems.OBSIDIAN_HELMET, ArmorItems.OBSIDIAN_CHESTPLATE, ArmorItems.OBSIDIAN_LEGGINGS, ArmorItems.OBSIDIAN_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.builder().add(TEAttributes.WHIP_RANGE, key.id, 0.3, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(Attributes.ATTACK_SPEED, key.id, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(TEAttributes.SUMMON_DAMAGE, key.id, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).build()));
        ModArmorBonus.register("gladiator_set", 1, ArmorItems.GLADIATOR_HELMET, ArmorItems.GLADIATOR_CHESTPLATE, ArmorItems.GLADIATOR_LEGGINGS, ArmorItems.GLADIATOR_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.builder().add(Attributes.KNOCKBACK_RESISTANCE, key.id, 1.0, AttributeModifier.Operation.ADD_VALUE).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, key.id, 1.0, AttributeModifier.Operation.ADD_VALUE).build()));
        ModArmorBonus.register("meteor_set", 1, ArmorItems.METEOR_HELMET, ArmorItems.METEOR_CHESTPLATE, ArmorItems.METEOR_LEGGINGS, ArmorItems.METEOR_BOOTS, (ArmorSetBonusKey key) -> key.unit((ValueType<Unit, UnitValue>)SPACE$GUN$FREE));
        ModArmorBonus.register("jungle_set", 1, ArmorItems.JUNGLE_HELMET, ArmorItems.JUNGLE_CHESTPLATE, ArmorItems.JUNGLE_LEGGINGS, ArmorItems.JUNGLE_BOOTS, (ArmorSetBonusKey key) -> key.of(AccessoryItems.MANA$USE$REDUCE, Float.valueOf(0.16f)));
        ModArmorBonus.register("necro_set", 1, ArmorItems.NECRO_HELMET, ArmorItems.NECRO_CHESTPLATE, ArmorItems.NECRO_LEGGINGS, ArmorItems.NECRO_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)TCAttributes.getCriticalChance(), (ResourceLocation)key.id, (double)0.1, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE)));
        ModArmorBonus.register("shadow_set", 1, ArmorItems.SHADOW_HELMET, ArmorItems.SHADOW_CHESTPLATE, ArmorItems.SHADOW_LEGGINGS, ArmorItems.SHADOW_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)Attributes.MOVEMENT_SPEED, (ResourceLocation)key.id, (double)0.15, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        ModArmorBonus.register("crimson_set", 1, ArmorItems.CRIMSON_HELMET, ArmorItems.CRIMSON_CHESTPLATE, ArmorItems.CRIMSON_LEGGINGS, ArmorItems.CRIMSON_BOOTS, (ArmorSetBonusKey key) -> key.of(HEAL$AMOUNT$MULTIPLIER, Float.valueOf(0.5f)));
        ModArmorBonus.register("molten_set", 2, ArmorItems.MOLTEN_HELMET, ArmorItems.MOLTEN_CHESTPLATE, ArmorItems.MOLTEN_LEGGINGS, ArmorItems.MOLTEN_BOOTS, (ArmorSetBonusKey key) -> {
            key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)Attributes.ATTACK_DAMAGE, (ResourceLocation)key.id, (double)0.1, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            key.unit((ValueType<Unit, UnitValue>)TCItems.FIRE$IMMUNE);
        });
        ModArmorBonus.register("pearlwood_set", 1, ArmorItems.PEARL_HELMET, ArmorItems.PEARL_CHESTPLATE, ArmorItems.PEARL_LEGGINGS, ArmorItems.PEARL_BOOTS, ModArmorBonus.armor(1.0));
        ModArmorBonus.register("spider_set", 1, ArmorItems.SPIDER_HELMET, ArmorItems.SPIDER_CHESTPLATE, ArmorItems.SPIDER_LEGGINGS, ArmorItems.SPIDER_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)TEAttributes.SUMMON_DAMAGE, (ResourceLocation)key.id, (double)0.12, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        ModArmorBonus.register("cobalt_helmet_set", 1, ArmorItems.COBALT_HELMET, ArmorItems.COBALT_CHESTPLATE, ArmorItems.COBALT_LEGGINGS, ArmorItems.COBALT_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)Attributes.ATTACK_SPEED, (ResourceLocation)key.id, (double)0.15, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
        ModArmorBonus.register("cobalt_mask_set", 1, ArmorItems.COBALT_MASK, ArmorItems.COBALT_CHESTPLATE, ArmorItems.COBALT_LEGGINGS, ArmorItems.COBALT_BOOTS, (ArmorSetBonusKey key) -> key.of(SKIP$CONSUME$AMMO$CHANCE, Float.valueOf(0.2f)));
        ModArmorBonus.register("cobalt_hat_set", 1, ArmorItems.COBALT_HAT, ArmorItems.COBALT_CHESTPLATE, ArmorItems.COBALT_LEGGINGS, ArmorItems.COBALT_BOOTS, (ArmorSetBonusKey key) -> key.of(AccessoryItems.MANA$USE$REDUCE, Float.valueOf(0.14f)));
        Consumer<ArmorSetBonusKey> palladiumSet = key -> key.of(HURT$ENEMY$AWARD$EFFECTS, List.of(new MobEffectInstanceData(MobEffects.REGENERATION, 100, 1)));
        ModArmorBonus.register("palladium_mask_set", 1, ArmorItems.PALLADIUM_MASK, ArmorItems.PALLADIUM_CHESTPLATE, ArmorItems.PALLADIUM_LEGGINGS, ArmorItems.PALLADIUM_BOOTS, palladiumSet);
        ModArmorBonus.register("palladium_helmet_set", 1, ArmorItems.PALLADIUM_HELMET, ArmorItems.PALLADIUM_CHESTPLATE, ArmorItems.PALLADIUM_LEGGINGS, ArmorItems.PALLADIUM_BOOTS, palladiumSet);
        ModArmorBonus.register("palladium_headgear_set", 1, ArmorItems.PALLADIUM_HEADGEAR, ArmorItems.PALLADIUM_CHESTPLATE, ArmorItems.PALLADIUM_LEGGINGS, ArmorItems.PALLADIUM_BOOTS, palladiumSet);
        ModArmorBonus.register("mythril_hood_set", 1, ArmorItems.MYTHRIL_HOOD, ArmorItems.MYTHRIL_CHESTPLATE, ArmorItems.MYTHRIL_LEGGINGS, ArmorItems.MYTHRIL_BOOTS, (ArmorSetBonusKey key) -> key.of(AccessoryItems.MANA$USE$REDUCE, Float.valueOf(0.17f)));
        ModArmorBonus.register("mythril_helmet_set", 1, ArmorItems.MYTHRIL_HELMET, ArmorItems.MYTHRIL_CHESTPLATE, ArmorItems.MYTHRIL_LEGGINGS, ArmorItems.MYTHRIL_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)TCAttributes.getCriticalChance(), (ResourceLocation)key.id, (double)0.1, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE)));
        ModArmorBonus.register("mythril_hat_set", 1, ArmorItems.MYTHRIL_HAT, ArmorItems.MYTHRIL_CHESTPLATE, ArmorItems.MYTHRIL_LEGGINGS, ArmorItems.MYTHRIL_BOOTS, (ArmorSetBonusKey key) -> key.of(SKIP$CONSUME$AMMO$CHANCE, Float.valueOf(0.2f)));
        Consumer<ArmorSetBonusKey> orichalcumSet = key -> key.unit((ValueType<Unit, UnitValue>)FLOWER$PETAL);
        ModArmorBonus.register("orichalcum_headgear_set", 1, ArmorItems.ORICHALCUM_HEADGEAR, ArmorItems.ORICHALCUM_CHESTPLATE, ArmorItems.ORICHALCUM_LEGGINGS, ArmorItems.ORICHALCUM_BOOTS, orichalcumSet);
        ModArmorBonus.register("orichalcum_mask_set", 1, ArmorItems.ORICHALCUM_MASK, ArmorItems.ORICHALCUM_CHESTPLATE, ArmorItems.ORICHALCUM_LEGGINGS, ArmorItems.ORICHALCUM_BOOTS, orichalcumSet);
        ModArmorBonus.register("orichalcum_helmet_set", 1, ArmorItems.ORICHALCUM_HELMET, ArmorItems.ORICHALCUM_CHESTPLATE, ArmorItems.ORICHALCUM_LEGGINGS, ArmorItems.ORICHALCUM_BOOTS, orichalcumSet);
        ModArmorBonus.register("adamantite_headgear_set", 1, ArmorItems.ADAMANTITE_HEADGEAR, ArmorItems.ADAMANTITE_CHESTPLATE, ArmorItems.ADAMANTITE_LEGGINGS, ArmorItems.ADAMANTITE_BOOTS, (ArmorSetBonusKey key) -> key.of(AccessoryItems.MANA$USE$REDUCE, Float.valueOf(0.19f)));
        ModArmorBonus.register("adamantite_helmet_set", 1, ArmorItems.ADAMANTITE_HELMET, ArmorItems.ADAMANTITE_CHESTPLATE, ArmorItems.ADAMANTITE_LEGGINGS, ArmorItems.ADAMANTITE_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.builder().add(Attributes.ATTACK_SPEED, key.id, 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(Attributes.MOVEMENT_SPEED, key.id, 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).build()));
        ModArmorBonus.register("adamantite_mask_set", 1, ArmorItems.ADAMANTITE_MASK, ArmorItems.ADAMANTITE_CHESTPLATE, ArmorItems.ADAMANTITE_LEGGINGS, ArmorItems.ADAMANTITE_BOOTS, (ArmorSetBonusKey key) -> key.of(SKIP$CONSUME$AMMO$CHANCE, Float.valueOf(0.25f)));
        Consumer<ArmorSetBonusKey> titaniumSet = key -> key.unit((ValueType<Unit, UnitValue>)TITANIUM$SHARDS);
        ModArmorBonus.register("titanium_mask_set", 1, ArmorItems.TITANIUM_MASK, ArmorItems.TITANIUM_CHESTPLATE, ArmorItems.TITANIUM_LEGGINGS, ArmorItems.TITANIUM_BOOTS, titaniumSet);
        ModArmorBonus.register("titanium_helmet_set", 1, ArmorItems.TITANIUM_HELMET, ArmorItems.TITANIUM_CHESTPLATE, ArmorItems.TITANIUM_LEGGINGS, ArmorItems.TITANIUM_BOOTS, titaniumSet);
        ModArmorBonus.register("titanium_headgear_set", 1, ArmorItems.TITANIUM_HEADGEAR, ArmorItems.TITANIUM_CHESTPLATE, ArmorItems.TITANIUM_LEGGINGS, ArmorItems.TITANIUM_BOOTS, titaniumSet);
        ModArmorBonus.register("diamond_set", 1, (ItemLike)Items.DIAMOND_HELMET, (ItemLike)Items.DIAMOND_CHESTPLATE, (ItemLike)Items.DIAMOND_LEGGINGS, (ItemLike)Items.DIAMOND_BOOTS, (ArmorSetBonusKey key) -> key.of(FORTUNE, 2));
        ModArmorBonus.register("netherite_set", 4, (ItemLike)Items.NETHERITE_HELMET, (ItemLike)Items.NETHERITE_CHESTPLATE, (ItemLike)Items.NETHERITE_LEGGINGS, (ItemLike)Items.NETHERITE_BOOTS, (ArmorSetBonusKey key) -> {
            key.unit((ValueType<Unit, UnitValue>)LAVA$IMMUNE);
            key.of(DURABILITY$REPAIR$AMOUNT$PER$SECOND$IN$LAVA, 50);
            key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.builder().add(Attributes.ATTACK_DAMAGE, key.id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(TCAttributes.getRangedDamage(), key.id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(TCAttributes.getMagicDamage(), key.id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(TEAttributes.SUMMON_DAMAGE, key.id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).add(Attributes.MOVEMENT_SPEED, key.id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).build());
        });
        ModArmorBonus.register("tiki_set", 2, ArmorItems.TIKI_MASK, ArmorItems.TIKI_SHIRT, ArmorItems.TIKI_LEGGINGS, ArmorItems.TIKI_BOOTS, (ArmorSetBonusKey key) -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.builder().add(TEAttributes.MINION_CAPACITY, key.id, 1.0, AttributeModifier.Operation.ADD_VALUE).add(TEAttributes.WHIP_RANGE, key.id, 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).build()));
        ModLoader.postEvent((Event)new RegisterArmorSetBonusEvent(ModArmorBonus::register));
    }

    private static Consumer<ArmorSetBonusKey> armor(double value) {
        return key -> key.entry(TCItems.ATTRIBUTES, AttributeModifiersValue.simple((Holder)Attributes.ARMOR, (ResourceLocation)key.id, (double)value, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE));
    }

    private static ArmorSetBonusKey register(String path, int tooltipCount, ItemLike head, ItemLike chest, ItemLike legs, ItemLike feet, Consumer<ArmorSetBonusKey> consumer) {
        return ModArmorBonus.register(Confluence.asResource(path), tooltipCount, head, chest, legs, feet, consumer);
    }

    private static ArmorSetBonusKey register(ResourceLocation id, int tooltipCount, ItemLike head, ItemLike chest, ItemLike legs, ItemLike feet, Consumer<ArmorSetBonusKey> consumer) {
        ArmorSetBonusKey key = new ArmorSetBonusKey(head, chest, legs, feet, ArmorSetBonusKey.mixHash(head, chest, legs, feet, true));
        if (ArmorSetBonusKey.MAP.put((Object)id, (Object)key) != null) {
            throw new IllegalArgumentException("Duplicated ArmorBonusKey with id '" + String.valueOf(id) + "'");
        }
        key.types = new HashMap();
        key.id = id;
        consumer.accept(key);
        VALUE_MAP.put((Object)key, (Object)new ArmorSetBonusData(new PrimitiveValueComponent(key.types), tooltipCount));
        key.types = null;
        return key;
    }

    public static boolean isArmorSet(Player player, ResourceLocation id) {
        return ModArmorBonus.isArmorSet(player, ArmorSetBonusKey.byId(id));
    }

    public static boolean isArmorSet(Player player, ArmorSetBonusKey key) {
        return PlayerSpecialData.of(player).getArmorSetBonusKey().equals(key);
    }

    public static <T, V extends PrimitiveValue<T>> boolean hasType(Player player, ValueType<T, V> type) {
        return PlayerSpecialData.of(player).contains(type);
    }

    public static <T, V extends PrimitiveValue<T>> T getValue(Player player, ValueType<T, V> type) {
        return (T)PlayerSpecialData.of(player).getValue(type);
    }

    @Nullable
    public static <T, V extends PrimitiveValue<T>> V getPrimitiveValue(Player player, ValueType<T, V> type) {
        return (V)PlayerSpecialData.of(player).getPrimitiveValue(type);
    }

    @Nullable
    public static PrimitiveValueComponent getArmorStackBonus(ItemStack itemStack) {
        return (PrimitiveValueComponent)itemStack.get(ModDataComponentTypes.ARMOR_BONUS);
    }

    @Nullable
    public static ArmorSetBonusData getArmorSetBonusData(Player player, ArmorSetBonusKey key) {
        if (key == ArmorSetBonusKey.NONE) {
            return null;
        }
        return ((GetArmorSetBonusDataEvent)NeoForge.EVENT_BUS.post((Event)new GetArmorSetBonusDataEvent(player, key, (ArmorSetBonusData)VALUE_MAP.get((Object)key)))).getNeoData();
    }

    public static Object2ObjectMap<ArmorSetBonusKey, ArmorSetBonusData> getValueMap() {
        return VALUE_MAP;
    }

    public static void addBonusTooltip(@Nullable Player player, ItemStack itemStack, List<Component> toolTip) {
        block14: {
            if (player == null) {
                return;
            }
            ArmorSetBonusKey key = PlayerSpecialData.of(player).getArmorSetBonusKey();
            if (key == ArmorSetBonusKey.NONE) {
                return;
            }
            Item item = itemStack.getItem();
            if (!(item instanceof ArmorItem)) break block14;
            ArmorItem armorItem = (ArmorItem)item;
            switch (armorItem.getEquipmentSlot()) {
                case FEET: {
                    if (key.feet() == armorItem) {
                        break;
                    }
                    break block14;
                }
                case LEGS: {
                    if (key.legs() == armorItem) {
                        break;
                    }
                    break block14;
                }
                case CHEST: {
                    if (key.chest() == armorItem) {
                        break;
                    }
                    break block14;
                }
                case HEAD: {
                    if (key.head() == armorItem) {
                        break;
                    }
                    break block14;
                }
                default: {
                    break block14;
                }
            }
            ArmorSetBonusData data = ModArmorBonus.getArmorSetBonusData(player, key);
            if (data == null || data.tooltipCount() == 0) {
                return;
            }
            String descriptionKey = key.getDescriptionKey();
            toolTip.add((Component)Component.translatable((String)"armor_set_bonus.when_applied").withStyle(ChatFormatting.GRAY));
            for (int i = 0; i < data.tooltipCount(); ++i) {
                toolTip.add((Component)Component.translatable((String)("armor_set_bonus." + descriptionKey + "." + i)).withStyle(ChatFormatting.AQUA));
            }
        }
    }

    public static float applyHealAmount(Player player, float amount) {
        return amount * (1.0f + ((Float)ModArmorBonus.getValue(player, HEAL$AMOUNT$MULTIPLIER)).floatValue());
    }

    public static void beAttacked(ServerPlayer player, DamageSource damageSource) {
        if (ModArmorBonus.hasType((Player)player, CACTUS$THORNS)) {
            Entity entity = damageSource.getEntity();
            if (entity != null && entity.isRemoved()) {
                entity = damageSource.getDirectEntity();
            }
            if (entity != null && !entity.isRemoved()) {
                DamageSource damageSource2 = player.damageSources().cactus();
                entity.hurt(damageSource2, switch (player.level().getDifficulty()) {
                    case Difficulty.EASY -> 3.0f;
                    case Difficulty.NORMAL -> 8.0f;
                    case Difficulty.HARD -> 11.0f;
                    default -> 0.0f;
                });
            }
        }
    }

    public static void onAttacked(ServerPlayer player, DamageSource damageSource, LivingEntity victim) {
        List<MobEffectInstanceData> effects;
        if (victim instanceof Enemy && !(effects = ModArmorBonus.getValue((Player)player, HURT$ENEMY$AWARD$EFFECTS)).isEmpty()) {
            for (MobEffectInstanceData effect : effects) {
                player.addEffect(effect.create());
            }
        }
        if (ModArmorBonus.hasType((Player)player, FLOWER$PETAL) && !(damageSource.getDirectEntity() instanceof FlowerPetalProjectile)) {
            CompoundTag tag = LibUtils.getOrCreatePersistedData((Player)player);
            long gameTime = player.level().getGameTime();
            if (gameTime - tag.getLong("confluence:last_flower_petal_attack") >= 6L) {
                tag.putLong("confluence:last_flower_petal_attack", gameTime);
                FlowerPetalProjectile projectile = new FlowerPetalProjectile((Player)player);
                Vec3 position = victim.position().add(0.0, (double)victim.getBbHeight() * 0.5, 0.0);
                RandomSource random = player.getRandom();
                double y = ((double)random.nextFloat() - 0.5) * 10.0;
                Vec3 offset = position.add(((double)random.nextFloat() - 0.5) * 10.0, y > 0.0 ? y + 5.0 : y, ((double)random.nextFloat() - 0.5) * 10.0);
                projectile.setPos(offset);
                projectile.shoot(position.x - offset.x, position.y - offset.y, position.z - offset.z, 1.2f, 0.0f);
                player.level().addFreshEntity((Entity)projectile);
            }
        }
        if (player instanceof IServerPlayer) {
            IServerPlayer serverPlayer = (IServerPlayer)player;
            if (ModArmorBonus.hasType((Player)player, TITANIUM$SHARDS) && !player.hasEffect(ModEffects.TITANIUM_BARRIER) && !(damageSource.getDirectEntity() instanceof TitaniumShardsProjectile) && !serverPlayer.confluence$hasTitaniumShards()) {
                player.addEffect(new MobEffectInstance(ModEffects.TITANIUM_BARRIER, 200));
                TitaniumShardsProjectile projectile = new TitaniumShardsProjectile((Player)player);
                serverPlayer.confluence$setTitaniumShards(projectile);
                player.level().addFreshEntity((Entity)projectile);
            }
        }
        if (damageSource.is(Tags.DamageTypes.IS_MAGIC) && ModArmorBonus.isArmorSet((Player)player, COLD_CRYSTAL_SET)) {
            victim.addEffect(new MobEffectInstance((Holder)TEEffects.FROST_BURN, 100));
        }
    }

    public static void onBreath(LivingBreatheEvent event) {
        LivingEntity livingEntity;
        if (event.canBreathe() || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.getAirSupply() > 0 && player.level().getGameTime() % 20L == 0L && ModArmorBonus.isArmorSet(player, HEIM_SET)) {
            event.setConsumeAirAmount(0);
        }
    }

    public static void afterTick(ServerPlayer player, long gameTime) {
        int amount;
        if (gameTime % 80L == 0L && ModArmorBonus.isArmorSet((Player)player, HEIM_SET)) {
            player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1, false, false));
        }
        if (gameTime % 20L == 0L && player.isInLava() && (amount = ((Integer)ModArmorBonus.getValue((Player)player, DURABILITY$REPAIR$AMOUNT$PER$SECOND$IN$LAVA)).intValue()) > 0) {
            for (ItemStack stack : player.getArmorSlots()) {
                int j = Math.min(amount, stack.getDamageValue());
                stack.setDamageValue(stack.getDamageValue() - j);
            }
        }
    }
}

