/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.armor;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.confluence.mod.Confluence;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.UnitValue;
import org.confluence.terra_curio.api.primitive.ValueType;

public final class ArmorSetBonusKey {
    public static final ResourceLocation NONE_ID = Confluence.asResource("none");
    public static final ArmorSetBonusKey NONE = new ArmorSetBonusKey(Items.AIR, Items.AIR, Items.AIR, Items.AIR, ArmorSetBonusKey.mixHash((ItemLike)Items.AIR, (ItemLike)Items.AIR, (ItemLike)Items.AIR, (ItemLike)Items.AIR, false));
    static final BiMap<ResourceLocation, ArmorSetBonusKey> MAP = (BiMap)Util.make((Object)HashBiMap.create(), map -> map.put((Object)NONE_ID, (Object)NONE));
    public static final Codec<ArmorSetBonusKey> CODEC = ResourceLocation.CODEC.xmap(arg_0 -> MAP.get(arg_0), arg_0 -> MAP.inverse().get(arg_0));
    private final Item head;
    private final Item chest;
    private final Item legs;
    private final Item feet;
    private final int hash;
    transient Map<ValueType<?, ? extends PrimitiveValue<?>>, PrimitiveValue<?>> types;
    transient ResourceLocation id;
    private transient String descriptionKey;

    ArmorSetBonusKey(Item head, Item chest, Item legs, Item feet, int hash) {
        this.head = head;
        this.chest = chest;
        this.legs = legs;
        this.feet = feet;
        this.hash = hash;
    }

    ArmorSetBonusKey(ItemLike head, ItemLike chest, ItemLike legs, ItemLike feet, int hash) {
        this(head.asItem(), chest.asItem(), legs.asItem(), feet.asItem(), hash);
    }

    public static ArmorSetBonusKey of(ItemStack head, ItemStack chest, ItemStack legs, ItemStack feet) {
        return new ArmorSetBonusKey(head.getItem(), chest.getItem(), legs.getItem(), feet.getItem(), ArmorSetBonusKey.mixHash((ItemLike)head.getItem(), (ItemLike)chest.getItem(), (ItemLike)legs.getItem(), (ItemLike)feet.getItem(), false));
    }

    public static ResourceLocation getId(ArmorSetBonusKey key) {
        return Objects.requireNonNull((ResourceLocation)MAP.inverse().getOrDefault((Object)key, (Object)NONE_ID));
    }

    public static ArmorSetBonusKey byId(ResourceLocation id) {
        return Objects.requireNonNull((ArmorSetBonusKey)MAP.getOrDefault((Object)id, (Object)NONE));
    }

    static int mixHash(ItemLike head, ItemLike chest, ItemLike legs, ItemLike feet, boolean check) {
        if (check && head == Items.AIR && chest == Items.AIR && legs == Items.AIR && feet == Items.AIR) {
            throw new IllegalArgumentException("head, chest, legs and feet must at least one non-air");
        }
        return Objects.hash(head.asItem(), chest.asItem(), legs.asItem(), feet.asItem());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof ArmorSetBonusKey)) return false;
        ArmorSetBonusKey a = (ArmorSetBonusKey)o;
        if (a.hash != this.hash) return false;
        if (a.head != this.head) return false;
        if (a.chest != this.chest) return false;
        if (a.legs != this.legs) return false;
        if (a.feet != this.feet) return false;
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public Item head() {
        return this.head;
    }

    public Item chest() {
        return this.chest;
    }

    public Item legs() {
        return this.legs;
    }

    public Item feet() {
        return this.feet;
    }

    public String toString() {
        return "Key[head=" + String.valueOf(this.head) + ", chest=" + String.valueOf(this.chest) + ", legs=" + String.valueOf(this.legs) + ", feet=" + String.valueOf(this.feet) + ", hash=" + this.hash + "]";
    }

    public <T, V extends PrimitiveValue<T>> void of(ValueType<T, V> type, T value) {
        this.types.put(type, type.newInstance(value));
    }

    public <T, V extends PrimitiveValue<T>> void entry(ValueType<T, V> type, V value) {
        this.types.put(type, value);
    }

    public void unit(ValueType<Unit, UnitValue> type) {
        this.types.put((ValueType<?, PrimitiveValue<?>>)type, (PrimitiveValue<?>)UnitValue.INSTANCE);
    }

    public ResourceLocation getId() {
        if (this.id == null) {
            this.id = ArmorSetBonusKey.getId(this);
        }
        return this.id;
    }

    public String getDescriptionKey() {
        if (this.descriptionKey == null) {
            ResourceLocation id = this.getId();
            this.descriptionKey = id.equals((Object)NONE_ID) ? "unregistered." + this.hash : id.getNamespace() + "." + id.getPath();
        }
        return this.descriptionKey;
    }
}

