/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import org.confluence.lib.common.fluid.FluidTriple;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.ShimmerEntityTransmutationEvent;
import org.confluence.mod.common.block.natural.AetheriumBlock;
import org.confluence.mod.common.block.natural.CrispyHoneyBlock;
import org.confluence.mod.common.block.natural.ThinHoneyBlock;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.terraentity.init.entity.TEAnimals;
import org.confluence.terraentity.init.entity.TENpcEntities;

public final class ModFluids {
    public static final FluidTriple HONEY = FluidTriple.builder((ResourceLocation)Confluence.asResource("honey")).typeProperties(properties -> properties.density(2000).canSwim(false).viscosity(3000).motionScale(3.0E-4).canExtinguish(true).supportsBoating(true).rarity(Rarity.UNCOMMON).fallDistanceModifier(0.2f).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).addDripstoneDripping(0.05859375f, (ParticleOptions)ParticleTypes.DRIPPING_DRIPSTONE_WATER, (Block)ModBlocks.HONEY_CAULDRON.get(), SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON)).baseProperties(properties -> properties.block(ModBlocks.HONEY).bucket(ToolItems.HONEY_BUCKET)).build();
    public static final FluidTriple SHIMMER = FluidTriple.builder((ResourceLocation)Confluence.asResource("shimmer")).typeProperties(properties -> properties.density(800).lightLevel(10).viscosity(800).canSwim(false).motionScale(0.02).canExtinguish(true).supportsBoating(true).rarity(Rarity.EPIC).fallDistanceModifier(0.0f).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).addDripstoneDripping(0.05859375f, (ParticleOptions)ParticleTypes.DRIPPING_DRIPSTONE_WATER, (Block)ModBlocks.AETHERIUM_CAULDRON.get(), SoundEvents.POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON)).baseProperties(properties -> properties.block(ModBlocks.SHIMMER).bucket(() -> Items.AIR)).build();

    public static void registerInteraction() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)HONEY.type().get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.WATER_TYPE.value(), fluidState -> fluidState.isSource() ? Blocks.HONEY_BLOCK.defaultBlockState() : ((ThinHoneyBlock)((Object)((Object)NatureBlocks.THIN_HONEY_BLOCK.get()))).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)HONEY.type().get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.LAVA_TYPE.value(), fluidState -> fluidState.isSource() ? ((CrispyHoneyBlock)((Object)((Object)DecorativeBlocks.CRISPY_HONEY_BLOCK.get()))).defaultBlockState() : ((Block)NatureBlocks.LOOSE_HONEY_BLOCK.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)SHIMMER.type().get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.WATER_TYPE.value(), fluidState -> fluidState.isSource() ? ((AetheriumBlock)((Object)((Object)NatureBlocks.AETHERIUM_BLOCK.get()))).defaultBlockState() : ((Block)NatureBlocks.DARK_AETHERIUM_BLOCK.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)SHIMMER.type().get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.LAVA_TYPE.value(), fluidState -> fluidState.isSource() ? ((AetheriumBlock)((Object)((Object)NatureBlocks.AETHERIUM_BLOCK.get()))).defaultBlockState() : ((Block)NatureBlocks.DARK_AETHERIUM_BLOCK.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)SHIMMER.type().get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)HONEY.type().get(), fluidState -> fluidState.isSource() ? ((AetheriumBlock)((Object)((Object)NatureBlocks.AETHERIUM_BLOCK.get()))).defaultBlockState() : ((Block)NatureBlocks.DARK_AETHERIUM_BLOCK.get()).defaultBlockState()));
    }

    public static void registerShimmerTransform() {
        ShimmerEntityTransmutationEvent.addEntity(EntityType.WITCH, EntityType.VILLAGER);
        ShimmerEntityTransmutationEvent.addEntity(entity -> {
            EntityType entityType = entity.getType();
            return entityType == EntityType.PIGLIN || entityType == EntityType.PIGLIN_BRUTE || entityType == EntityType.ZOMBIFIED_PIGLIN || entityType == EntityType.CREEPER;
        }, EntityType.PIG);
        ShimmerEntityTransmutationEvent.addEntity(entity -> entity instanceof AbstractSkeleton || entity.getType() == EntityType.ZOMBIE, EntityType.SKELETON);
        ShimmerEntityTransmutationEvent.addEntity(entity -> entity instanceof AbstractHorse, EntityType.HORSE);
        ShimmerEntityTransmutationEvent.addEntity(EntityType.VEX, EntityType.ALLAY);
        ShimmerEntityTransmutationEvent.addEntity(entity -> {
            Creeper creeper;
            return entity instanceof Creeper && (creeper = (Creeper)entity).isPowered();
        }, EntityType.CREEPER);
        ShimmerEntityTransmutationEvent.addEntity(EntityType.MOOSHROOM, EntityType.COW);
        ShimmerEntityTransmutationEvent.addEntity((EntityType)TENpcEntities.ANGLER.get(), (EntityType)TENpcEntities.FEMALE_ANGLER.get());
        ShimmerEntityTransmutationEvent.addEntity((EntityType)TENpcEntities.FEMALE_ANGLER.get(), (EntityType)TENpcEntities.ANGLER.get());
        ShimmerEntityTransmutationEvent.addEntity(ModTags.EntityTypes.FEALING_TRANSMUTATION, (EntityType)TEAnimals.FEALING.get());
    }

    public static void initialize() {
    }
}

