/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.worldgen.biome.AshForestRegion;
import org.confluence.mod.common.worldgen.biome.AshWastelandRegion;
import org.confluence.mod.common.worldgen.biome.GlowingMushroomRegion;
import org.confluence.mod.common.worldgen.biome.SurfaceRuleData;
import org.confluence.mod.common.worldgen.biome.TheCorruptionRegion;
import org.confluence.mod.common.worldgen.biome.TheCrimsonRegion;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public final class ModBiomes {
    public static final ResourceKey<Biome> THE_CORRUPTION = ModBiomes.register("the_corruption");
    public static final ResourceKey<Biome> THE_CORRUPTION_DESERT = ModBiomes.register("the_corruption_desert");
    public static final ResourceKey<Biome> THE_CORRUPTION_TUNDRA = ModBiomes.register("the_corruption_tundra");
    public static final ResourceKey<Biome> THE_CRIMSON = ModBiomes.register("the_crimson");
    public static final ResourceKey<Biome> THE_CRIMSON_DESERT = ModBiomes.register("the_crimson_desert");
    public static final ResourceKey<Biome> THE_CRIMSON_TUNDRA = ModBiomes.register("the_crimson_tundra");
    public static final ResourceKey<Biome> THE_HALLOW = ModBiomes.register("the_hallow");
    public static final ResourceKey<Biome> THE_HALLOW_DESERT = ModBiomes.register("the_hallow_desert");
    public static final ResourceKey<Biome> THE_HALLOW_TUNDRA = ModBiomes.register("the_hallow_tundra");
    public static final ResourceKey<Biome> ASH_FOREST = ModBiomes.register("ash_forest");
    public static final ResourceKey<Biome> ASH_WASTELAND = ModBiomes.register("ash_wasteland");
    public static final ResourceKey<Biome> GLOWING_MUSHROOM = ModBiomes.register("glowing_mushroom");

    private static ResourceKey<Biome> register(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Confluence.asResource(name));
    }

    public static void registerRegionAndSurface() {
        Regions.register((Region)new TheCrimsonRegion(Confluence.asResource("the_crimson"), 1));
        Regions.register((Region)new TheCorruptionRegion(Confluence.asResource("the_corruption"), 1));
        Regions.register((Region)new GlowingMushroomRegion(Confluence.asResource("glowing_mushroom"), 2));
        Regions.register((Region)new AshForestRegion(Confluence.asResource("ash_forest"), 1));
        Regions.register((Region)new AshWastelandRegion(Confluence.asResource("ash_wasteland"), 1));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"confluence", (SurfaceRules.RuleSource)SurfaceRuleData.makeConfluenceOverWorldRules());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"confluence", (SurfaceRules.RuleSource)SurfaceRuleData.makeConfluenceNetherRules());
        SurfaceRuleManager.addToDefaultSurfaceRulesAtStage((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (SurfaceRuleManager.RuleStage)SurfaceRuleManager.RuleStage.BEFORE_BEDROCK, (int)0, (SurfaceRules.RuleSource)SurfaceRuleData.makeMinecraftOverWorldRules());
    }
}

