/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.gameevent;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.stream.Streams;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.NaturalSpawnerUtil;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.gameevent.GameEventSpawnerDataModificationEvent;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.gameevent.BloodMoonGameEvent;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.confluence.terraentity.init.entity.TEMonsterEntities;

public final class SlimeRainGameEvent
implements GameEvent {
    public static final ResourceKey<SlimeRainGameEvent> KEY = GameEvent.createKey(Confluence.asResource("slime_rain"));
    public static final SlimeRainGameEvent INSTANCE = new SlimeRainGameEvent();
    public static final String ENTITY_TAG = "spawn_during_slime_rain";
    private static final int _12$00 = LibDateUtils.getDayTime((int)12, (int)0);
    private transient MinecraftServer server;
    private transient ServerLevel level;
    private boolean started;
    private int cooldown;
    private int duration;
    private int killed;
    private boolean spawnedKingSlime;
    private transient boolean forceStart;
    private transient boolean forceEnd;
    private transient boolean haveKingSlime;
    private final transient Set<Entity> spawned = new HashSet<Entity>();
    private transient WeightedRandomList<MobSpawnSettings.SpawnerData> spawnerData = WeightedRandomList.create();

    private SlimeRainGameEvent() {
    }

    @Override
    public void open(MinecraftServer server) {
        this.server = server;
        this.level = OverworldUtils.getLevel(server);
        if (this.duration <= 0 && this.cooldown <= 0) {
            this.cooldown = this.level.getGameTime() < 24000L ? this.level.random.nextIntBetweenInclusive(24, 48) * 1200 : 0;
        }
        this.forceStart = false;
        this.haveKingSlime = false;
        this.spawnerData = ((GameEventSpawnerDataModificationEvent)NeoForge.EVENT_BUS.post((Event)new GameEventSpawnerDataModificationEvent(KEY, this.level, new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.BLUE_SLIME.get(), 200, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.GREEN_SLIME.get(), 300, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.PURPLE_SLIME.get(), 100, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.PINK_SLIME.get(), 1, 1, 1)))).create();
    }

    @Override
    public void close(MinecraftServer server) {
        this.server = null;
        this.level = null;
        for (Entity entity : this.spawned) {
            entity.discard();
        }
        this.spawned.clear();
    }

    @Override
    public void tick() {
        Long2ObjectMap map;
        if (this.duration <= 0) {
            return;
        }
        --this.duration;
        if (this.duration % 20 == 4) {
            this.haveKingSlime = Streams.of((Iterable)this.level.getAllEntities()).anyMatch(entity -> entity.getType() == TEBossEntities.KING_SLIME.get());
        }
        if ((map = NaturalSpawnerUtil.getDimensionChunkSpawnData((ResourceKey)this.level.dimension())) == null) {
            this.forceEnd();
            return;
        }
        GameEventSystem.removeUnTracked(this.spawned, this.level);
        List players = this.level.players();
        if (this.spawned.size() >= (Integer)CommonConfigs.SLIME_RAIN_EVENT_MAX_ENEMIES_BASE.get() + players.size() * (Integer)CommonConfigs.SLIME_RAIN_EVENT_MAX_ENEMIES_PER_PLAYER.get()) {
            return;
        }
        for (ServerPlayer player : players) {
            Vec3 position = player.position();
            double y = position.y + 64.0;
            NaturalSpawnerUtil.ChunkSpawnData data = (NaturalSpawnerUtil.ChunkSpawnData)map.getOrDefault(player.chunkPosition().toLong(), (Object)NaturalSpawnerUtil.ChunkSpawnData.DEFAULT);
            double speed = data.speedMultiplier();
            if (speed <= 0.0) continue;
            int interval = Mth.floor((double)(20.0 * (Double)CommonConfigs.SLIME_RAIN_EVENT_SPAWN_INTERVAL_FACTOR.get() / speed));
            if (this.haveKingSlime) {
                interval *= 5;
            }
            if (this.level.random.nextInt(interval) != 0) continue;
            int tryTimes = data.getCount(((Integer)CommonConfigs.SLIME_RAIN_EVENT_SPAWN_GROUP_SIZE.get()).intValue());
            for (int i = 0; i < tryTimes; ++i) {
                Optional random = this.spawnerData.getRandom(this.level.random);
                if (random.isEmpty()) continue;
                MobSpawnSettings.SpawnerData spawnerData = (MobSpawnSettings.SpawnerData)random.get();
                int count = this.level.random.nextIntBetweenInclusive(spawnerData.minCount, spawnerData.maxCount);
                for (int j = 0; j < count; ++j) {
                    Entity entity2;
                    double x = Mth.nextDouble((RandomSource)this.level.random, (double)(position.x - 32.0), (double)(position.x + 32.0));
                    double z = Mth.nextDouble((RandomSource)this.level.random, (double)(position.z - 32.0), (double)(position.z + 32.0));
                    int cx = SectionPos.blockToSectionCoord((double)x);
                    int cz = SectionPos.blockToSectionCoord((double)z);
                    if (LibUtils.getChunkIfLoaded((ServerChunkCache)this.level.getChunkSource(), (int)cx, (int)cz) == null || (entity2 = spawnerData.type.spawn(this.level, BlockPos.containing((double)x, (double)y, (double)z), MobSpawnType.EVENT)) == null) continue;
                    entity2.addTag(ENTITY_TAG);
                    this.spawned.add(entity2);
                    if (!(entity2 instanceof Mob)) continue;
                    Mob mob = (Mob)entity2;
                    if (!player.canBeSeenAsEnemy()) continue;
                    mob.setTarget((LivingEntity)player);
                }
            }
        }
    }

    @Override
    public void countKilled(LivingEntity living) {
        if (this.started && living.getTags().contains(ENTITY_TAG)) {
            ++this.killed;
            if (this.haveKingSlime) {
                return;
            }
            int count = (Integer)CommonConfigs.SLIME_RAIN_EVENT_KING_SLIME_SPAWN_REQUIRED_KILL_COUNT.get();
            if (this.spawnedKingSlime) {
                count = count * 3 / 2;
            }
            if (KillBoard.INSTANCE.isDefeated((EntityType)TEBossEntities.KING_SLIME.get())) {
                count /= 2;
            }
            if (this.killed >= count) {
                ServerPlayer player = (ServerPlayer)Util.getRandom((List)this.level.players(), (RandomSource)this.level.random);
                ((EntityType)TEBossEntities.KING_SLIME.get()).create(this.level, entity -> {
                    this.killed = 0;
                    this.spawnedKingSlime = true;
                    entity.addTag(ENTITY_TAG);
                    this.level.addFreshEntityWithPassengers((Entity)entity);
                }, BlockPos.containing((double)(player.getX() + (double)Mth.randomBetweenInclusive((RandomSource)this.level.random, (int)-50, (int)50)), (double)player.getY(), (double)(player.getZ() + (double)Mth.randomBetweenInclusive((RandomSource)this.level.random, (int)-50, (int)50))), MobSpawnType.EVENT, true, false);
            }
        }
    }

    @Override
    public boolean canStart() {
        if (this.forceStart) {
            return true;
        }
        int invChance = 0;
        if (LibDateUtils.isWithinDayTime((int)LibDateUtils._04$30, (int)_12$00, (Level)this.level) && !this.level.isRaining() && !BloodMoonGameEvent.INSTANCE.started()) {
            for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
                boolean expert = LibUtils.isAtLeastExpert((Level)this.level, (BlockPos)player.blockPosition());
                if (player.getMaxHealth() >= (float)((Integer)CommonConfigs.SLIME_RAIN_EVENT_REQUIRED_PLAYER_MAX_HEALTH.get()).intValue() && player.getArmorValue() >= (Integer)CommonConfigs.SLIME_RAIN_EVENT_REQUIRED_PLAYER_ARMOR.get()) {
                    invChance = (Integer)CommonConfigs.SLIME_RAIN_EVENT_FREQUENCY.get();
                    break;
                }
                if (!expert) continue;
                invChance = (Integer)CommonConfigs.SLIME_RAIN_EVENT_FREQUENCY.get() * 5;
                break;
            }
        }
        if (invChance > 0) {
            if (KillBoard.INSTANCE.isDefeated((EntityType)TEBossEntities.KING_SLIME.get())) {
                invChance *= 2;
            }
            if (KillBoard.INSTANCE.getGamePhase().isHardmode()) {
                invChance = invChance * 3 / 2;
            }
            return this.level.random.nextInt(invChance) == 0;
        }
        return false;
    }

    @Override
    public boolean canEnd() {
        if (this.forceEnd) {
            return true;
        }
        return this.duration <= 0;
    }

    @Override
    public void onStart() {
        this.started = true;
        this.forceStart = false;
        this.killed = 0;
        this.duration = this.server.isDedicatedServer() ? 18000 : this.level.random.nextIntBetweenInclusive(9, 15) * 1200;
        MutableComponent component = Component.translatable((String)"message.confluence.slime_rain.start").withColor(GlobalColors.MESSAGE.get());
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            player.sendSystemMessage((Component)component);
        }
        this.haveKingSlime = false;
    }

    @Override
    public void onEnd() {
        this.started = false;
        this.forceEnd = false;
        this.duration = 0;
        this.cooldown = this.server.isDedicatedServer() ? 0 : this.level.random.nextIntBetweenInclusive(84, 180) * 1200;
        MutableComponent component = Component.translatable((String)"message.confluence.slime_rain.end").withColor(GlobalColors.MESSAGE.get());
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            player.sendSystemMessage((Component)component);
        }
        this.spawned.clear();
    }

    @Override
    public boolean started() {
        return this.started;
    }

    @Override
    public boolean forceStart() {
        if (this.started) {
            return false;
        }
        this.cooldown = 0;
        this.forceStart = true;
        this.spawnedKingSlime = false;
        return true;
    }

    @Override
    public void forceEnd() {
        if (this.started) {
            this.forceEnd = true;
        }
    }

    @Override
    public void decode(CompoundTag tag) {
        this.started = tag.getBoolean("Started");
        this.cooldown = tag.getInt("Cooldown");
        this.duration = tag.getInt("Duration");
        this.killed = tag.getInt("Killed");
        this.spawnedKingSlime = tag.getBoolean("SpawnedKingSlime");
    }

    @Override
    public void encode(CompoundTag tag) {
        tag.putBoolean("Started", this.started);
        tag.putInt("Cooldown", this.cooldown);
        tag.putInt("Duration", this.duration);
        tag.putInt("Killed", this.killed);
        tag.putBoolean("SpawnedKingSlime", this.spawnedKingSlime);
    }

    public ResourceKey<SlimeRainGameEvent> key() {
        return KEY;
    }
}

