/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.gameevent;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.NaturalSpawnerUtil;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terraentity.entity.animal.SimpleVariantAnimal;
import org.confluence.terraentity.init.entity.TEAnimals;

public final class MeteorShowerGameEvent
implements GameEvent {
    public static final ResourceKey<MeteorShowerGameEvent> KEY = GameEvent.createKey(Confluence.asResource("meteor_shower"));
    public static final MeteorShowerGameEvent INSTANCE = new MeteorShowerGameEvent();
    public static final String ENTITY_TAG = "spawn_during_meteor_shower";
    private transient boolean isCelebrationMK10;
    private transient ServerLevel level;
    private transient boolean forceStart;
    private transient boolean forceEnd;
    private final transient Set<Entity> spawned = new HashSet<Entity>();
    private boolean started;

    private MeteorShowerGameEvent() {
    }

    @Override
    public void open(MinecraftServer server) {
        this.isCelebrationMK10 = ModSecretSeeds.CELEBRATIONMK10.match(server);
        this.level = OverworldUtils.getLevel(server);
    }

    @Override
    public void close(MinecraftServer server) {
        this.level = null;
        for (Entity entity : this.spawned) {
            entity.discard();
        }
        this.spawned.clear();
    }

    @Override
    public void tick() {
        if (!this.started) {
            return;
        }
        Long2ObjectMap map = NaturalSpawnerUtil.getDimensionChunkSpawnData((ResourceKey)this.level.dimension());
        if (map == null) {
            this.forceEnd();
            return;
        }
        GameEventSystem.removeUnTracked(this.spawned, this.level);
        List players = this.level.players();
        if (this.spawned.size() >= (Integer)CommonConfigs.METEOR_SHOWER_EVENT_MAX_ENCHANTED_NIGHTCRAWLERS_BASE.get() + players.size() * (Integer)CommonConfigs.METEOR_SHOWER_EVENT_MAX_ENCHANTED_NIGHTCRAWLERS_PER_PLAYER.get()) {
            return;
        }
        for (ServerPlayer player : players) {
            int interval;
            NaturalSpawnerUtil.ChunkSpawnData data = (NaturalSpawnerUtil.ChunkSpawnData)map.getOrDefault(player.chunkPosition().toLong(), (Object)NaturalSpawnerUtil.ChunkSpawnData.DEFAULT);
            double speed = data.speedMultiplier();
            if (speed <= 0.0 || this.level.random.nextInt(interval = Mth.floor((double)((double)(20 * (Integer)CommonConfigs.METEOR_SHOWER_EVENT_SPAWN_ENCHANTED_NIGHTCRAWLERS_INTERVAL_FACTOR.get()) / speed))) != 0) continue;
            Vec3 position = player.position();
            int count = data.getCount(1);
            for (int j = 0; j < count; ++j) {
                BlockPos pos;
                EntityType type;
                SimpleVariantAnimal worm;
                double x = Mth.nextDouble((RandomSource)this.level.random, (double)(position.x - 32.0), (double)(position.x + 32.0));
                double z = Mth.nextDouble((RandomSource)this.level.random, (double)(position.z - 32.0), (double)(position.z + 32.0));
                int cx = SectionPos.blockToSectionCoord((double)x);
                int cz = SectionPos.blockToSectionCoord((double)z);
                if (LibUtils.getChunkIfLoaded((ServerChunkCache)this.level.getChunkSource(), (int)cx, (int)cz) == null || (worm = (SimpleVariantAnimal)(type = (EntityType)TEAnimals.WORM.get()).spawn(this.level, pos = NaturalSpawner.getTopNonCollidingPos((LevelReader)this.level, (EntityType)type, (int)Mth.floor((double)x), (int)Mth.floor((double)z)), MobSpawnType.EVENT)) == null) continue;
                worm.setVariant(Integer.valueOf(0));
                worm.addTag(ENTITY_TAG);
                this.spawned.add((Entity)worm);
            }
        }
    }

    @Override
    public boolean canStart() {
        if (this.forceStart) {
            return true;
        }
        return LibDateUtils.getDayTime((Level)this.level) == LibDateUtils._19$30 && this.level.random.nextInt((this.isCelebrationMK10 ? (Integer)CommonConfigs.METEOR_SHOWER_EVENT_CELEBRATIONMK10_FREQUENCY.get() : (Integer)CommonConfigs.METEOR_SHOWER_EVENT_FREQUENCY.get()).intValue()) == 0;
    }

    @Override
    public boolean canEnd() {
        if (this.forceEnd) {
            return true;
        }
        return LibDateUtils.isWithinDayTime((int)LibDateUtils._04$30, (int)LibDateUtils._19$30, (Level)this.level);
    }

    @Override
    public void onStart() {
        this.forceStart = false;
        this.started = true;
    }

    @Override
    public void onEnd() {
        this.forceEnd = false;
        this.started = false;
        this.spawned.clear();
    }

    @Override
    public boolean started() {
        return this.started;
    }

    @Override
    public boolean forceStart() {
        if (LibDateUtils.isWithinDayTime((int)LibDateUtils._19$30, (int)LibDateUtils._04$30, (Level)this.level)) {
            this.forceStart = true;
            return true;
        }
        return false;
    }

    @Override
    public void forceEnd() {
        if (this.started) {
            this.forceEnd = true;
        }
    }

    @Override
    public void decode(CompoundTag tag) {
        this.started = tag.getBoolean("Started");
    }

    @Override
    public void encode(CompoundTag tag) {
        tag.putBoolean("Started", this.started);
    }

    public ResourceKey<MeteorShowerGameEvent> key() {
        return KEY;
    }

    @Override
    public boolean isNonEnvEvent() {
        return false;
    }
}

