/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.gameevent;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.gameevent.GameEventSpawnerDataModificationEvent;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.data.saved.ConfluenceData;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.common.gameevent.LanternNightGameEvent;
import org.confluence.mod.network.s2c.GoblinArmyProgressPacketS2C;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terraentity.init.entity.TEMonsterEntities;

public final class GoblinArmyGameEvent
implements GameEvent {
    public static final ResourceKey<GoblinArmyGameEvent> KEY = GameEvent.createKey(Confluence.asResource("goblin_army"));
    public static final GoblinArmyGameEvent INSTANCE = new GoblinArmyGameEvent();
    public static final String ENTITY_TAG = "spawn_during_goblin_army";
    private transient MinecraftServer server;
    private transient ServerLevel level;
    private transient boolean forceStart;
    private transient boolean forceEnd;
    private final transient Set<Entity> spawned = new HashSet<Entity>();
    private transient WeightedRandomList<MobSpawnSettings.SpawnerData> spawnerData = WeightedRandomList.create();
    private boolean started;
    private int ready;
    private int killed;
    private int required;
    private transient float progressO;

    private GoblinArmyGameEvent() {
    }

    @Override
    public void open(MinecraftServer server) {
        this.server = server;
        this.level = OverworldUtils.getLevel(server);
        this.spawnerData = ((GameEventSpawnerDataModificationEvent)NeoForge.EVENT_BUS.post((Event)new GameEventSpawnerDataModificationEvent(KEY, this.level, new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.GOBLIN_ARCHER.get(), 360, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.GOBLIN_PEON.get(), 480, 2, 3), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.GOBLIN_WARRIOR.get(), 360, 2, 3), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.GOBLIN_SORCERER.get(), 240, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.GOBLIN_THIEF.get(), 480, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.ANGER_GOBLIN.get(), 240, 1, 2)))).create();
    }

    @Override
    public void close(MinecraftServer server) {
        this.server = null;
        this.level = null;
        for (Entity entity : this.spawned) {
            entity.discard();
        }
        this.spawned.clear();
    }

    @Override
    public void tick() {
        if (!this.started) {
            return;
        }
        if (this.ready > 0) {
            --this.ready;
        } else if (this.ready != -1) {
            this.ready = -1;
            MutableComponent component = Component.translatable((String)"message.confluence.goblin_army.start").withColor(GlobalColors.EVENT.get());
            for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
                player.sendSystemMessage((Component)component);
            }
        } else {
            GameEventSystem.customSpawner(this, this.level, this.spawned, (Integer)CommonConfigs.GOBLIN_ARMY_EVENT_MAX_ENEMIES_BASE.get(), (Integer)CommonConfigs.GOBLIN_ARMY_EVENT_MAX_ENEMIES_PER_PLAYER.get(), ((Double)CommonConfigs.GOBLIN_ARMY_EVENT_SPAWN_ENEMIES_INTERVAL_FACTOR.get()).floatValue(), this.spawnerData, ENTITY_TAG, true);
        }
    }

    @Override
    public void countKilled(LivingEntity living) {
        if (this.started && living.getTags().contains(ENTITY_TAG)) {
            ++this.killed;
            float progress = (float)this.killed / (float)this.required;
            if (progress - this.progressO > 0.01f) {
                this.progressO = progress;
                GoblinArmyProgressPacketS2C.sendToAll(progress);
            }
        }
    }

    public void syncProgress() {
        if (this.started) {
            GoblinArmyProgressPacketS2C.sendToAll(this.progressO);
        }
    }

    @Override
    public boolean canStart() {
        if (this.forceStart) {
            return true;
        }
        if (LibDateUtils.getDayTime((Level)this.level) == LibDateUtils._04$30 && !LanternNightGameEvent.INSTANCE.started() && !GameEventSystem.anyInvasionStarted() && ConfluenceData.get(this.level).getEvilBrokenCount() > 0) {
            for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
                if (!(player.getMaxHealth() >= (float)((Integer)CommonConfigs.GOBLIN_ARMY_EVENT_REQUIRED_PLAYER_MAX_HEALTH.get()).intValue()) || player.getArmorValue() < (Integer)CommonConfigs.GOBLIN_ARMY_EVENT_REQUIRED_PLAYER_ARMOR.get()) continue;
                boolean hardmode = KillBoard.INSTANCE.getGamePhase().isHardmode();
                int chance = KillBoard.INSTANCE.isDefeated(KEY) ? (hardmode ? ((Integer)CommonConfigs.GOBLIN_ARMY_EVENT_HARDMODE_DEFEATED_INVERT_CHANCE.get()).intValue() : ((Integer)CommonConfigs.GOBLIN_ARMY_EVENT_DEFEATED_INVERT_CHANCE.get()).intValue()) : (hardmode ? ((Integer)CommonConfigs.GOBLIN_ARMY_EVENT_HARDMODE_INVERT_CHANCE.get()).intValue() : ((Integer)CommonConfigs.GOBLIN_ARMY_EVENT_INVERT_CHANCE.get()).intValue());
                return this.level.random.nextInt(chance) == 0;
            }
        }
        return false;
    }

    @Override
    public boolean canEnd() {
        if (this.forceEnd) {
            return true;
        }
        return this.killed >= this.required;
    }

    @Override
    public void onStart() {
        this.started = true;
        this.forceStart = false;
        this.ready = 1060;
        int count = 0;
        MutableComponent component = Component.translatable((String)"message.confluence.goblin_army.ready").withColor(GlobalColors.EVENT.get());
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            player.sendSystemMessage((Component)component);
            if (!(player.getMaxHealth() >= (float)((Integer)CommonConfigs.GOBLIN_ARMY_EVENT_REQUIRED_PLAYER_MAX_HEALTH.get()).intValue())) continue;
            ++count;
        }
        this.required = (Integer)CommonConfigs.GOBLIN_ARMY_EVENT_REQUIRED_KILL_COUNT_BASE.get() + Math.min(count, 255) * (Integer)CommonConfigs.GOBLIN_ARMY_EVENT_REQUIRED_KILL_COUNT_PER_PLAYER.get();
    }

    @Override
    public void onEnd() {
        this.started = false;
        this.forceStart = false;
        this.killed = 0;
        MutableComponent component = Component.translatable((String)"message.confluence.goblin_army.victory").withColor(GlobalColors.EVENT.get());
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            player.sendSystemMessage((Component)component);
            AchievementUtils.awardAchievement(player, "goblin_punter");
        }
        this.spawned.clear();
    }

    @Override
    public boolean started() {
        return this.started;
    }

    @Override
    public boolean forceStart() {
        if (this.started) {
            return false;
        }
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            if (!(player.getMaxHealth() >= (float)((Integer)CommonConfigs.GOBLIN_ARMY_EVENT_REQUIRED_PLAYER_MAX_HEALTH.get()).intValue())) continue;
            this.forceStart = true;
            return true;
        }
        return false;
    }

    @Override
    public void forceEnd() {
        if (this.started) {
            this.forceEnd = true;
        }
    }

    @Override
    public void decode(CompoundTag tag) {
        this.started = tag.getBoolean("Started");
        this.ready = tag.getInt("Ready");
        this.killed = tag.getInt("Killed");
        this.required = tag.getInt("Required");
    }

    @Override
    public void encode(CompoundTag tag) {
        tag.putBoolean("Started", this.started);
        tag.putInt("Ready", this.ready);
        tag.putInt("Killed", this.killed);
        tag.putInt("Required", this.required);
    }

    public ResourceKey<GoblinArmyGameEvent> key() {
        return KEY;
    }
}

