/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.gameevent;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.LivingEntity;
import org.confluence.mod.Confluence;

public interface GameEvent {
    public static final ResourceKey<Registry<GameEvent>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Confluence.asResource("game_event"));
    public static final Codec<ResourceKey<? extends GameEvent>> KEY_CODEC = ResourceKey.codec(REGISTRY_KEY);
    public static final StreamCodec<ByteBuf, ResourceKey<? extends GameEvent>> KEY_STREAM_CODEC = ResourceKey.streamCodec(REGISTRY_KEY);

    public static <E extends GameEvent> ResourceKey<E> createKey(ResourceLocation key) {
        return ResourceKey.create(REGISTRY_KEY, (ResourceLocation)key);
    }

    public void open(MinecraftServer var1);

    public void close(MinecraftServer var1);

    public void tick();

    default public void countKilled(LivingEntity living) {
    }

    public boolean canStart();

    public boolean canEnd();

    public void onStart();

    public void onEnd();

    public boolean started();

    public boolean forceStart();

    public void forceEnd();

    public void decode(CompoundTag var1);

    public void encode(CompoundTag var1);

    public ResourceKey<? extends GameEvent> key();

    default public boolean isNonEnvEvent() {
        return true;
    }
}

