/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.gameevent;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.gameevent.GameEventSpawnerDataModificationEvent;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.data.saved.BossDelaySpawner;
import org.confluence.mod.common.data.saved.MoonPhase;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.confluence.terraentity.init.entity.TEMonsterEntities;

public final class BloodMoonGameEvent
implements GameEvent {
    public static final ResourceKey<BloodMoonGameEvent> KEY = GameEvent.createKey(Confluence.asResource("blood_moon"));
    public static final BloodMoonGameEvent INSTANCE = new BloodMoonGameEvent();
    public static final String ENTITY_TAG = "spawn_during_blood_moon";
    private transient MinecraftServer server;
    private transient ServerLevel level;
    private transient boolean forceStart;
    private transient boolean forceEnd;
    private final transient Set<Entity> spawned = new HashSet<Entity>();
    private transient WeightedRandomList<MobSpawnSettings.SpawnerData> spawnerData = WeightedRandomList.create();
    private boolean started;

    private BloodMoonGameEvent() {
    }

    @Override
    public void open(MinecraftServer server) {
        this.server = server;
        this.level = OverworldUtils.getLevel(server);
        this.spawnerData = ((GameEventSpawnerDataModificationEvent)NeoForge.EVENT_BUS.post((Event)new GameEventSpawnerDataModificationEvent(KEY, this.level, new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.DRIPPLER.get(), 150, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TEMonsterEntities.BLOOD_ZOMBIE.get(), 420, 1, 1)))).create();
    }

    @Override
    public void close(MinecraftServer server) {
        this.server = null;
        this.level = null;
        for (Entity entity : this.spawned) {
            entity.discard();
        }
        this.spawned.clear();
    }

    @Override
    public void tick() {
        if (!this.started) {
            return;
        }
        GameEventSystem.customSpawner(this, this.level, this.spawned, (Integer)CommonConfigs.BLOOD_MOON_EVENT_MAX_ENEMIES_BASE.get(), (Integer)CommonConfigs.BLOOD_MOON_EVENT_MAX_ENEMIES_PER_PLAYER.get(), ((Double)CommonConfigs.BLOOD_MOON_EVENT_SPAWN_ENEMIES_INTERVAL_FACTOR.get()).floatValue(), this.spawnerData, ENTITY_TAG, true);
    }

    @Override
    public boolean canStart() {
        if (this.forceStart) {
            return true;
        }
        if (LibDateUtils.getDayTime((Level)this.level) == LibDateUtils._19$30 && !MoonPhase.NEW_MOON.match((Level)this.level) && BossDelaySpawner.INSTANCE.hasSameTypeInQueue((EntityType)TEBossEntities.EYE_OF_CTHULHU.get())) {
            for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
                if (!(player.getMaxHealth() >= (float)((Integer)CommonConfigs.BLOOD_MOON_EVENT_REQUIRED_PLAYER_MAX_HEALTH.get()).intValue()) || player.getArmorValue() < (Integer)CommonConfigs.BLOOD_MOON_EVENT_REQUIRED_PLAYER_ARMOR.get() || this.level.random.nextInt(((Integer)CommonConfigs.BLOOD_MOON_EVENT_INVERT_CHANCE.get()).intValue()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canEnd() {
        if (this.forceEnd) {
            return true;
        }
        return LibDateUtils.isWithinDayTime((int)LibDateUtils._04$30, (int)LibDateUtils._19$30, (Level)this.level);
    }

    @Override
    public void onStart() {
        this.started = true;
        this.forceStart = false;
        MutableComponent component = Component.translatable((String)"message.confluence.blood_moon.start").withColor(GlobalColors.MESSAGE.get());
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            player.sendSystemMessage((Component)component);
        }
    }

    @Override
    public void onEnd() {
        this.started = false;
        this.forceEnd = false;
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            AchievementUtils.awardAchievement(player, "bloodbath");
        }
        this.spawned.clear();
    }

    @Override
    public boolean started() {
        return this.started;
    }

    @Override
    public boolean forceStart() {
        if (this.started) {
            return false;
        }
        if (LibDateUtils.isWithinDayTime((int)LibDateUtils._19$30, (int)LibDateUtils._04$30, (Level)this.level)) {
            this.forceStart = true;
            return true;
        }
        return false;
    }

    @Override
    public void forceEnd() {
        if (this.started) {
            this.forceEnd = true;
        }
    }

    @Override
    public void decode(CompoundTag tag) {
        this.started = tag.getBoolean("Started");
    }

    @Override
    public void encode(CompoundTag tag) {
        tag.putBoolean("Started", this.started);
    }

    public ResourceKey<BloodMoonGameEvent> key() {
        return KEY;
    }
}

