/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.event.game.entity;

import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.confluence.lib.common.item.ColoredItem;
import org.confluence.mod.api.event.CustomMimicSummonKeyEvent;
import org.confluence.mod.api.event.MinecartAbilityEvent;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ChunkDropletsData;
import org.confluence.mod.common.attachment.EverBeneficial;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.block.functional.crafting.AltarBlock;
import org.confluence.mod.common.data.AchievementOffsetLoader;
import org.confluence.mod.common.data.map.DiggingPower;
import org.confluence.mod.common.data.saved.HardmodeConvertor;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.common.entity.TreasureBagItemEntity;
import org.confluence.mod.common.gameevent.BloodMoonGameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.ModTiers;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.PotionItems;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.item.axe.LucyTheAxe;
import org.confluence.mod.common.item.common.CoinItem;
import org.confluence.mod.common.item.common.DungeonCompass;
import org.confluence.mod.common.item.common.EverBeneficialItem;
import org.confluence.mod.common.item.common.StaffOfRegrowth;
import org.confluence.mod.common.menu.FletchingTableMenu;
import org.confluence.mod.common.worldgen.secret_seed.BoulderWorld;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.mixed.IServerPlayer;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terra_curio.util.TCUtils;
import org.confluence.terraentity.entity.monster.WoodenMimic;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.init.entity.TEMonsterEntities;

@EventBusSubscriber(modid="confluence")
public final class PlayerEvents {
    @SubscribeEvent
    public static void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        PlayerUtils.syncSavedData(player);
        BoulderWorld.forceSetAccessory(player);
        if (HardmodeConvertor.INSTANCE.isCompleted()) {
            AchievementUtils.awardAchievement(player, "its_hard");
        }
        if (((Boolean)CommonConfigs.DO_NPC_SPAWNING.get()).booleanValue() && player.level().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            NPCSpawner.INSTANCE.trySpawnGuide(player);
        }
        PlayerUtils.syncSoul2Client(player);
        GameEventSystem.INSTANCE.syncAll(player);
    }

    @SubscribeEvent
    public static void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ChunkDropletsData.of((Level)player.serverLevel()).getLastSync().remove(player.getUUID());
        GameEventSystem.INSTANCE.clearAll(player);
    }

    @SubscribeEvent
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        AltarBlock.onLeftClick(level.getBlockState(pos), level, pos, event.getEntity());
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos blockPos = event.getPos();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (!event.getUseBlock().isTrue() && block instanceof AltarBlock) {
            event.setUseBlock(TriState.TRUE);
        }
        if (player.isCrouching()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (((Boolean)CommonConfigs.RIGHT_CLICK_RIDE_MINECART.get()).booleanValue() && !(itemStack.getItem() instanceof BlockItem) && !itemStack.is(ModTags.Items.MINECART) && block instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)block;
            if (!player.isSpectator() && !player.isPassenger()) {
                AbstractMinecart minecart;
                ExtraInventory extraInventory;
                ItemStack minecartItemStack;
                MinecartAbilityEvent.RightClickRailBlock e;
                player.swing(InteractionHand.MAIN_HAND);
                event.setCanceled(true);
                if (!level.isClientSide && !(e = (MinecartAbilityEvent.RightClickRailBlock)NeoForge.EVENT_BUS.post((Event)new MinecartAbilityEvent.RightClickRailBlock(player, minecartItemStack = (extraInventory = ExtraInventory.of((LivingEntity)player)).getMinecart(false), blockState, railBlock, blockPos))).isCanceled() && (minecart = e.getMinecart()) != null) {
                    extraInventory.setEquipment(2, ItemStack.EMPTY, false);
                    level.addFreshEntity((Entity)minecart);
                    player.startRiding((Entity)minecart, true);
                }
            }
        }
        if (((Boolean)CommonConfigs.FLETCHING_MENU.get()).booleanValue() && blockState.is(Blocks.FLETCHING_TABLE)) {
            if (!level.isClientSide) {
                player.openMenu((MenuProvider)new FletchingTableMenu.Provider(level, blockPos));
            }
            player.swing(InteractionHand.MAIN_HAND);
            event.setCanceled(true);
        }
        if (!level.isClientSide && itemStack.is(ModTags.Items.CROP_FORTUNE)) {
            StaffOfRegrowth.dropAndPlaceOnRightClick(player, itemStack, blockPos);
        }
        DungeonCompass.matches(player, event.getHand(), level, itemStack, blockState, blockPos);
    }

    @SubscribeEvent
    public static void playerInteract$EntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ItemStack stack;
            LivingEntity targetEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof LivingEntity && (targetEntity = (LivingEntity)player).hasEffect(ModEffects.CHOKING) && ModUtils.isWaterBottle(stack = serverPlayer.getMainHandItem())) {
                ItemStack emptyBottle;
                targetEntity.removeEffect(ModEffects.CHOKING);
                ItemStack itemStack = emptyBottle = stack.is(PotionItems.BOTTLED_WATER) ? PotionItems.BOTTLE.toStack() : Items.GLASS_BOTTLE.getDefaultInstance();
                if (!serverPlayer.hasInfiniteMaterials()) {
                    serverPlayer.getInventory().add(emptyBottle);
                    stack.shrink(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void itemEntityPickup$Pre(ItemEntityPickupEvent.Pre event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        ItemEntity itemEntity = event.getItemEntity();
        ItemStack itemStack = itemEntity.getItem();
        if (IServerPlayer.of(player).confluence$isCouldPickupItem()) {
            TreasureBagItemEntity entity;
            Item gel;
            if (((Boolean)CommonConfigs.AUTO_STACK_GELS_COLOR.get()).booleanValue() && itemStack.is(gel = (Item)MaterialItems.GEL.get())) {
                int defaultMaxStackSize = gel.getDefaultMaxStackSize();
                for (ItemStack stack : player.getInventory().items) {
                    if (stack.isEmpty() || !stack.is(gel) || stack.getCount() + itemStack.getCount() > defaultMaxStackSize) continue;
                    ColoredItem.setRGBA((ItemStack)itemStack, (int)ColoredItem.getRGBA((ItemStack)stack));
                    break;
                }
            }
            if (itemEntity instanceof TreasureBagItemEntity && !(entity = (TreasureBagItemEntity)itemEntity).isOwner((Player)player)) {
                event.setCanPickup(TriState.FALSE);
            }
        } else {
            event.setCanPickup(TriState.FALSE);
        }
        if (itemStack.is(ModTags.Items.PROVIDE_MANA)) {
            ManaStorage.of((LivingEntity)player).receiveMana(() -> (float)itemStack.getCount() * 100.0f);
            itemEntity.discard();
            event.setCanPickup(TriState.FALSE);
        } else if (itemStack.is(ModTags.Items.PROVIDE_LIFE)) {
            player.heal((float)itemStack.getCount() * 4.0f);
            itemEntity.discard();
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public static void itemEntityPickup$Post(ItemEntityPickupEvent.Post event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        ItemEntity itemEntity = event.getItemEntity();
        ItemStack itemStack = event.getOriginalStack();
        CoinItem.onPickup(itemStack, itemEntity);
        LucyTheAxe.onPickup(player, itemStack);
    }

    @SubscribeEvent
    public static void itemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (!TCUtils.hasType((LivingEntity)player, AccessoryItems.HIGH$TEST$FISHING$LINE) && player.getRandom().nextFloat() < 0.1429f) {
            player.level().playSound(null, event.getHookEntity().blockPosition(), (SoundEvent)ModSoundEvents.DECOUPLING.get(), SoundSource.AMBIENT);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.isSpectator()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack.is(ModTags.Items.MANA_WEAPON) && player.hasEffect(ModEffects.SILENCED)) {
            event.setCanceled(true);
        } else if (!itemStack.isEmpty() && (player.hasEffect(ModEffects.STONED) || player.hasEffect(ModEffects.FROZEN) || player.hasEffect(ModEffects.CURSED))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AccessoryItems.applyLuckyCoin(serverPlayer, event.getTarget());
        }
        if (player.getMainHandItem().is(ModTags.Items.SPEAR)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void clone(PlayerEvent.Clone event) {
        Player old = event.getOriginal();
        Player neo = event.getEntity();
        for (MobEffectInstance activeEffect : old.getActiveEffects()) {
            neo.forceAddEffect(activeEffect, null);
        }
    }

    @SubscribeEvent
    public static void respawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        EverBeneficial everBeneficial = EverBeneficial.of((LivingEntity)player);
        EverBeneficialItem.LIFE_CRYSTAL.recovery(everBeneficial, eb -> eb.getUsedLifeCrystals() > 0, player);
        EverBeneficialItem.LIFE_FRUITS.recovery(everBeneficial, eb -> eb.getUsedLifeFruits() > 0, player);
        EverBeneficialItem.AEGIS_APPLE.recovery(everBeneficial, EverBeneficial::isAegisAppleUsed, player);
        EverBeneficialItem.AMBROSIA.recovery(everBeneficial, EverBeneficial::isAmbrosiaUsed, player);
        EverBeneficialItem.GALAXY_PEARL.recovery(everBeneficial, EverBeneficial::isGalaxyPearlUsed, player);
        EverBeneficialItem.ARTISAN_LOAF.recovery(everBeneficial, EverBeneficial::isArtisanLoafUsed, player);
        BoulderWorld.forceSetAccessory(player);
        PlayerUtils.flushLocalData(player, player);
        GameEventSystem.INSTANCE.syncAll(player);
    }

    @SubscribeEvent
    public static void harvestCheck(PlayerEvent.HarvestCheck event) {
        ItemStack itemStack = event.getEntity().getMainHandItem();
        if (!itemStack.isEmpty() && itemStack.is(ItemTags.PICKAXES)) {
            event.setCanHarvest(ModTiers.isCorrectToolForDrops(DiggingPower.getPower(itemStack), itemStack, event.getTargetBlock()));
        }
    }

    @SubscribeEvent
    public static void advancementEarn(AdvancementEvent.AdvancementEarnEvent event) {
        AdvancementHolder advancement = event.getAdvancement();
        if (advancement.value().display().map(DisplayInfo::shouldAnnounceChat).orElse(false).booleanValue() && AchievementOffsetLoader.getDisplayOffset().containsKey(advancement.id())) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            player.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"chat.type.advancement.achievement", (Object[])new Object[]{player.getDisplayName(), Advancement.name((AdvancementHolder)advancement)}), false);
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)entity;
            ServerPlayer sendTo = (ServerPlayer)event.getEntity();
            PlayerUtils.flushLocalData(sendTo, target);
        } else {
            entity = event.getTarget();
            if (entity instanceof AbstractTerraNPC) {
                AbstractTerraNPC npc = (AbstractTerraNPC)entity;
                NPCSpawner.INSTANCE.applyBenedictions(npc);
            }
        }
    }

    @SubscribeEvent
    public static void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        PlayerUtils.flushLocalData(player, player);
        GameEventSystem.INSTANCE.syncAll(player);
    }

    @SubscribeEvent
    public static void playerContainer$Close(PlayerContainerEvent.Close event) {
        block13: {
            ChestMenu menu;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            IMinecraftServer server = IMinecraftServer.of(player2.server);
            if (!server.confluence$matchesSecretFlag(4L)) {
                return;
            }
            Level level = player2.level();
            if (level.getDifficulty() == Difficulty.PEACEFUL) {
                return;
            }
            AbstractContainerMenu abstractContainerMenu = event.getContainer();
            if (abstractContainerMenu instanceof ChestMenu && (abstractContainerMenu = (menu = (ChestMenu)abstractContainerMenu).getContainer()) instanceof ChestBlockEntity) {
                ChestBlockEntity blockEntity = (ChestBlockEntity)abstractContainerMenu;
                ItemStack key = null;
                for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
                    ItemStack stack = blockEntity.getItem(i);
                    if (stack.isEmpty()) continue;
                    if (stack.is(ModTags.Items.MIMIC_SUMMON_KEY) && key == null) {
                        key = stack;
                        continue;
                    }
                    break block13;
                }
                if (key != null) {
                    if (key.is(ToolItems.KEY_OF_LIGHT)) {
                        WoodenMimic mimic = (WoodenMimic)((EntityType)TEMonsterEntities.HALLOWED_MIMIC.get()).create(level);
                        if (mimic != null) {
                            CustomMimicSummonKeyEvent.summon(mimic, blockEntity);
                        }
                    } else if (key.is(ToolItems.KEY_OF_NIGHT)) {
                        boolean summonCorruption = server.confluence$matchesSecretFlag(3L) && !server.confluence$equalsSecretFlag(3L) ? server.confluence$matchesSecretFlag(1L) : level.getGameTime() / 24000L % 2L == 0L;
                        WoodenMimic mimic = summonCorruption ? (WoodenMimic)((EntityType)TEMonsterEntities.CORRUPT_MIMIC.get()).create(level) : (WoodenMimic)((EntityType)TEMonsterEntities.CRIMSON_MIMIC.get()).create(level);
                        if (mimic != null) {
                            CustomMimicSummonKeyEvent.summon(mimic, blockEntity);
                        }
                    } else {
                        NeoForge.EVENT_BUS.post((Event)new CustomMimicSummonKeyEvent((Player)player2, key, menu, blockEntity));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void canPlayerSleep(CanPlayerSleepEvent event) {
        if (BloodMoonGameEvent.INSTANCE.started()) {
            event.setProblem(Player.BedSleepingProblem.NOT_SAFE);
        }
    }

    @SubscribeEvent
    public static void canContinueSleeping(CanContinueSleepingEvent event) {
        if (event.mayContinueSleeping() && BloodMoonGameEvent.INSTANCE.started()) {
            event.setContinueSleeping(false);
        }
    }
}

