/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.strip;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.strip.StripedProjectile;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEntities;

public class VilethronProjectile
extends StripedProjectile {
    public VilethronProjectile(EntityType<? extends StripedProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public VilethronProjectile(LivingEntity living) {
        super((EntityType<? extends StripedProjectile>)((EntityType)ModEntities.VILETHRON_PROJECTILE.get()), living);
    }

    public VilethronProjectile(LivingEntity living, Vec3 pos) {
        super((EntityType<? extends StripedProjectile>)((EntityType)ModEntities.VILETHRON_PROJECTILE.get()), living, pos);
    }

    @Override
    protected void onTouchEntity(EntityHitResult result) {
        result.getEntity().hurt(ModDamageTypes.of(this.level(), ModDamageTypes.MAGICAL_PROJECTILE, (Entity)this, this.getOwner()), this.getCalculatedDamage());
    }

    @Override
    protected StripedProjectile createBody(LivingEntity shooter) {
        return new VilethronProjectile(shooter, this.position());
    }

    public int getAlpha() {
        return Mth.clamp((int)(255 - this.tickCount * 255 / this.ticksForBodyRemove), (int)0, (int)255);
    }
}

