/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.mixed.Immunity;

public class RainProjectile
extends AbstractManaProjectile
implements Immunity {
    private int maxPenetrate = 2;

    public RainProjectile(EntityType<? extends RainProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
    }

    public RainProjectile(EntityType<? extends RainProjectile> entityType, LivingEntity living, Vec3 position) {
        this(entityType, living.level());
        this.setOwner((Entity)living);
        this.setPos(position);
    }

    public void setMaxPenetrate(int maxPenetrate) {
        this.maxPenetrate = maxPenetrate;
    }

    public void baseTick() {
        if (this.tickCount > 200) {
            this.discard();
            return;
        }
        super.baseTick();
        Vec3 vec3 = this.getDeltaMovement();
        double offX = this.getX() + vec3.x;
        double offY = this.getY() + vec3.y;
        double offZ = this.getZ() + vec3.z;
        this.setPos(offX, offY, offZ);
        this.setDeltaMovement(vec3.add(0.0, -0.08, 0.0));
    }

    @Override
    protected void doHitCheck() {
        HitResult hitResult = ProjectileUtil.getHitResult((Vec3)this.position(), (Entity)this, this::canHitEntity, (Vec3)this.getDeltaMovement(), (Level)this.level(), (float)0.6f, (ClipContext.Block)ClipContext.Block.COLLIDER);
        this.checkInsideBlocks();
        HitResult.Type hitresult$type = hitResult.getType();
        if (hitresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)hitResult);
        } else if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitResult);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (this.doPenetrateCheck(entity)) {
            this.doHurtAndKnockback(entity, 0.0, 0.0);
            this.doDiscardInMaxPenetrate(this.maxPenetrate);
        }
    }

    @Override
    public Immunity.Type confluence$getImmunityType() {
        return Immunity.Type.STATIC;
    }

    @Override
    public int confluence$getImmunityDuration(DamageSource damageSource) {
        return 3;
    }
}

