/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.mixed.Immunity;
import org.jetbrains.annotations.Nullable;

public class HurtnadoProjectile
extends AbstractManaProjectile
implements Immunity {
    private Entity target;
    public float rotateO = 0.0f;
    public float rotate = 0.0f;

    public HurtnadoProjectile(EntityType<HurtnadoProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
    }

    public HurtnadoProjectile(LivingEntity living) {
        this((EntityType<HurtnadoProjectile>)((EntityType)ModEntities.HURTNADO_PROJECTILE.get()), living.level());
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    public void baseTick() {
        if (this.tickCount > 190) {
            this.discard();
            return;
        }
        super.baseTick();
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3.add(0.0, -this.getGravity(), 0.0));
        Vec3 motion = this.getDeltaMovement();
        if (!vec3.equals((Object)motion)) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
        }
        this.setDeltaMovement(motion.add(0.0, -this.getGravity(), 0.0));
        if (this.level().isClientSide) {
            if (this.rotate > (float)Math.PI * 2) {
                this.rotate -= (float)Math.PI * 2;
            }
            this.rotateO = this.rotate;
            this.rotate += 0.47123894f;
        }
        if (this.target == null || this.target.isRemoved()) {
            this.target = this.getNearestEnemy();
        }
        if (this.target != null) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.96).add(VectorUtils.getVectorA2B((Entity)this, (Entity)this.target).scale(0.05)));
        }
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    protected void doHitCheck() {
        AABB boundingBox = this.getBoundingBox().inflate(1.0);
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)boundingBox.getMinPosition(), (Vec3)boundingBox.getMaxPosition(), (AABB)boundingBox, this::canHitEntity, (float)0.5f);
        if (hitResult == null) {
            return;
        }
        Entity entity = hitResult.getEntity();
        this.doHurtAndKnockback(entity, 0.5, 0.2);
        if (this.doPenetrateCheck(entity)) {
            this.doDiscardInMaxPenetrate(14);
        }
    }

    @Nullable
    private Entity getNearestEnemy() {
        double d0 = -1.0;
        Entity enemy = null;
        for (Entity entity : this.level().getEntities((Entity)this, new AABB(this.blockPosition()).inflate(15.5))) {
            if (!(entity instanceof Enemy)) continue;
            double d1 = entity.distanceToSqr(this.getX(), this.getY(), this.getZ());
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            enemy = entity;
        }
        return enemy;
    }

    @Override
    public Immunity.Type confluence$getImmunityType() {
        return Immunity.Type.STATIC;
    }

    @Override
    public int confluence$getImmunityDuration(DamageSource damageSource) {
        return 8;
    }
}

