/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.entitiy.IAxisZRotate;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;

public class DemonScytheProjectile
extends AbstractManaProjectile
implements IAxisZRotate {
    public final IAxisZRotate.Rotate rotate = new IAxisZRotate.Rotate();

    public DemonScytheProjectile(EntityType<DemonScytheProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
        this.setNoGravity(true);
    }

    public DemonScytheProjectile(LivingEntity living) {
        this((EntityType<DemonScytheProjectile>)((EntityType)ModEntities.DEMON_SCYTHE_PROJECTILE.get()), living.level());
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    public void baseTick() {
        Vec3 vec3;
        super.baseTick();
        if (this.tickCount > 10 && (vec3 = this.getDeltaMovement()).lengthSqr() < 2.18300625) {
            this.setDeltaMovement(vec3.scale(1.1940371819652));
        }
        if (this.level().isClientSide) {
            this.rotateZ(this.rotate, () -> ((DemonScytheProjectile)this).getDeltaMovement(), 0.0, 0.125f);
        }
        vec3 = this.getDeltaMovement();
        double offX = this.getX() + vec3.x;
        double offY = this.getY() + vec3.y;
        double offZ = this.getZ() + vec3.z;
        this.setPos(offX, offY, offZ);
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (this.doPenetrateCheck(entity)) {
            this.doHurtAndKnockback(entity, 0.5, 0.2);
            this.doDiscardInMaxPenetrate(5);
        }
    }
}

