/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.entity.projectile.DamageSettableProjectile;
import org.confluence.mod.common.init.ModDamageTypes;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractManaProjectile
extends DamageSettableProjectile {
    protected boolean localVelocity = false;
    private Set<UUID> penetrateSet;

    public AbstractManaProjectile(EntityType<? extends AbstractManaProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        if (this.getOwner() == null) {
            this.discard();
        } else {
            super.tick();
            this.doHitCheck();
        }
    }

    protected void doHitCheck() {
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        this.checkInsideBlocks();
        HitResult.Type hitresult$type = hitResult.getType();
        if (hitresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)hitResult);
        } else if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitResult);
        }
    }

    @ApiStatus.OverrideOnly
    protected void onHitEntity(EntityHitResult result) {
    }

    protected boolean doHurtAndKnockback(Entity target, double knockbackStrength, double knockbackMotionY) {
        if (target.hurt(this.getDamageSource(), this.getCalculatedDamage())) {
            if (knockbackStrength > 0.0 || knockbackMotionY > 0.0) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)target, (double)knockbackStrength, (double)knockbackMotionY);
            }
            return true;
        }
        return false;
    }

    protected boolean doPenetrateCheck(Entity entity) {
        if (this.penetrateSet == null) {
            this.penetrateSet = new HashSet<UUID>();
        }
        return this.penetrateSet.add(entity.getUUID());
    }

    protected void doDiscardInMaxPenetrate(int max) {
        if (this.penetrateSet == null) {
            this.penetrateSet = new HashSet<UUID>();
        }
        if (this.penetrateSet.size() >= max) {
            this.discard();
        }
    }

    @Override
    public DamageSource getDamageSource() {
        return ModDamageTypes.of(this.level(), ModDamageTypes.MAGICAL_PROJECTILE, (Entity)this, this.getOwner());
    }

    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        float cos = Mth.cos((float)(x * ((float)Math.PI / 180)));
        float f = -Mth.sin((float)(y * ((float)Math.PI / 180))) * cos;
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(y * ((float)Math.PI / 180))) * cos;
        this.shoot(f, f1, f2, velocity, inaccuracy);
        if (this.localVelocity) {
            Vec3 vec3 = shooter.getKnownMovement();
            this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, shooter.onGround() ? 0.0 : vec3.y, vec3.z));
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Age", this.tickCount);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.tickCount = compound.getInt("Age");
    }
}

