/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.entity.projectile.boulder.AbstractBoulderEntity;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class ExplodeBoulderEntity
extends AbstractBoulderEntity {
    public static final BlockState DEFAULT_BLOCK_STATE = ((AbstractBoulderBlock)FunctionalBlocks.EXPLODE_BOULDER.get()).defaultBlockState();
    public final float explosiveRadius;

    public ExplodeBoulderEntity(EntityType<ExplodeBoulderEntity> entityType, Level pLevel) {
        super(entityType, pLevel, DEFAULT_BLOCK_STATE, BoulderEntity.Builder.of());
        this.explosiveRadius = 2.85f;
    }

    public ExplodeBoulderEntity(Level level, Vec3 pos, BlockState blockState) {
        this(level, pos, blockState, BoulderEntity.Builder.of());
    }

    public ExplodeBoulderEntity(Level level, Vec3 pos, BlockState blockState, BoulderEntity.Builder builder) {
        this(level, pos, blockState, 2.85f, builder);
    }

    public ExplodeBoulderEntity(Level level, Vec3 pos, BlockState blockState, float explosiveRadius) {
        this(level, pos, blockState, explosiveRadius, BoulderEntity.Builder.of());
    }

    public ExplodeBoulderEntity(Level level, Vec3 pos, BlockState blockState, float explosiveRadius, BoulderEntity.Builder builder) {
        super((EntityType<? extends AbstractBoulderEntity>)((EntityType)ModEntities.EXPLODE_BOULDER.get()), level, pos, blockState, builder);
        this.explosiveRadius = explosiveRadius;
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        this.explode((HitResult)entityHitResult);
    }

    @Override
    protected void onHorizontalBlockHit(BlockHitResult blockHitResult) {
        super.onHorizontalBlockHit(blockHitResult);
        this.explode((HitResult)blockHitResult);
    }

    @Override
    protected void onVerticalBlockHit(BlockHitResult blockHitResult) {
        super.onVerticalBlockHit(blockHitResult);
        if (this.getLandingCount() <= 0) {
            this.explode((HitResult)blockHitResult);
        }
    }

    protected void explode(HitResult hitResult) {
        if (this.level().isClientSide) {
            return;
        }
        Vec3 vec3 = this.getAdjustMoveVector(hitResult.getLocation(), -1.0);
        this.level().explode((Entity)this, vec3.x, vec3.y, vec3.z, this.explosiveRadius, true, Level.ExplosionInteraction.TNT);
        this.onRemoveBroken(false);
    }

    @Override
    public BlockState getDefaultBlockState() {
        return DEFAULT_BLOCK_STATE;
    }
}

