/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.entity.projectile.boulder.AbstractBoulderEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class BoulderEntity
extends AbstractBoulderEntity {
    public static final BlockState DEFAULT_BLOCK_STATE = ((AbstractBoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).defaultBlockState();

    public BoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level) {
        this(entityType, level, Builder.of());
    }

    public BoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, Builder builder) {
        this(entityType, level, DEFAULT_BLOCK_STATE, builder);
    }

    public BoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, BlockState blockState) {
        this(entityType, level, blockState, Builder.of());
    }

    public BoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, BlockState blockState, Builder builder) {
        super(entityType, level, blockState, builder);
    }

    public BoulderEntity(Level level, Vec3 pos, BlockState blockState) {
        this(level, pos, blockState, Builder.of());
    }

    public BoulderEntity(Level level, Vec3 pos, BlockState blockState, Builder builder) {
        this((EntityType<? extends AbstractBoulderEntity>)((EntityType)ModEntities.BOULDER.get()), level, pos, blockState, builder);
    }

    public BoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, Vec3 pos, BlockState blockState) {
        this(entityType, level, pos, blockState, Builder.of());
    }

    public BoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, Vec3 pos, BlockState blockState, Builder builder) {
        super(entityType, level, pos, blockState, builder);
    }

    @Override
    public BlockState getDefaultBlockState() {
        return DEFAULT_BLOCK_STATE;
    }

    public static class Builder {
        protected float trackingRange = 31.5f;
        protected double speed = 0.7;
        protected double minRemoveSpeed = 0.007;
        protected float sizeRadius = 0.5f;
        protected int landingCount = 3;
        protected BlockState particleBlockState;
        protected ParticleType<BlockParticleOption> particleType = ParticleTypes.BLOCK;
        protected SoundEvent sound = SoundEvents.STONE_BREAK;
        protected SoundSource soundCategory = SoundSource.BLOCKS;
        protected double defaultGravity = 0.08;

        private Builder() {
        }

        public static Builder of() {
            return new Builder();
        }

        public Builder copy(Builder builder) {
            this.trackingRange = builder.trackingRange;
            this.speed = builder.speed;
            this.minRemoveSpeed = builder.minRemoveSpeed;
            this.sizeRadius = builder.sizeRadius;
            this.landingCount = builder.landingCount;
            this.particleBlockState = builder.particleBlockState;
            this.particleType = builder.particleType;
            this.sound = builder.sound;
            this.soundCategory = builder.soundCategory;
            this.defaultGravity = builder.defaultGravity;
            return this;
        }

        public Builder inherit(Builder builder) {
            Builder o = Builder.of();
            if (o.trackingRange != builder.trackingRange) {
                this.trackingRange = builder.trackingRange;
            }
            if (o.speed != builder.speed) {
                this.speed = builder.speed;
            }
            if (o.minRemoveSpeed != builder.minRemoveSpeed) {
                this.minRemoveSpeed = builder.minRemoveSpeed;
            }
            if (o.sizeRadius != builder.sizeRadius) {
                this.sizeRadius = builder.sizeRadius;
            }
            if (o.landingCount != builder.landingCount) {
                this.landingCount = builder.landingCount;
            }
            if (o.particleBlockState != builder.particleBlockState) {
                this.particleBlockState = builder.particleBlockState;
            }
            if (o.particleType != builder.particleType) {
                this.particleType = builder.particleType;
            }
            if (o.sound != builder.sound) {
                this.sound = builder.sound;
            }
            if (o.soundCategory != builder.soundCategory) {
                this.soundCategory = builder.soundCategory;
            }
            if (o.defaultGravity != builder.defaultGravity) {
                this.defaultGravity = builder.defaultGravity;
            }
            return this;
        }

        public Builder trackingRange(float trackingRange) {
            this.trackingRange = trackingRange;
            return this;
        }

        public Builder speed(double speed) {
            this.speed = speed;
            return this;
        }

        public Builder sizeRadius(float sizeRadius) {
            this.sizeRadius = sizeRadius;
            return this;
        }

        public Builder landingCount(int landingCount) {
            this.landingCount = landingCount;
            return this;
        }

        public Builder minRemoveSpeed(double minRemoveSpeed) {
            this.minRemoveSpeed = minRemoveSpeed;
            return this;
        }

        public Builder particle(BlockState blockState) {
            this.particleBlockState = blockState;
            return this;
        }

        public Builder particle(ParticleType<BlockParticleOption> particleType) {
            this.particleType = particleType;
            return this;
        }

        public Builder particle(BlockState blockState, ParticleType<BlockParticleOption> particleType) {
            this.particleBlockState = blockState;
            this.particleType = particleType;
            return this;
        }

        public Builder sound(SoundEvent sound) {
            this.sound = sound;
            return this;
        }

        public Builder sound(SoundSource soundCategory) {
            this.soundCategory = soundCategory;
            return this;
        }

        public Builder sound(SoundEvent sound, SoundSource soundCategory) {
            this.sound = sound;
            this.soundCategory = soundCategory;
            return this;
        }

        public Builder defaultGravity(double defaultGravity) {
            this.defaultGravity = defaultGravity;
            return this;
        }

        public BoulderEntity builder(Level level, Vec3 pos, BlockState blockState) {
            return new BoulderEntity(level, pos, blockState, this);
        }

        public BoulderEntity builder(EntityType<? extends AbstractBoulderEntity> entityType, Level level, Vec3 pos, BlockState blockState) {
            return new BoulderEntity(entityType, level, pos, blockState, this);
        }
    }
}

