/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.bomb;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.bomb.BaseDirtBombEntity;
import org.confluence.mod.common.init.ModEntities;

public class StickyDirtBombEntity
extends BaseDirtBombEntity {
    protected BlockState stickBlock;
    protected BlockPos stickPos;

    public StickyDirtBombEntity(EntityType<StickyDirtBombEntity> type, Level level) {
        super((EntityType<? extends BaseDirtBombEntity>)type, level);
        this.bounceFactor = 0.0;
    }

    public StickyDirtBombEntity(LivingEntity shooter) {
        super((EntityType<? extends BaseDirtBombEntity>)((EntityType)ModEntities.STICKY_DIRT_BOMB.get()), shooter);
        this.bounceFactor = 0.0;
    }

    @Override
    protected void blockHitCallBack(BlockHitResult blockHitResult) {
        super.blockHitCallBack(blockHitResult);
        this.setDeltaMovement(Vec3.ZERO);
        this.setNoGravity(true);
        Vec3 collPos = blockHitResult.getLocation();
        this.moveTo(collPos.x, collPos.y, collPos.z, this.getYRot(), this.getXRot());
        this.stickPos = blockHitResult.getBlockPos();
        this.stickBlock = this.level().getBlockState(this.stickPos);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.stickPos == null || this.stickBlock != this.level().getBlockState(this.stickPos)) {
            this.setNoGravity(false);
            this.stickBlock = null;
        }
    }
}

