/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.bomb;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.bomb.BaseBombEntity;
import org.confluence.mod.common.init.ModEntities;

public class BombFishEntity
extends BaseBombEntity {
    private BlockPos stickBlock = null;

    public BombFishEntity(EntityType<? extends BombFishEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.bounceFactor = 0.0;
    }

    public BombFishEntity(LivingEntity pShooter) {
        super((EntityType<? extends BaseBombEntity>)((EntityType)ModEntities.BOMB_FISH_ENTITY.get()), pShooter);
        this.bounceFactor = 0.0;
    }

    @Override
    protected void blockHitCallBack(BlockHitResult blockHitResult) {
        super.blockHitCallBack(blockHitResult);
        this.setDeltaMovement(Vec3.ZERO);
        this.setNoGravity(true);
        Vec3 collPos = blockHitResult.getLocation();
        this.moveTo(collPos.x, collPos.y, collPos.z, this.getYRot(), this.getXRot());
        this.stickBlock = this.blockPosition();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.stickBlock != this.blockPosition()) {
            this.setNoGravity(false);
            this.stickBlock = null;
        }
    }
}

