/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.entitiy.IAxisZRotate;
import org.confluence.lib.common.entitiy.IBouncy;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.mixed.Immunity;
import org.confluence.mod.util.ModUtils;

public class SuperSpikyBallProjectile
extends Projectile
implements Immunity,
IAxisZRotate,
IBouncy {
    public final IAxisZRotate.Rotate rotate = new IAxisZRotate.Rotate();

    public SuperSpikyBallProjectile(EntityType<SuperSpikyBallProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SuperSpikyBallProjectile(Level level) {
        super((EntityType)ModEntities.SUPER_SPIKY_BALL_PROJECTILE.get(), level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.tickCount > 1200) {
            this.discard();
            return;
        }
        super.tick();
        this.bounce((arg_0, arg_1) -> ((SuperSpikyBallProjectile)this).move(arg_0, arg_1), () -> ((SuperSpikyBallProjectile)this).getDeltaMovement(), arg_0 -> ((SuperSpikyBallProjectile)this).setDeltaMovement(arg_0), this.getDefaultGravity(), 0.99);
        if (this.level().isClientSide) {
            this.rotateZ(this.rotate, () -> ((SuperSpikyBallProjectile)this).getDeltaMovement(), (float)this.getDefaultGravity(), 0.125f);
        } else {
            EntityHitResult entityHitResult;
            Entity entity;
            AABB boundingBox = this.getBoundingBox().inflate(1.0);
            EntityHitResult entityHitResult2 = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)boundingBox.getMinPosition(), (Vec3)boundingBox.getMaxPosition(), (AABB)boundingBox, this::canHitEntity, (float)0.5f);
            if (entityHitResult2 instanceof EntityHitResult && (entity = (entityHitResult = entityHitResult2).getEntity()).hurt(ModDamageTypes.of(this.level(), (ResourceKey<DamageType>)DamageTypes.STING), (float)((Integer)LibUtils.switchByDifficulty((Level)this.level(), (BlockPos)this.blockPosition(), (Object)16, (Object)32, (Object)48)).intValue())) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)0.2, (double)0.04);
            }
        }
    }

    protected void updateRotation() {
        if (this.rotate.different()) {
            super.updateRotation();
        }
    }

    protected boolean canHitEntity(Entity target) {
        return ModUtils.canHitEntity(target, this.getOwner());
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.tickCount = compound.getInt("Age");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Age", this.tickCount);
    }

    @Override
    public Immunity.Type confluence$getImmunityType() {
        return Immunity.Type.STATIC;
    }

    @Override
    public int confluence$getImmunityDuration(DamageSource damageSource) {
        return 15;
    }
}

