/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.minecart;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.entity.minecart.BaseMinecartEntity;

public class GenericMinecartEntity
extends BaseMinecartEntity
implements VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(GenericMinecartEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public GenericMinecartEntity(EntityType<? extends BaseMinecartEntity> entityType, Level level) {
        super(entityType, level);
    }

    public GenericMinecartEntity(Level level, double x, double y, double z, BaseMinecartEntity.Abilities<? extends BaseMinecartEntity> abilities, Variant variant) {
        super(level, x, y, z, abilities);
        this.setVariant(variant);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)0);
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public record Variant(String name, int id) implements StringRepresentable
    {
        public static final List<Variant> VALUES = new ArrayList<Variant>();
        public static final Variant DESERT = Variant.register("desert");
        public static final Variant BEE = Variant.register("bee");
        public static final Variant LADYBUG = Variant.register("ladybug");
        public static final Variant PIGRON = Variant.register("pigron");
        public static final Variant SUNFLOWER = Variant.register("sunflower");
        public static final Variant SHROOM = Variant.register("shroom");
        public static final Variant AMETHYST = Variant.register("amethyst");
        public static final Variant TOPAZ = Variant.register("topaz");
        public static final Variant SAPPHIRE = Variant.register("sapphire");
        public static final Variant JADE = Variant.register("jade");
        public static final Variant RUBY = Variant.register("ruby");
        public static final Variant DIAMOND = Variant.register("diamond");
        public static final Variant AMBER = Variant.register("amber");
        public static final Variant BEETLE = Variant.register("beetle");
        public static final Variant PARTY = Variant.register("party");
        public static final Variant DUTCHMAN = Variant.register("dutchman");
        public static final Variant STEAMPUNK = Variant.register("steampunk");
        public static final Variant COFFIN = Variant.register("coffin");
        public static final Variant FART = Variant.register("fart");
        public static final Variant TERRA_FART = Variant.register("terra_fart");
        public static final Codec<Variant> CODEC = StringRepresentable.fromValues(() -> VALUES.toArray(new Variant[0]));

        public static Variant byId(int id) {
            return VALUES.get(id);
        }

        public String getSerializedName() {
            return this.name;
        }

        private static Variant register(String name) {
            Variant variant = new Variant(name, VALUES.size());
            VALUES.add(variant);
            return variant;
        }
    }
}

