/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.minecart;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.minecart.BaseMinecartEntity;
import org.confluence.mod.common.init.ModTiers;
import org.confluence.mod.util.PlayerUtils;

public class DiggingMolecartEntity
extends BaseMinecartEntity {
    public DiggingMolecartEntity(EntityType<? extends BaseMinecartEntity> entityType, Level level) {
        super(entityType, level);
    }

    public DiggingMolecartEntity(Level level, double x, double y, double z, BaseMinecartEntity.Abilities<? extends DiggingMolecartEntity> abilities) {
        super(level, x, y, z, abilities);
    }

    @Override
    public void moveMinecartOnRail(BlockPos pos) {
        Entity entity;
        super.moveMinecartOnRail(pos);
        Vec3 motion = this.getDeltaMovement();
        if (motion.horizontalDistanceSqr() < 0.1) {
            return;
        }
        if (this.canDigging() && (entity = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)entity;
            this.setYRot((float)(-(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875)));
            Direction facing = Direction.fromYRot((double)this.getYRot());
            BlockPos facingPos = this.blockPosition().relative(facing);
            Tuple<ItemStack, Integer> tuple = PlayerUtils.getMaxDiggingPowerItem(player);
            ItemStack pickaxeItem = (ItemStack)tuple.getA();
            int power = (Integer)tuple.getB();
            if (power > 0 && !pickaxeItem.isEmpty()) {
                this.diggingBlocks(player, facingPos, facing, power, pickaxeItem);
            }
            this.placeRail(player, facingPos, facing);
        }
    }

    @Override
    protected double getUpgradedMaxSpeed() {
        return super.getUpgradedMaxSpeed() * 0.5;
    }

    protected boolean canDigging() {
        return this.getY() <= (double)this.level().getSeaLevel();
    }

    protected void diggingBlocks(Player player, BlockPos facingPos, Direction facing, int power, ItemStack pickaxeItem) {
        BlockPos.betweenClosedStream((AABB)this.getDiggingRange(facingPos, facing)).forEach(blockPos -> {
            BlockState blockState = this.level().getBlockState(blockPos);
            if (!blockState.isAir() && !blockState.is(BlockTags.RAILS) && ModTiers.isCorrectToolForDrops(power, pickaxeItem, blockState)) {
                pickaxeItem.mineBlock(this.level(), blockState, blockPos, player);
                this.level().destroyBlock(blockPos, true, (Entity)player);
            }
        });
    }

    protected AABB getDiggingRange(BlockPos facingPos, Direction facing) {
        Direction right = facing.getClockWise();
        Direction left = facing.getCounterClockWise();
        BlockPos rightBottom = facingPos.relative(right);
        BlockPos leftTop = facingPos.above(2).relative(left);
        return new AABB(rightBottom.getCenter(), leftTop.getCenter());
    }

    protected void placeRail(Player player, BlockPos facingPos, Direction facing) {
        if (this.level().getBlockState(facingPos).canBeReplaced()) {
            player.getInventory().items.stream().filter(itemStack -> itemStack.is(ItemTags.RAILS)).findAny().ifPresent(itemStack -> {
                Item patt0$temp = itemStack.getItem();
                if (patt0$temp instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)patt0$temp;
                    BlockHitResult hitResult = new BlockHitResult(facingPos.getBottomCenter(), facing, facingPos, true);
                    blockItem.place(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, itemStack, hitResult));
                }
            });
        }
    }
}

