/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.init.ModEntities;
import org.jetbrains.annotations.Nullable;

public class TreasureBagItemEntity
extends ItemEntity {
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER = SynchedEntityData.defineId(TreasureBagItemEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public TreasureBagItemEntity(EntityType<TreasureBagItemEntity> entityType, Level level) {
        super(entityType, level);
        this.setGlowingTag(true);
        this.lifespan = 12000;
    }

    public TreasureBagItemEntity(Level level, Vec3 pos, ItemStack itemStack, @Nullable Player player) {
        this((EntityType<TreasureBagItemEntity>)((EntityType)ModEntities.TREASURE_BAG_ITEM_ENTITY.get()), level);
        this.setPos(pos);
        this.setDeltaMovement(level.random.nextDouble() * 0.2 - 0.1, 0.2, level.random.nextDouble() * 0.2 - 0.1);
        this.setItem(itemStack);
        this.lifespan = itemStack.getEntityLifespan(level);
        if (player != null) {
            this.setThrower((Entity)player);
            this.setOwner(player);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_OWNER, Optional.empty());
    }

    public boolean hurt(DamageSource source, float amount) {
        return !source.is(DamageTypeTags.IS_EXPLOSION) && super.hurt(source, amount);
    }

    public void setOwner(@Nullable Player player) {
        this.entityData.set(DATA_OWNER, Optional.ofNullable(player == null ? null : player.getUUID()));
    }

    public boolean isOwner(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        Optional uuid = (Optional)this.entityData.get(DATA_OWNER);
        return uuid.isEmpty() || ((UUID)uuid.get()).equals(player.getUUID());
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    protected boolean isMergable() {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ((Optional)this.entityData.get(DATA_OWNER)).ifPresent(uuid -> compound.putUUID("ActuallyOwner", uuid));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("ActuallyOwner")) {
            this.entityData.set(DATA_OWNER, Optional.of(compound.getUUID("ActuallyOwner")));
        }
    }

    public static void convert(ItemEntity itemEntity) {
        TreasureBagItemEntity entity = new TreasureBagItemEntity(itemEntity.level(), itemEntity.position(), itemEntity.getItem(), null);
        entity.setPickUpDelay(40);
        entity.setDeltaMovement(itemEntity.getDeltaMovement());
        itemEntity.level().addFreshEntity((Entity)entity);
        itemEntity.discard();
    }
}

