/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.init.ModEntities;

public class ThrownPowderEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.defineId(ThrownPowderEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private BlockPos lastPos;
    private ISpreadable.Type type;
    private final Set<BlockPos> coveredPos = new HashSet<BlockPos>();

    public ThrownPowderEntity(EntityType<ThrownPowderEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownPowderEntity(Level level, ISpreadable.Type type) {
        super((EntityType)ModEntities.THROWN_POWDER.get(), level);
        this.type = type;
        this.setSpreadableType(type);
    }

    public void setSpreadableType(ISpreadable.Type type) {
        this.entityData.set(DATA_TYPE, (Object)type.ordinal());
    }

    public ISpreadable.Type getSpreadableType() {
        return ISpreadable.Type.byId((Integer)this.entityData.get(DATA_TYPE));
    }

    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity) {
        float cosX = Mth.cos((float)(x * ((float)Math.PI / 180)));
        float radY = y * ((float)Math.PI / 180);
        float f = -Mth.sin((float)radY) * cosX;
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)radY) * cosX;
        Vec3 vec3 = new Vec3((double)f, (double)f1, (double)f2).normalize().scale((double)velocity);
        this.setDeltaMovement(vec3);
        this.hasImpulse = true;
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        Vec3 vec31 = shooter.getKnownMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec31.x, 0.0, vec31.z));
    }

    public void tick() {
        Vec3 motion = this.getDeltaMovement();
        double x = this.getX() + motion.x;
        double y = this.getY() + motion.y;
        double z = this.getZ() + motion.z;
        float length = (float)motion.length();
        this.moveDist += length;
        if (this.moveDist >= 3.5f || length < 1.0E-5f) {
            this.discard();
        } else {
            this.setPos(x, y, z);
            this.setDeltaMovement(motion.scale(0.96));
            if (!this.level().isClientSide) {
                if (this.lastPos == this.blockPosition()) {
                    return;
                }
                this.lastPos = this.blockPosition();
                for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().offset(-2, -2, -2), (BlockPos)this.blockPosition().offset(2, 2, 2))) {
                    BlockPos pos = blockPos.immutable();
                    if (this.coveredPos.contains(pos) || !this.type.spread(this.level(), pos, true)) continue;
                    this.coveredPos.add(pos);
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_TYPE, (Object)ISpreadable.Type.PURE.ordinal());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.type = ISpreadable.Type.byId(compound.getInt("type"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("type", this.type.ordinal());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide && DATA_TYPE.equals(key)) {
            this.type = this.getSpreadableType();
        }
    }
}

