/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapLike;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.common.data.saved.IGlobalData;
import org.confluence.lib.common.worldgen.structure.SimpleTemplatePiece;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.data.saved.Bestiary;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.common.gameevent.GoblinArmyGameEvent;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.worldgen.structure.DungeonStructure;
import org.confluence.mod.integration.terra_entity.IAbstractTerraNPC;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.mixed.IStructureStart;
import org.confluence.mod.mixed.IWorldOptions;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terra_guns.common.init.TGTags;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.entity.npc.AnglerNPC;
import org.confluence.terraentity.entity.npc.TravelingMerchantNPC;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.confluence.terraentity.init.entity.TENpcEntities;

public final class NPCSpawner
implements IGlobalData {
    public static final NPCSpawner INSTANCE = new NPCSpawner();
    public static final Codec<Map<Region, Object2BooleanMap<EntityType<?>>>> NPC_ALIVE_CODEC = new Codec<Map<Region, Object2BooleanMap<EntityType<?>>>>(){

        public <T> DataResult<Pair<Map<Region, Object2BooleanMap<EntityType<?>>>, T>> decode(DynamicOps<T> ops, T input) {
            HashMap map = new HashMap();
            ((MapLike)ops.getMap(input).getOrThrow()).entries().forEach(pair -> {
                Region region = new Region(new ChunkPos(Long.parseLong((String)ops.getStringValue(pair.getFirst()).getOrThrow())));
                Object2BooleanOpenHashMap map1 = new Object2BooleanOpenHashMap();
                ((MapLike)ops.getMap(pair.getSecond()).getOrThrow()).entries().forEach(arg_0 -> 1.lambda$decode$0(ops, (Object2BooleanMap)map1, arg_0));
                map.put(region, map1);
            });
            return DataResult.success((Object)new Pair(map, input), (Lifecycle)Lifecycle.stable());
        }

        public <T> DataResult<T> encode(Map<Region, Object2BooleanMap<EntityType<?>>> input, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)ops.createMap(input.entrySet().stream().map(entry -> {
                Object string = ops.createString(Long.toString(((Region)entry.getKey()).toLong()));
                Object map = ops.createMap(((Object2BooleanMap)entry.getValue()).object2BooleanEntrySet().stream().map(entry1 -> {
                    Object string1 = ops.createString(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)entry1.getKey())).toString());
                    Object aBoolean = ops.createBoolean(entry1.getBooleanValue());
                    return new Pair(string1, aBoolean);
                }));
                return new Pair(string, map);
            })), (Lifecycle)Lifecycle.stable());
        }

        private static /* synthetic */ void lambda$decode$0(DynamicOps ops, Object2BooleanMap map1, Pair pair1) {
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)((String)ops.getStringValue(pair1.getFirst()).getOrThrow())));
            boolean spawned = (Boolean)ops.getBooleanValue(pair1.getSecond()).getOrThrow();
            map1.put((Object)entityType, spawned);
        }
    };
    public static final Codec<Set<EntityType<?>>> NPC_SPAWNED_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().listOf().xmap(HashSet::new, ArrayList::new);
    private final Map<Region, Object2BooleanMap<EntityType<?>>> npcAlive = new HashMap();
    private final Set<EntityType<?>> npcSpawned = new HashSet();
    private boolean isAdvancedCombatTechniquesUsed = false;
    private boolean isAdvancedCombatTechniquesVolumeTwoUsed = false;
    private boolean isPeddlersSatchelUsed = false;

    private NPCSpawner() {
    }

    public Iterable<EntityType<?>> getNpcSpawned() {
        return this.npcSpawned;
    }

    public void setAdvancedCombatTechniquesUsed(boolean used) {
        this.isAdvancedCombatTechniquesUsed = used;
    }

    public boolean isAdvancedCombatTechniquesUsed() {
        return this.isAdvancedCombatTechniquesUsed;
    }

    public void setAdvancedCombatTechniquesVolumeTwoUsed(boolean used) {
        this.isAdvancedCombatTechniquesVolumeTwoUsed = used;
    }

    public boolean isAdvancedCombatTechniquesVolumeTwoUsed() {
        return this.isAdvancedCombatTechniquesVolumeTwoUsed;
    }

    public void setPeddlersSatchelUsed(boolean used) {
        this.isPeddlersSatchelUsed = used;
    }

    public boolean isPeddlersSatchelUsed() {
        return this.isPeddlersSatchelUsed;
    }

    public int getAliveNpcCount(Region region, Predicate<EntityType<?>> filter) {
        Object2BooleanMap<EntityType<?>> map = this.npcAlive.get(region);
        if (map == null) {
            return 0;
        }
        int count = 0;
        for (Object2BooleanMap.Entry entry : map.object2BooleanEntrySet()) {
            if (!entry.getBooleanValue() || !filter.test((EntityType)entry.getKey())) continue;
            ++count;
        }
        return count;
    }

    public Object2BooleanMap<EntityType<?>> getRegionAliveDetails(Region region) {
        return this.npcAlive.computeIfAbsent(region, region1 -> new Object2BooleanOpenHashMap());
    }

    public boolean hasNPCAlive(Region region, EntityType<?> entityType) {
        Object2BooleanMap<EntityType<?>> map = this.npcAlive.get(region);
        return map != null && map.getOrDefault(entityType, false);
    }

    public void setNPCAlive(Region region, EntityType<?> entityType, boolean alive) {
        if (alive) {
            this.getRegionAliveDetails(region).put(entityType, true);
            this.addSpawned(entityType);
        } else {
            Object2BooleanMap<EntityType<?>> map = this.npcAlive.get(region);
            if (map != null && map.getBoolean(entityType)) {
                map.put(entityType, false);
            }
        }
    }

    public void addSpawned(EntityType<?> entityType) {
        if (entityType != TENpcEntities.TRAVELING_MERCHANT.get() && entityType != TENpcEntities.OLD_MAN.get()) {
            this.npcSpawned.add(entityType);
        }
    }

    public void moveNPCToAnotherRegion(AbstractTerraNPC living, Region from, Region to) {
        IAbstractTerraNPC npc = IAbstractTerraNPC.of(living);
        EntityType entityType = living.getType();
        if (this.hasNPCAlive(from, entityType)) {
            this.setNPCAlive(from, entityType, false);
            this.setNPCAlive(to, entityType, true);
            npc.confluence$setRegion(to);
            this.applyBenedictions(living);
        }
    }

    public void onNPCAdded(AbstractTerraNPC living) {
        IAbstractTerraNPC npc = IAbstractTerraNPC.of(living);
        npc.confluence$setRegion(new Region(living.chunkPosition()));
        this.setNPCAlive(npc.confluence$getRegion(), living.getType(), true);
        this.applyBenedictions(living);
        NPCSpawner.broadcastMessageToRegion(living.level(), living, (Component)Component.translatable((String)"event.confluence.npc.arrived", (Object[])new Object[]{living.getType().getDescription(), living.getName()}).withColor(GlobalColors.NPC_ARRIVED.get()));
    }

    public void applyBenedictions(AbstractTerraNPC living) {
        if (this.isAdvancedCombatTechniquesUsed()) {
            NPCSpawner.applyAdvancedCombatTechniques(living, Confluence.asResource("advanced_combat_techniques"));
        }
        if (this.isAdvancedCombatTechniquesVolumeTwoUsed()) {
            NPCSpawner.applyAdvancedCombatTechniques(living, Confluence.asResource("advanced_combat_techniques_volume_two"));
        }
    }

    public void onNPCRemoved(AbstractTerraNPC living) {
        this.setNPCAlive(IAbstractTerraNPC.of(living).confluence$getRegion(), living.getType(), false);
        if (((Boolean)CommonConfigs.BROADCAST_NPC_MSG.get()).booleanValue() && living.getType() != TENpcEntities.OLD_MAN.get()) {
            MutableComponent message;
            if (living instanceof AnglerNPC) {
                if (living.isLieDown()) {
                    return;
                }
                message = Component.translatable((String)"event.confluence.npc.left", (Object[])new Object[]{living.getName()}).withColor(GlobalColors.NPC_SLAIN.get());
            } else {
                message = living instanceof TravelingMerchantNPC ? Component.translatable((String)"event.confluence.traveling_merchant.departed", (Object[])new Object[]{living.getName()}).withColor(GlobalColors.NPC_ARRIVED.get()) : Component.translatable((String)"event.confluence.npc.slain", (Object[])new Object[]{living.getType().getDescription(), living.getName()}).withColor(GlobalColors.NPC_SLAIN.get());
            }
            NPCSpawner.broadcastMessageToRegion(living.level(), living, (Component)message);
        }
    }

    public void decode(CompoundTag tag) {
        this.npcAlive.clear();
        NPC_ALIVE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("npc_alive")).ifSuccess(this.npcAlive::putAll);
        this.npcSpawned.clear();
        NPC_SPAWNED_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getList("npc_spawned", 8)).ifSuccess(this.npcSpawned::addAll);
        this.isAdvancedCombatTechniquesUsed = tag.getBoolean("advanced_combat_techniques");
        this.isAdvancedCombatTechniquesVolumeTwoUsed = tag.getBoolean("advanced_combat_techniques_volume_two");
        this.isPeddlersSatchelUsed = tag.getBoolean("peddlers_satchel");
    }

    public void encode(CompoundTag tag) {
        Iterator<Map.Entry<Region, Object2BooleanMap<EntityType<?>>>> iterator = this.npcAlive.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Region, Object2BooleanMap<EntityType<?>>> next = iterator.next();
            next.getValue().object2BooleanEntrySet().removeIf(entry -> !entry.getBooleanValue());
            if (!next.getValue().isEmpty()) continue;
            iterator.remove();
        }
        NPC_ALIVE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.npcAlive).ifSuccess(nbt -> tag.put("npc_alive", nbt));
        NPC_SPAWNED_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.npcSpawned).ifSuccess(nbt -> tag.put("npc_spawned", nbt));
        tag.putBoolean("advanced_combat_techniques", this.isAdvancedCombatTechniquesUsed);
        tag.putBoolean("advanced_combat_techniques_volume_two", this.isAdvancedCombatTechniquesVolumeTwoUsed);
        tag.putBoolean("peddlers_satchel", this.isPeddlersSatchelUsed);
    }

    public String serializeKey() {
        return "confluence:npc_spawner";
    }

    public void clear() {
        this.npcAlive.clear();
        this.npcSpawned.clear();
        this.isAdvancedCombatTechniquesUsed = false;
        this.isAdvancedCombatTechniquesVolumeTwoUsed = false;
        this.isPeddlersSatchelUsed = false;
    }

    public void trySpawnGuide(ServerPlayer player) {
        ServerLevel serverLevel = player.serverLevel();
        if (serverLevel.dimension() == OverworldUtils.dimension()) {
            BlockPos pos = NPCSpawner.getNpcSpawnPos(player);
            Region region = new Region(pos);
            if (IMinecraftServer.matchesSecretFlag(player.server, IWorldOptions.DW_MASK)) {
                if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.PARTY_GIRL.get())) {
                    this.spawnAtPos(serverLevel, pos, (EntityType)TENpcEntities.PARTY_GIRL.get());
                }
            } else if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.GUIDE.get())) {
                this.spawnAtPos(serverLevel, pos, (EntityType)TENpcEntities.GUIDE.get());
            }
        }
    }

    public void checkNpcRespawn(ServerLevel serverLevel) {
        if (GameEventSystem.shouldDenyNatureSpawn()) {
            return;
        }
        block0: for (ServerPlayer player : serverLevel.players()) {
            Region region;
            BlockPos pos;
            if (this.trySpawnTravelingMerchant(player, pos = NPCSpawner.getNpcSpawnPos(player), region = new Region(pos)) || this.trySpawnClothier(player, pos, region) || this.trySpawnMechanic(player, pos, region)) continue;
            for (EntityType<?> entityType : this.npcSpawned) {
                if (this.hasNPCAlive(region, entityType) || !this.spawnAtPos(serverLevel, pos, entityType)) continue;
                continue block0;
            }
            if (!this.trySpawnMerchant(player, pos, region) && !this.trySpawnNurse(player, pos, region) && !this.trySpawnDemolitionist(player, pos, region) && !this.trySpawnDyeTrader(player, pos, region) && !this.trySpawnAngler(player, region) && !this.trySpawnZoologist(player, pos, region) && !this.trySpawnDryad(player, pos, region) && !this.trySpawnPainter(player, pos, region) && !this.trySpawnArmsDealer(player, pos, region) && !this.trySpawnGoblinTinkerer(player, pos, region) && !this.trySpawnWitchDoctor(player, pos, region) && !this.trySpawnPartyGirl(player, pos, region)) continue;
        }
    }

    private boolean trySpawnZoologist(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.ZOOLOGIST.get()) && Bestiary.INSTANCE.getEntries().size() >= 34) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.ZOOLOGIST.get());
        }
        return false;
    }

    private boolean trySpawnPartyGirl(ServerPlayer player, BlockPos pos, Region region) {
        if (IMinecraftServer.matchesSecretFlag(player.server, IWorldOptions.DW_MASK)) {
            if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.GUIDE.get())) {
                return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.GUIDE.get());
            }
        } else if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.PARTY_GIRL.get()) && player.getRandom().nextInt(40) == 0 && this.getAliveNpcCount(region, entityType -> true) >= 14) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.PARTY_GIRL.get());
        }
        return false;
    }

    private boolean trySpawnTravelingMerchant(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.TRAVELING_MERCHANT.get()) && LibDateUtils.isWithinDayTime((int)LibDateUtils._04$30, (int)LibDateUtils.getDayTime((int)12, (int)0), (Level)player.level())) {
            int bound = 30000 / (Integer)CommonConfigs.NPC_SPAWN_INTERVAL.get();
            if (player.getRandom().nextInt(bound) == 0 && this.getAliveNpcCount(region, entityType -> entityType != TENpcEntities.OLD_MAN.get()) >= 2) {
                return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.TRAVELING_MERCHANT.get());
            }
        }
        return false;
    }

    private boolean trySpawnMerchant(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.MERCHANT.get()) && PlayerUtils.getMoney((Player)player, true) >= 5000L) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.MERCHANT.get());
        }
        return false;
    }

    private boolean trySpawnNurse(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.NURSE.get()) && player.getMaxHealth() > 20.0f && this.hasNPCAlive(region, (EntityType)TENpcEntities.MERCHANT.get())) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.NURSE.get());
        }
        return false;
    }

    private boolean trySpawnDemolitionist(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.DEMOLITIONIST.get()) && player.getInventory().hasAnyMatching(stack -> stack.is(ModTags.Items.EXPLOSIVE)) && this.hasNPCAlive(region, (EntityType)TENpcEntities.MERCHANT.get())) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.DEMOLITIONIST.get());
        }
        return false;
    }

    private boolean trySpawnDyeTrader(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.DYE_TRADER.get()) && this.hasNPCAlive(region, (EntityType)TENpcEntities.MERCHANT.get()) && player.getInventory().hasAnyMatching(stack -> stack.is(Tags.Items.DYES))) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.DYE_TRADER.get());
        }
        return false;
    }

    private boolean trySpawnAngler(ServerPlayer player, Region region) {
        BlockPos playerPos = player.blockPosition();
        Region playerRegion = new Region(playerPos);
        if (!this.hasNPCAlive(playerRegion, (EntityType)TENpcEntities.ANGLER.get()) && !this.hasNPCAlive(region, (EntityType)TENpcEntities.ANGLER.get())) {
            AbstractTerraNPC npc;
            ServerLevel level = player.serverLevel();
            Pair closestBiome3d = player.serverLevel().findClosestBiome3d(biome -> biome.is(Tags.Biomes.IS_OCEAN), playerPos, 64, 8, 64);
            if (closestBiome3d != null && (npc = (AbstractTerraNPC)((EntityType)TENpcEntities.ANGLER.get()).create((Level)level)) != null) {
                int dx = level.random.nextInt(4) - 2;
                int dz = level.random.nextInt(4) - 2;
                npc.setPos(((BlockPos)closestBiome3d.getFirst()).atY(level.getSeaLevel()).offset(dx, 0, dz).getCenter());
                level.addFreshEntity((Entity)npc);
                IAbstractTerraNPC.of(npc).confluence$setRegion(playerRegion);
                this.getRegionAliveDetails(playerRegion).put((Object)((EntityType)TENpcEntities.ANGLER.get()), true);
                return true;
            }
        }
        return false;
    }

    private boolean trySpawnDryad(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.DRYAD.get()) && KillBoard.INSTANCE.isAnyDefeated((EntityType)TEBossEntities.EYE_OF_CTHULHU.get(), (EntityType)TEBossEntities.EATER_OF_WORLDS.get(), (EntityType)TEBossEntities.BRAIN_OF_CTHULHU.get(), (EntityType)TEBossEntities.SKELETRON.get())) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.DRYAD.get());
        }
        return false;
    }

    private boolean trySpawnWitchDoctor(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.WITCH_DOCTOR.get()) && KillBoard.INSTANCE.isDefeated((EntityType)TEBossEntities.QUEEN_BEE.get())) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.WITCH_DOCTOR.get());
        }
        return false;
    }

    private boolean trySpawnPainter(ServerPlayer player, BlockPos pos, Region region) {
        Object2BooleanMap<EntityType<?>> map = this.npcAlive.get(region);
        if (map != null && !map.getOrDefault(TENpcEntities.PAINTER.get(), false) && map.size() >= 8) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.PAINTER.get());
        }
        return false;
    }

    private boolean trySpawnArmsDealer(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.ARMS_DEALER.get())) {
            Predicate<ItemStack> predicate = stack -> stack.is(TGTags.BULLET) || stack.is(TGTags.GUN);
            if (player.getInventory().hasAnyMatching(predicate) || ExtraInventory.of((LivingEntity)player).hasAnyMatching(predicate)) {
                return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.ARMS_DEALER.get());
            }
        }
        return false;
    }

    private boolean trySpawnGoblinTinkerer(ServerPlayer player, BlockPos pos, Region region) {
        if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.GOBLIN_TINKERER.get()) && KillBoard.INSTANCE.isDefeated(GoblinArmyGameEvent.KEY)) {
            return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.GOBLIN_TINKERER.get());
        }
        return false;
    }

    private boolean trySpawnClothier(ServerPlayer player, BlockPos pos, Region region) {
        if (KillBoard.INSTANCE.getGamePhase().isAtLeast(GamePhase.AFTER_SKELETRON)) {
            if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.CLOTHIER.get())) {
                return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.CLOTHIER.get());
            }
        } else {
            ServerLevel level = player.serverLevel();
            return DungeonStructure.iterateDungeon(level, player.chunkPosition(), structureStart -> {
                if (IStructureStart.of(structureStart).confluence$cachedBoundingBox().isInside((Vec3i)player.blockPosition())) {
                    for (StructurePiece piece : structureStart.getPieces()) {
                        if (!(piece instanceof SimpleTemplatePiece)) continue;
                        SimpleTemplatePiece templatePiece = (SimpleTemplatePiece)piece;
                        if (!DungeonStructure.GATE.equals(templatePiece.templateName)) continue;
                        BlockPos offset = switch (templatePiece.getRotation()) {
                            case Rotation.CLOCKWISE_90 -> templatePiece.templatePosition().offset(-15, 6, 15);
                            case Rotation.CLOCKWISE_180 -> templatePiece.templatePosition().offset(-15, 6, -15);
                            case Rotation.COUNTERCLOCKWISE_90 -> templatePiece.templatePosition().offset(15, 6, -15);
                            default -> templatePiece.templatePosition().offset(15, 6, 15);
                        };
                        Region npcRegion = new Region(offset);
                        if (!this.hasNPCAlive(npcRegion, (EntityType)TENpcEntities.OLD_MAN.get())) {
                            AbstractTerraNPC npc = (AbstractTerraNPC)((EntityType)TENpcEntities.OLD_MAN.get()).create((Level)level);
                            if (npc == null) {
                                return false;
                            }
                            npc.setPos(offset.getBottomCenter());
                            level.addFreshEntity((Entity)npc);
                            IAbstractTerraNPC.of(npc).confluence$setRegion(npcRegion);
                            this.getRegionAliveDetails(npcRegion).put((Object)((EntityType)TENpcEntities.OLD_MAN.get()), true);
                            return true;
                        }
                        return false;
                    }
                }
                return false;
            });
        }
        return false;
    }

    private boolean trySpawnMechanic(ServerPlayer player, BlockPos pos, Region region) {
        if (KillBoard.INSTANCE.isDefeated((EntityType)TEBossEntities.SKELETRON.get()) && this.npcSpawned.contains(TENpcEntities.MECHANIC.get())) {
            if (!this.hasNPCAlive(region, (EntityType)TENpcEntities.MECHANIC.get())) {
                return this.spawnAtPos(player.serverLevel(), pos, (EntityType)TENpcEntities.MECHANIC.get());
            }
        } else {
            ServerLevel level = player.serverLevel();
            return DungeonStructure.iterateDungeon(level, player.chunkPosition(), structureStart -> {
                if (IStructureStart.of(structureStart).confluence$cachedBoundingBox().isInside((Vec3i)player.blockPosition())) {
                    for (StructurePiece piece : structureStart.getPieces()) {
                        if (!(piece instanceof SimpleTemplatePiece)) continue;
                        SimpleTemplatePiece templatePiece = (SimpleTemplatePiece)piece;
                        if (!templatePiece.templateName.endsWith("_dungeon_underground_2_2")) continue;
                        BlockPos offset = templatePiece.templatePosition().offset(46, 6, -11);
                        Region npcRegion = new Region(offset);
                        if (!this.hasNPCAlive(npcRegion, (EntityType)TENpcEntities.MECHANIC.get())) {
                            AbstractTerraNPC npc = (AbstractTerraNPC)((EntityType)TENpcEntities.MECHANIC.get()).create((Level)level);
                            if (npc == null) {
                                return false;
                            }
                            npc.setPos(offset.getBottomCenter());
                            level.addFreshEntity((Entity)npc);
                            IAbstractTerraNPC terraNPC = IAbstractTerraNPC.of(npc);
                            terraNPC.confluence$setRegion(npcRegion);
                            terraNPC.confluence$setShouldInteract(true);
                            this.getRegionAliveDetails(npcRegion).put((Object)((EntityType)TENpcEntities.MECHANIC.get()), true);
                            return true;
                        }
                        return false;
                    }
                }
                return false;
            });
        }
        return false;
    }

    public boolean spawnAtPos(ServerLevel level, BlockPos pos, EntityType<?> entityType) {
        Entity entity = entityType.create((Level)level);
        if (!(entity instanceof AbstractTerraNPC)) {
            return false;
        }
        AbstractTerraNPC living = (AbstractTerraNPC)entity;
        living.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 2.9, (double)pos.getZ() + 0.5);
        level.addFreshEntity((Entity)living);
        if (living instanceof AnglerNPC) {
            AnglerNPC angler = (AnglerNPC)living;
            angler.setWakeUp(true);
        }
        this.onNPCAdded(living);
        return true;
    }

    public static BlockPos getNpcSpawnPos(ServerPlayer player) {
        return player.getRespawnPosition() == null ? player.serverLevel().getSharedSpawnPos() : player.getRespawnPosition();
    }

    public static Region getNpcSpawnRegion(ServerPlayer player) {
        return new Region(NPCSpawner.getNpcSpawnPos(player));
    }

    public static void broadcastMessageToRegion(Level level, AbstractTerraNPC npc, Component message) {
        Region region = ((IAbstractTerraNPC)npc).confluence$getRegion();
        for (Player player : level.players()) {
            if (!region.isOnRegion(player.chunkPosition()) && !(npc.distanceToSqr((Entity)player) < 9216.0)) continue;
            player.sendSystemMessage(message);
        }
    }

    public static void applyAdvancedCombatTechniques(AbstractTerraNPC living, ResourceLocation id) {
        AttributeInstance attackDamage;
        AttributeInstance armor = living.getAttribute(Attributes.ARMOR);
        if (armor != null) {
            armor.addOrReplacePermanentModifier(new AttributeModifier(id, 3.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if ((attackDamage = living.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
            attackDamage.addOrReplacePermanentModifier(new AttributeModifier(id, 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    public static void respawnNPC(ServerLevel level, int dayTime) {
        if (((Boolean)CommonConfigs.DO_NPC_SPAWNING.get()).booleanValue() && LibDateUtils.isDay((int)dayTime) && level.getGameTime() % (long)((Integer)CommonConfigs.NPC_SPAWN_INTERVAL.get()).intValue() == 0L && level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            INSTANCE.checkNpcRespawn(level);
        }
    }

    public record Region(int x, int z) {
        public static final Region ZERO = new Region(BlockPos.ZERO);
        public static final Codec<Region> CODEC = Codec.LONG.xmap(Region::new, Region::toLong);

        public Region(BlockPos pos) {
            this(((pos.getX() >> 4) + 8 >> 4 << 4) - 8, ((pos.getZ() >> 4) + 8 >> 4 << 4) - 8);
        }

        public Region(long packed) {
            this(((int)packed + 8 >> 4 << 4) - 8, ((int)(packed >> 32) + 8 >> 4 << 4) - 8);
        }

        public Region(ChunkPos pos) {
            this((pos.x + 8 >> 4 << 4) - 8, (pos.z + 8 >> 4 << 4) - 8);
        }

        public boolean isOnRegion(BlockPos pos) {
            return this.isOnRegion(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        }

        public boolean isOnRegion(ChunkPos pos) {
            return this.isOnRegion(pos.x, pos.z);
        }

        public boolean isOnRegion(int chunkX, int chunkZ) {
            return chunkX >= this.x && chunkX < this.x + 16 && chunkZ >= this.z && chunkZ < this.z + 16;
        }

        public long toLong() {
            return ChunkPos.asLong((int)this.x, (int)this.z);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            int x1;
            int n;
            if (o == this) {
                return true;
            }
            if (!(o instanceof Region)) return false;
            Region region = (Region)o;
            try {
                x1 = n = region.x();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            int z1 = n = region.z();
            if (x1 != this.x) return false;
            if (z1 != this.z) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return ChunkPos.hash((int)this.x, (int)this.z);
        }

        @Override
        public String toString() {
            return "Region(x=[" + this.x + ", " + (this.x + 15) + "], z=[" + this.z + ", " + (this.z + 15) + "])";
        }
    }
}

