/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.data.saved.ConfluenceData;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.network.s2c.MeteoriteLocationPacketS2C;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.jetbrains.annotations.NotNull;

public final class MeteoriteTracker {
    public static final MeteoriteTracker INSTANCE = new MeteoriteTracker();
    public static final ResourceKey<ConfiguredFeature<?, ?>> METEORITE = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "meteorite");
    private transient boolean shouldGenerate = true;
    public boolean spawnAtNextNight = false;
    @NotNull
    BlockPos location = BlockPos.ZERO;
    int tickUntilLanding = 0;

    private MeteoriteTracker() {
    }

    public void tick(ServerLevel level) {
        if (!((Boolean)CommonConfigs.DO_METEORITE_SPAWNING.get()).booleanValue()) {
            return;
        }
        if (this.spawnAtNextNight && LibDateUtils.getDayTime((Level)level) == LibDateUtils._00$00) {
            this.spawnAtNextNight = false;
            this.generateLandingDetail(level, Mth.randomBetweenInclusive((RandomSource)level.random, (int)200, (int)400));
            MutableComponent message = Component.translatable((String)"event.confluence.meteorite.ready").withColor(GlobalColors.EVENT.get());
            level.getServer().getPlayerList().broadcastSystemMessage((Component)message, false);
        }
        if (this.tickUntilLanding == 0) {
            this.shouldGenerate = true;
        } else if (this.tickUntilLanding > 0) {
            --this.tickUntilLanding;
            if (this.tickUntilLanding == 0) {
                ChunkPos chunkPos = new ChunkPos(this.location);
                this.place(level, chunkPos.x, chunkPos.z, !level.getForcedChunks().contains(chunkPos.toLong()), new BlockPos((Vec3i)this.location));
                ConfluenceData.get(level).setDirty();
            }
        }
    }

    public void generateLandingDetail(ServerLevel level, int landingTime) {
        ChunkHolder chunkHolder;
        if (!this.shouldGenerate || !((Boolean)CommonConfigs.DO_METEORITE_SPAWNING.get()).booleanValue()) {
            return;
        }
        this.shouldGenerate = false;
        int[][] quadrant = new int[][]{{1, 1}, {-1, 1}, {-1, -1}, {1, -1}};
        int[] counts = new int[4];
        for (int i = 0; i < 4; ++i) {
            int x = quadrant[i][0];
            int z = quadrant[i][1];
            for (ServerPlayer player : level.players()) {
                if (Mth.sign((double)player.getX()) != x || Mth.sign((double)player.getZ()) != z) continue;
                int n = i;
                counts[n] = counts[n] + 1;
            }
        }
        int min = 0;
        for (int i = 0; i < 4; ++i) {
            if (counts[i] >= counts[min]) continue;
            min = i;
        }
        int xStep = quadrant[min][0];
        int zStep = quadrant[min][1];
        int x = 0;
        int z = 0;
        ArrayList players = new ArrayList(level.players());
        ChunkMap chunkMap = level.getChunkSource().chunkMap;
        do {
            if (players.isEmpty()) continue;
            Iterator iterator = players.iterator();
            while (iterator.hasNext()) {
                ServerPlayer player = (ServerPlayer)iterator.next();
                int dist = player.requestedViewDistance();
                int cx = SectionPos.blockToSectionCoord((double)player.getX());
                int cz = SectionPos.blockToSectionCoord((double)player.getZ());
                boolean removal = false;
                if (x > cx - dist && x < cx + dist) {
                    x += xStep * dist;
                    removal = true;
                }
                if (z > cz - dist && z < cz + dist) {
                    z += zStep * dist;
                    removal = true;
                }
                if (!removal && Math.abs(x) <= Math.abs(cx) && Math.abs(z) <= Math.abs(cz)) continue;
                iterator.remove();
            }
        } while ((chunkHolder = chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong((int)(x += xStep), (int)(z += zStep)))) != null && chunkHolder.getTicketLevel() >= 34);
        BlockPos.MutableBlockPos landingPos = new BlockPos.MutableBlockPos();
        LongSet forcedChunks = level.getForcedChunks();
        while (true) {
            boolean requires;
            if ((chunkHolder = chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong((int)x, (int)z))) != null && chunkHolder.getTicketLevel() >= 34) {
                if (level.random.nextBoolean()) {
                    x += xStep;
                    continue;
                }
                z += zStep;
                continue;
            }
            boolean bl = requires = !forcedChunks.contains(ChunkPos.asLong((int)x, (int)z));
            if (requires) {
                level.setChunkForced(x, z, true);
            }
            int bx = SectionPos.sectionToBlockCoord((int)x, (int)7);
            int bz = SectionPos.sectionToBlockCoord((int)z, (int)7);
            landingPos.set(bx, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, bx, bz), bz);
            if (requires) {
                level.setChunkForced(x, z, false);
            }
            x += xStep;
            z += zStep;
            if (level.getBlockState((BlockPos)landingPos).getFluidState().isEmpty()) break;
        }
        this.shouldGenerate = true;
        this.location = landingPos;
        this.tickUntilLanding = landingTime;
        MeteoriteLocationPacketS2C.sendToAll(this.location, landingTime);
        ConfluenceData.get(level).setDirty();
    }

    private void place(ServerLevel level, int chunkX, int chunkZ, boolean withForceChunk, BlockPos origin) {
        boolean placed = false;
        if (withForceChunk) {
            level.setChunkForced(chunkX, chunkZ, true);
        }
        try {
            ((ConfiguredFeature)level.registryAccess().holderOrThrow(METEORITE).value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), level.random, origin);
            placed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (withForceChunk) {
            level.setChunkForced(chunkX, chunkZ, false);
        }
        if (placed) {
            MutableComponent message = Component.translatable((String)"event.confluence.meteorite").withColor(GlobalColors.MESSAGE.get());
            level.getServer().getPlayerList().broadcastSystemMessage((Component)message, false);
            Confluence.LOGGER.debug("A meteorite has been landed, which at [{}]", (Object)origin.toShortString());
        }
    }

    public void deserialize(CompoundTag nbt) {
        this.spawnAtNextNight = nbt.getBoolean("spawnAtNextNight");
        this.location = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"meteoriteLocation").orElse(BlockPos.ZERO);
        this.tickUntilLanding = nbt.getInt("tickUtilMeteoriteLanding");
    }

    public void serialize(CompoundTag nbt) {
        nbt.putBoolean("spawnAtNextNight", this.spawnAtNextNight);
        nbt.put("meteoriteLocation", NbtUtils.writeBlockPos((BlockPos)this.location));
        nbt.putInt("tickUtilMeteoriteLanding", this.tickUntilLanding);
    }

    public static void spawnMeteor(ServerLevel level) {
        if (KillBoard.INSTANCE.isAnyDefeated((EntityType)TEBossEntities.EATER_OF_WORLDS.get(), (EntityType)TEBossEntities.BRAIN_OF_CTHULHU.get()) && level.random.nextFloat() < 0.02f) {
            MeteoriteTracker.INSTANCE.spawnAtNextNight = true;
        }
    }
}

