/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.common.data.saved.IGlobalData;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.mod.common.block.natural.ChlorophyteOreBlock;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.GlobalCloakData;
import org.confluence.mod.common.data.saved.HardmodeConvertor;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.common.gameevent.LanternNightGameEvent;
import org.confluence.mod.common.init.block.OreBlocks;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.network.s2c.KillBoardSyncPacketS2C;
import org.confluence.terraentity.init.entity.TEBossEntities;

public final class KillBoard
implements IGlobalData {
    public static final KillBoard INSTANCE = new KillBoard();
    public static final Codec<Object2BooleanMap<EntityType<?>>> DEFEATED_BOSSES_CODEC = ExtraCodecs.object2BooleanMap((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec());
    public static final Codec<Object2BooleanMap<ResourceKey<? extends GameEvent>>> DEFEATED_EVENTS_CODEC = ExtraCodecs.object2BooleanMap(GameEvent.KEY_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Object2BooleanMap<EntityType<?>>> DEFEATED_BOSSES_STREAM_CODEC = LibStreamCodecUtils.object2BooleanMap((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE));
    public static final StreamCodec<ByteBuf, Object2BooleanMap<ResourceKey<? extends GameEvent>>> DEFEATED_EVENTS_STREAM_CODEC = LibStreamCodecUtils.object2BooleanMap(GameEvent.KEY_STREAM_CODEC);
    private Object2BooleanMap<EntityType<?>> defeatedBosses = new Object2BooleanOpenHashMap();
    private Object2BooleanMap<ResourceKey<? extends GameEvent>> defeatedEvents = new Object2BooleanOpenHashMap();
    private GamePhase gamePhase = GamePhase.BEFORE_SKELETRON;

    private KillBoard() {
    }

    public boolean isDefeated(EntityType<?> entityType) {
        return this.defeatedBosses.getBoolean(entityType);
    }

    public boolean isDefeated(ResourceKey<? extends GameEvent> moment) {
        return this.defeatedEvents.getBoolean(moment);
    }

    public boolean isAnyDefeated(EntityType<?> ... entityTypes) {
        for (EntityType<?> entityType : entityTypes) {
            if (!this.isDefeated(entityType)) continue;
            return true;
        }
        return false;
    }

    public int countDefeated(EntityType<?> ... entityTypes) {
        int count = 0;
        for (EntityType<?> entityType : entityTypes) {
            if (!this.isDefeated(entityType)) continue;
            ++count;
        }
        return count;
    }

    @SafeVarargs
    public final int countDefeated(ResourceKey<? extends GameEvent> ... keys) {
        int count = 0;
        for (ResourceKey<? extends GameEvent> key : keys) {
            if (!this.isDefeated(key)) continue;
            ++count;
        }
        return count;
    }

    public Set<EntityType<?>> getDefeatedBosses() {
        return this.defeatedBosses.keySet();
    }

    public Set<ResourceKey<? extends GameEvent>> getDefeatedEvents() {
        return this.defeatedEvents.keySet();
    }

    public void defeat(EntityType<?> entityType) {
        boolean defeated = this.defeatedBosses.put(entityType, true);
        if (!defeated) {
            LanternNightGameEvent.INSTANCE.schedule();
        }
        if (entityType == TEBossEntities.SKELETRON.get()) {
            this.setGamePhase(ServerLifecycleHooks.getCurrentServer(), GamePhase.AFTER_SKELETRON);
        } else if (entityType == TEBossEntities.WALL_OF_FLESH.get() || entityType == TEBossEntities.HILL_OF_FLESH.get()) {
            this.setGamePhase(ServerLifecycleHooks.getCurrentServer(), GamePhase.WALL_OF_FLESH);
        } else {
            KillBoardSyncPacketS2C.sendToAll();
        }
    }

    public void defeat(ResourceKey<? extends GameEvent> key) {
        boolean defeated = this.defeatedEvents.put(key, true);
        if (!defeated && GameEventSystem.isInvasionEvent(key)) {
            LanternNightGameEvent.INSTANCE.schedule();
        }
        KillBoardSyncPacketS2C.sendToAll();
    }

    public GamePhase getGamePhase() {
        return this.gamePhase;
    }

    public void setGamePhase(MinecraftServer server, GamePhase gamePhase) {
        this.gamePhase = gamePhase;
        KillBoardSyncPacketS2C.sendToAll();
        if (gamePhase.isGraduated()) {
            IMinecraftServer.of(server).confluence$updateSecretFlag(12L);
        } else if (gamePhase.isHardmode()) {
            this.onUnlockHardmode(server);
            HardmodeConvertor.INSTANCE.start(server, false);
        }
    }

    public void onUnlockHardmode(MinecraftServer server) {
        IMinecraftServer.of(server).confluence$updateSecretFlag(4L);
        GlobalCloakData.INSTANCE.reveal(((ChlorophyteOreBlock)((Object)OreBlocks.CHLOROPHYTE_ORE.get())).defaultBlockState());
        if (!this.getGamePhase().isHardmode()) {
            this.setGamePhase(server, GamePhase.WALL_OF_FLESH);
        }
    }

    public void networkEncode(RegistryFriendlyByteBuf buffer) {
        DEFEATED_BOSSES_STREAM_CODEC.encode((Object)buffer, this.defeatedBosses);
        DEFEATED_EVENTS_STREAM_CODEC.encode((Object)buffer, this.defeatedEvents);
        GamePhase.STREAM_CODEC.encode((Object)buffer, (Object)this.gamePhase);
    }

    public void networkDecode(RegistryFriendlyByteBuf buffer) {
        this.defeatedBosses = (Object2BooleanMap)DEFEATED_BOSSES_STREAM_CODEC.decode((Object)buffer);
        this.defeatedEvents = (Object2BooleanMap)DEFEATED_EVENTS_STREAM_CODEC.decode((Object)buffer);
        this.gamePhase = (GamePhase)((Object)GamePhase.STREAM_CODEC.decode((Object)buffer));
    }

    public void decode(CompoundTag tag) {
        DEFEATED_BOSSES_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("defeated_bosses")).ifSuccess(result -> {
            this.defeatedBosses = result;
        });
        DEFEATED_EVENTS_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("defeated_events")).ifSuccess(result -> {
            this.defeatedEvents = result;
        });
        this.gamePhase = GamePhase.getByOrder(tag.getInt("game_phase"));
    }

    public void encode(CompoundTag tag) {
        tag.put("defeated_bosses", DEFEATED_BOSSES_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.defeatedBosses).result().orElseGet(CompoundTag::new));
        tag.put("defeated_events", DEFEATED_EVENTS_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.defeatedEvents).result().orElseGet(CompoundTag::new));
        tag.putInt("game_phase", this.gamePhase.getOrder());
    }

    public String serializeKey() {
        return "confluence:kill_board";
    }

    public void clear() {
        this.defeatedBosses = new Object2BooleanOpenHashMap();
        this.defeatedEvents = new Object2BooleanOpenHashMap();
        this.gamePhase = GamePhase.BEFORE_SKELETRON;
    }
}

