/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.data.saved.IGlobalData;
import org.confluence.lib.util.LibCodecUtils;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.entity.npc.house.House;
import org.jetbrains.annotations.Nullable;

public class HouseHandler
implements IGlobalData {
    private static final Codec<Map<ResourceKey<Level>, Map<NPCSpawner.Region, Map<UUID, House>>>> DATA_CODEC = LibCodecUtils.notStringKeyMap((String)"dimension", (Codec)ResourceKey.codec((ResourceKey)Registries.DIMENSION), (String)"regions", (Codec)LibCodecUtils.notStringKeyMap((String)"region", NPCSpawner.Region.CODEC, (String)"houses", (Codec)LibCodecUtils.notStringKeyMap((String)"uuid", (Codec)UUIDUtil.CODEC, (String)"house", (Codec)House.CODEC)));
    private final Map<ResourceKey<Level>, Map<NPCSpawner.Region, Map<UUID, House>>> data = new Object2ObjectOpenHashMap();

    private HouseHandler() {
    }

    public Map<NPCSpawner.Region, Map<UUID, House>> getOrCreateRegions(ResourceKey<Level> dimension) {
        return this.data.computeIfAbsent(dimension, d -> new Object2ObjectOpenHashMap());
    }

    public Map<UUID, House> getOrCreateHouses(ResourceKey<Level> dimension, NPCSpawner.Region region) {
        return this.getOrCreateRegions(dimension).computeIfAbsent(region, r -> new Object2ObjectOpenHashMap());
    }

    public void setHouse(ResourceKey<Level> dimension, NPCSpawner.Region region, UUID uuid, House house) {
        this.getOrCreateHouses(dimension, region).put(uuid, house);
    }

    @Nullable
    public House getHouse(ResourceKey<Level> dimension, NPCSpawner.Region region, UUID uuid) {
        Map<NPCSpawner.Region, Map<UUID, House>> map = this.data.get(dimension);
        if (map == null) {
            return null;
        }
        Map<UUID, House> map1 = map.get(region);
        if (map1 == null) {
            return null;
        }
        return map1.get(uuid);
    }

    public void setHouse(AbstractTerraNPC npc, House house) {
        this.setHouse((ResourceKey<Level>)npc.level().dimension(), new NPCSpawner.Region(house.center()), npc.getUUID(), house);
    }

    @Nullable
    public House getHouse(AbstractTerraNPC npc) {
        BlockPos pos = npc.getSpawnAtPos();
        if (pos == null) {
            return null;
        }
        return this.getHouse((ResourceKey<Level>)npc.level().dimension(), new NPCSpawner.Region(pos), npc.getUUID());
    }

    public void decode(CompoundTag tag) {
        DATA_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getList("data", 9)).ifSuccess(this.data::putAll);
    }

    public void encode(CompoundTag tag) {
        DATA_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.data).ifSuccess(nbt -> tag.put("data", nbt));
    }

    public String serializeKey() {
        return "confluence:house_handler";
    }

    public void clear() {
        this.data.clear();
    }
}

