/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import com.google.common.base.Stopwatch;
import com.google.common.collect.AbstractIterator;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.LongStream;
import javax.annotation.CheckForNull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.mutable.MutableInt;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.common.data.saved.IGlobalData;
import org.confluence.lib.util.LibCodecUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.EnterHardmodeEvent;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.mixed.IDedicatedServer;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.network.s2c.SecretFlagSyncPacketS2C;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.OverworldUtils;

public final class HardmodeConvertor
implements IGlobalData {
    public static final HardmodeConvertor INSTANCE = new HardmodeConvertor();
    public static final Codec<List<Tuple<ChunkPos, BlockPosColumn[][]>>> SANCTIFICATION_CODEC = Codec.lazyInitialized(() -> {
        Codec<BlockPosColumn[][]> codec = new Codec<BlockPosColumn[][]>(){

            public <T> DataResult<Pair<BlockPosColumn[][], T>> decode(DynamicOps<T> ops, T input) {
                BlockPosColumn[][] columns = new BlockPosColumn[16][16];
                MutableInt counter = new MutableInt();
                ((LongStream)ops.getLongStream(input).getOrThrow()).forEach(l -> {
                    int i = counter.getAndIncrement();
                    int x = i / 16;
                    int z = i % 16;
                    columns[x][z] = BlockPosColumn.of(l);
                });
                return DataResult.success((Object)new Pair((Object)columns, input), (Lifecycle)Lifecycle.stable());
            }

            public <T> DataResult<T> encode(BlockPosColumn[][] input, DynamicOps<T> ops, T prefix) {
                Object longList = ops.createLongList(Arrays.stream(input).flatMapToLong(columns -> Arrays.stream(columns).mapToLong(BlockPosColumn::asLong)));
                return DataResult.success((Object)longList, (Lifecycle)Lifecycle.stable());
            }
        };
        return LibCodecUtils.tuple((Codec)Codec.LONG.xmap(ChunkPos::new, ChunkPos::toLong), (Codec)codec).listOf().xmap(LinkedList::new, Function.identity());
    });
    private volatile boolean started = false;
    private volatile List<Tuple<ChunkPos, BlockPosColumn[][]>> sanctification = new LinkedList<Tuple<ChunkPos, BlockPosColumn[][]>>();
    private volatile boolean completed = false;
    private volatile transient boolean shouldContinue = true;

    private HardmodeConvertor() {
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void start(MinecraftServer server, boolean debug) {
        if (this.started || this.completed) {
            return;
        }
        if (server instanceof IDedicatedServer) {
            IDedicatedServer dedicatedServer = (IDedicatedServer)server;
            dedicatedServer.confluence$setOnHardmodeConversation(true);
        }
        this.shouldContinue = false;
        this.started = true;
        HardmodeConvertor.print(server, (Component)Component.translatable((String)"event.confluence.hardmode_conversion.starting"), debug);
        CompletableFuture.supplyAsync(() -> {
            ServerLevel overworld = OverworldUtils.getLevel(server);
            BlockPos startPos = server.getWorldData().overworldData().getSpawnPos().atY(overworld.getMinBuildHeight());
            int height = overworld.getMaxBuildHeight() - overworld.getMinBuildHeight();
            int startRadius = 32;
            int thickness = 64;
            return HardmodeConvertor.generateConicalCylinder(startPos, height, startRadius, startRadius + height, thickness);
        }, Util.backgroundExecutor()).thenAccept(list -> {
            this.sanctification = list;
            this.shouldContinue = true;
            if (((Boolean)CommonConfigs.INSTANTLY_HARDMODE_CONVERSION.get()).booleanValue()) {
                HardmodeConvertor.print(server, (Component)Component.translatable((String)"event.confluence.hardmode_conversion.instantly"), debug);
            } else {
                HardmodeConvertor.print(server, (Component)Component.translatable((String)"event.confluence.hardmode_conversion.generate_data.sanctification", (Object[])new Object[]{this.sanctification.size(), this.sanctification.size() / 4}), debug);
            }
            HardmodeConvertor.print(server, (Component)Component.translatable((String)"event.confluence.hardmode_conversion.started"), debug);
        });
    }

    public void scheduleRefill(ServerLevel serverLevel) {
        if (this.completed || !this.shouldContinue) {
            return;
        }
        if (this.sanctification.isEmpty()) {
            if (this.started) {
                this.completed = true;
                MinecraftServer server = serverLevel.getServer();
                if (server instanceof IDedicatedServer) {
                    IDedicatedServer dedicatedServer2 = (IDedicatedServer)server;
                    dedicatedServer2.confluence$setOnHardmodeConversation(false);
                }
                KillBoard.INSTANCE.onUnlockHardmode(server);
                SecretFlagSyncPacketS2C.sendToAll(IMinecraftServer.of(server).confluence$getSecretFlag());
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    AchievementUtils.awardAchievement(player, "its_hard");
                }
                HardmodeConvertor.print(server, (Component)Component.translatable((String)"event.confluence.hardmode_conversion.hardmode"), LibUtils.isDev());
                HardmodeConvertor.print(server, (Component)Component.translatable((String)"event.confluence.hardmode_conversion.finished").withColor(GlobalColors.MESSAGE.get()), true);
                HardmodeConvertor.print(server, (Component)Component.translatable((String)"event.confluence.hardmode_conversion.welcome").withColor(GlobalColors.EVENT.get()), true);
                NeoForge.EVENT_BUS.post((Event)new EnterHardmodeEvent(server));
            }
            this.started = false;
        } else {
            IDedicatedServer dedicatedServer;
            MinecraftServer dedicatedServer2 = serverLevel.getServer();
            if (dedicatedServer2 instanceof IDedicatedServer && !(dedicatedServer = (IDedicatedServer)dedicatedServer2).confluence$isOnHardmodeConversation()) {
                dedicatedServer.confluence$setOnHardmodeConversation(true);
            }
            if (((Boolean)CommonConfigs.INSTANTLY_HARDMODE_CONVERSION.get()).booleanValue()) {
                Confluence.LOGGER.debug("Starting hardmode conversion ...");
                Stopwatch stopwatch = Stopwatch.createStarted();
                this.sanctification.removeIf(entry -> {
                    boolean noForceBefore;
                    ChunkPos chunkPos = (ChunkPos)entry.getA();
                    boolean bl = noForceBefore = !serverLevel.getForcedChunks().contains(chunkPos.toLong());
                    if (noForceBefore) {
                        serverLevel.setChunkForced(chunkPos.x, chunkPos.z, true);
                    }
                    boolean refilled = this.refill(serverLevel, chunkPos, (BlockPosColumn[][])entry.getB());
                    if (noForceBefore) {
                        serverLevel.setChunkForced(chunkPos.x, chunkPos.z, false);
                    }
                    return refilled;
                });
                Confluence.LOGGER.debug("Hardmode conversion took {}", (Object)stopwatch.stop());
            } else if (serverLevel.getGameTime() % 5L == 0L && serverLevel.getServer().getPlayerList().getPlayers().stream().noneMatch(Entity::isRemoved)) {
                boolean noForceBefore;
                Tuple<ChunkPos, BlockPosColumn[][]> entry2 = this.sanctification.getFirst();
                ChunkPos chunkPos = (ChunkPos)entry2.getA();
                boolean bl = noForceBefore = !serverLevel.getForcedChunks().contains(chunkPos.toLong());
                if (noForceBefore) {
                    serverLevel.setChunkForced(chunkPos.x, chunkPos.z, true);
                }
                boolean refilled = this.refill(serverLevel, chunkPos, (BlockPosColumn[][])entry2.getB());
                if (noForceBefore) {
                    serverLevel.setChunkForced(chunkPos.x, chunkPos.z, false);
                }
                if (refilled) {
                    this.sanctification.removeFirst();
                }
            }
        }
    }

    private boolean refill(ServerLevel overworld, ChunkPos chunkPos, BlockPosColumn[][] set) {
        ChunkAccess chunkAccess = overworld.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.FULL, false);
        if (chunkAccess == null) {
            return false;
        }
        int cx = SectionPos.sectionToBlockCoord((int)chunkPos.x);
        int cz = SectionPos.sectionToBlockCoord((int)chunkPos.z);
        BlockState cachedState = null;
        boolean isGrassBlock = false;
        for (int x = 0; x < 16; ++x) {
            BlockPosColumn[] columns = set[x];
            for (int z = 0; z < 16; ++z) {
                BlockPosColumn column = columns[z];
                if (column == null || column == BlockPosColumn.ZERO) continue;
                for (BlockPos blockPos : column.iterable(cx + x, cz + z)) {
                    BlockState target = ISpreadable.Type.HALLOW.getNullable(chunkAccess.getBlockState(blockPos), true);
                    if (target == null) continue;
                    if (cachedState != target) {
                        cachedState = target;
                        isGrassBlock = target.is(ModTags.Blocks.SPREADABLE_GRASS_BLOCK);
                    }
                    if (isGrassBlock) {
                        BlockPos above = blockPos.above();
                        if (!Block.isShapeFullBlock((VoxelShape)chunkAccess.getBlockState(above).getCollisionShape((BlockGetter)chunkAccess, above))) continue;
                        chunkAccess.setBlockState(blockPos, target, false);
                        continue;
                    }
                    chunkAccess.setBlockState(blockPos, target, false);
                }
            }
        }
        ChunkMap chunkMap = overworld.getChunkSource().chunkMap;
        for (ServerPlayer player : overworld.players()) {
            if (!player.getChunkTrackingView().contains(chunkPos)) continue;
            chunkMap.markChunkPendingToSend(player, chunkPos);
        }
        return true;
    }

    private static List<Tuple<ChunkPos, BlockPosColumn[][]>> generateConicalCylinder(BlockPos startPos, int height, int startRadius, int endRadius, int thickness) {
        float deltaRadius = (float)(endRadius - startRadius) / (float)height;
        float currentRadius = startRadius;
        HashMap<ChunkPos, BlockPosColumn[][]> map = new HashMap<ChunkPos, BlockPosColumn[][]>();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = 0; y < height; ++y) {
            mutable.setY(y + startPos.getY());
            float startDiameter = (currentRadius + (float)thickness) * 2.0f + 1.0f;
            float currentOuterSqr = currentRadius * currentRadius;
            float currentInnerSqr = Mth.square((float)(currentRadius - (float)thickness));
            int x = 0;
            while ((float)x < startDiameter) {
                mutable.setX((int)((float)x - currentRadius + (float)startPos.getX()));
                int cacheXSqr = (int)Mth.square((float)((float)x - currentRadius));
                int z = 0;
                while ((float)z < startDiameter) {
                    int cacheSqr = (int)(Mth.square((float)((float)z - currentRadius)) + (float)cacheXSqr);
                    if ((float)cacheSqr < currentOuterSqr && (float)cacheSqr > currentInnerSqr) {
                        mutable.setZ((int)((float)z - currentRadius + (float)startPos.getZ()));
                        ChunkPos chunkPos = new ChunkPos((BlockPos)mutable);
                        BlockPosColumn[][] columns = map.computeIfAbsent(chunkPos, pos -> {
                            BlockPosColumn[][] posColumns = new BlockPosColumn[16][16];
                            for (int i = 0; i < 16; ++i) {
                                Object[] columnss = new BlockPosColumn[16];
                                Arrays.fill(columnss, BlockPosColumn.ZERO);
                                posColumns[i] = columnss;
                            }
                            return posColumns;
                        });
                        int i = mutable.getX() - chunkPos.getMinBlockX();
                        int j = mutable.getZ() - chunkPos.getMinBlockZ();
                        BlockPosColumn column = columns[i][j];
                        if (column == null || column == BlockPosColumn.ZERO) {
                            column = new BlockPosColumn(startPos.getY(), height);
                        }
                        columns[i][j] = column.updateY(mutable.getY());
                    }
                    ++z;
                }
                ++x;
            }
            currentRadius += deltaRadius;
        }
        LinkedList<Tuple<ChunkPos, BlockPosColumn[][]>> list = new LinkedList<Tuple<ChunkPos, BlockPosColumn[][]>>();
        for (Map.Entry entry : map.entrySet()) {
            list.add((Tuple<ChunkPos, BlockPosColumn[][]>)new Tuple((Object)((ChunkPos)entry.getKey()), (Object)((BlockPosColumn[][])entry.getValue())));
        }
        return list;
    }

    private static void print(MinecraftServer server, Component component, boolean debug) {
        if (debug) {
            server.getPlayerList().broadcastSystemMessage(component, false);
        }
    }

    public void decode(CompoundTag tag) {
        this.shouldContinue = false;
        SANCTIFICATION_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getList("sanctification", 9)).ifSuccess(result -> {
            this.sanctification = result;
        });
        this.started = tag.getBoolean("started");
        this.completed = tag.getBoolean("completed");
        this.shouldContinue = true;
    }

    public void encode(CompoundTag tag) {
        this.shouldContinue = false;
        tag.put("sanctification", SANCTIFICATION_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.sanctification).result().orElseGet(ListTag::new));
        tag.putBoolean("started", this.started);
        tag.putBoolean("completed", this.completed);
        this.shouldContinue = true;
    }

    public String serializeKey() {
        return "confluence:hardmode_convertor";
    }

    public void clear() {
        this.started = false;
        this.completed = false;
        this.sanctification.clear();
        this.shouldContinue = true;
    }

    public static class BlockPosColumn {
        public static final BlockPosColumn ZERO = new BlockPosColumn(0, 0);
        public static final Codec<BlockPosColumn> CODEC = Codec.LONG.xmap(BlockPosColumn::of, BlockPosColumn::asLong);
        private int minY;
        private int maxY;

        public BlockPosColumn(int minY, int height) {
            this.minY = minY + height;
            this.maxY = minY;
        }

        public BlockPosColumn updateY(int y) {
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
            return this;
        }

        public long asLong() {
            return (long)this.minY & 0xFFFFFFFFL | ((long)this.maxY & 0xFFFFFFFFL) << 32;
        }

        public Iterable<BlockPos> iterable(final int x, final int z) {
            final int min = Math.min(this.minY, this.maxY);
            final int max = Math.max(this.minY, this.maxY);
            return () -> new AbstractIterator<BlockPos>(this){
                private final BlockPos.MutableBlockPos cursor;
                private int index;
                private final int endIndex;
                {
                    this.cursor = new BlockPos.MutableBlockPos(x, 0, z);
                    this.index = min;
                    this.endIndex = max + 1;
                }

                @CheckForNull
                protected BlockPos computeNext() {
                    if (this.index == this.endIndex) {
                        return (BlockPos)this.endOfData();
                    }
                    return this.cursor.setY(this.index++);
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof BlockPosColumn)) return false;
            BlockPosColumn column = (BlockPosColumn)obj;
            if (column.minY != this.minY) return false;
            if (column.maxY != this.maxY) return false;
            return true;
        }

        public static BlockPosColumn of(long packedPos) {
            return new BlockPosColumn((int)(packedPos & 0xFFFFFFFFL), (int)(packedPos >>> 32 & 0xFFFFFFFFL));
        }
    }
}

