/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.api.entity.Boss;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.lib.util.ReturnException;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.common.gameevent.BloodMoonGameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.common.gameevent.LanternNightGameEvent;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.init.entity.TEBossEntities;

public final class BossDelaySpawner {
    public static final BossDelaySpawner INSTANCE = new BossDelaySpawner();
    public static final int SUCCESS = 0;
    public static final int CONTINUE = -1;
    public static final int CANCEL = -2;
    private final List<Delayed<AbstractTerraBossBase>> bossQueue = new ArrayList<Delayed<AbstractTerraBossBase>>();

    private BossDelaySpawner() {
    }

    public void tick(ServerLevel level) {
        if (this.bossQueue.isEmpty()) {
            return;
        }
        Iterator<Delayed<AbstractTerraBossBase>> iterator = this.bossQueue.iterator();
        block0: while (iterator.hasNext()) {
            Delayed<AbstractTerraBossBase> delayed = iterator.next();
            if (--delayed.delay >= 0) continue;
            for (ServerPlayer player : level.players()) {
                int state = delayed.predicate.applyAsInt(player);
                if (state == 0) {
                    ModUtils.summonBoss(level, player.blockPosition(), (AbstractTerraBossBase)delayed.entity.create((Level)level));
                    iterator.remove();
                    continue block0;
                }
                if (state == -2) {
                    iterator.remove();
                    continue block0;
                }
                if (state == -1) continue;
                delayed.delay = state;
                continue block0;
            }
            iterator.remove();
        }
    }

    public void pushBoss(int delay, EntityType<? extends AbstractTerraBossBase> boss, ToIntFunction<ServerPlayer> predicate) {
        if (this.bossQueue.size() == 8) {
            this.bossQueue.removeFirst();
        }
        this.bossQueue.add(new Delayed<AbstractTerraBossBase>(delay, boss, predicate));
    }

    public boolean hasSameTypeInQueue(EntityType<?> type) {
        if (this.bossQueue.isEmpty()) {
            return false;
        }
        return this.bossQueue.stream().anyMatch(delayed -> delayed.entity == type);
    }

    public void clear() {
        this.bossQueue.clear();
    }

    public static void spawnEyeOfCthulhu(ServerLevel level) {
        if (!((Boolean)CommonConfigs.EYE_OF_CTHULHU_NATURE_SPAWNING.get()).booleanValue()) {
            return;
        }
        if (GameEventSystem.INSTANCE.getStartedEventAmount(true, false) > 0) {
            return;
        }
        if (LanternNightGameEvent.INSTANCE.started()) {
            return;
        }
        EntityType type = (EntityType)TEBossEntities.EYE_OF_CTHULHU.get();
        if (KillBoard.INSTANCE.isDefeated(type) || INSTANCE.hasSameTypeInQueue(type)) {
            return;
        }
        for (ServerPlayer player : level.players()) {
            if (!BossDelaySpawner.eyeOfCthulhuChecker(player) || level.random.nextFloat() >= 0.3333f) continue;
            INSTANCE.pushBoss(1350, (EntityType<? extends AbstractTerraBossBase>)((EntityType)TEBossEntities.EYE_OF_CTHULHU.get()), player1 -> player1.getY() > (double)OverworldUtils.getSurfaceY() && LibDateUtils.isNight((Level)player1.level()) && BossDelaySpawner.eyeOfCthulhuChecker(player1) ? 0 : 20);
            level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"event.confluence.eye_of_cthulhu").withColor(GlobalColors.MESSAGE.get()), false);
            break;
        }
    }

    public static boolean eyeOfCthulhuChecker(ServerPlayer player) {
        if (player.getMaxHealth() < 40.0f || player.getArmorValue() < 10) {
            return false;
        }
        NPCSpawner.Region region = NPCSpawner.getNpcSpawnRegion(player);
        if (NPCSpawner.INSTANCE.getAliveNpcCount(region, type -> true) < 4) {
            return false;
        }
        return Boss.noBossInWorld((ServerLevel)player.serverLevel());
    }

    public static void spawnDeerClops(ServerLevel level) {
        if (!((Boolean)CommonConfigs.DEERCLOPS_NATURE_SPAWNING.get()).booleanValue()) {
            return;
        }
        if (!level.isRaining()) {
            return;
        }
        if (INSTANCE.hasSameTypeInQueue((EntityType)TEBossEntities.DEERCLOPS.get())) {
            return;
        }
        for (ServerPlayer player : level.players()) {
            if (!BossDelaySpawner.deerclopsChecker(player)) continue;
            INSTANCE.pushBoss(0, (EntityType<? extends AbstractTerraBossBase>)((EntityType)TEBossEntities.DEERCLOPS.get()), player1 -> BossDelaySpawner.deerclopsChecker(player1) ? 0 : -1);
            break;
        }
    }

    public static boolean deerclopsChecker(ServerPlayer player) {
        if (player.getY() < (double)OverworldUtils.getSurfaceY()) {
            return false;
        }
        if (player.getMaxHealth() < 40.0f && player.getArmorValue() < 9) {
            return false;
        }
        ServerLevel level = player.serverLevel();
        Holder biome = level.getBiome(player.blockPosition());
        if (!biome.is(Tags.Biomes.IS_SNOWY) && !biome.is(Tags.Biomes.IS_ICY)) {
            return false;
        }
        int amount = GameEventSystem.INSTANCE.getStartedEventAmount(true, false);
        if (!(amount == 0 || amount == 1 && BloodMoonGameEvent.INSTANCE.started())) {
            return false;
        }
        try {
            level.getEntities().get(new AABB(player.blockPosition()).inflate(80.0), entity -> {
                if (entity instanceof AbstractTerraNPC) {
                    throw new ReturnException();
                }
            });
        }
        catch (Exception ignored) {
            return false;
        }
        return Boss.noBossInWorld((ServerLevel)player.serverLevel());
    }

    static class Delayed<E extends Entity> {
        int delay;
        final EntityType<? extends E> entity;
        final ToIntFunction<ServerPlayer> predicate;

        Delayed(int delay, EntityType<? extends E> entity, ToIntFunction<ServerPlayer> predicate) {
            this.delay = delay;
            this.entity = entity;
            this.predicate = predicate;
        }
    }
}

