/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.map;

import com.mojang.serialization.Codec;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import org.confluence.mod.common.component.LootComponent;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModDataMaps;
import org.confluence.mod.common.item.common.TreasureBagItem;
import org.jetbrains.annotations.Nullable;

public record TreasureBagDrop(Item item) {
    public static final Codec<TreasureBagDrop> CODEC = BuiltInRegistries.ITEM.byNameCodec().xmap(TreasureBagDrop::new, TreasureBagDrop::item);

    @Nullable
    public static ItemStack getTreasureBag(LivingEntity living) {
        Item item;
        Level level = living.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TreasureBagDrop data = ModDataMaps.getEntityData(ModDataMaps.TREASURE_BAG, (Entity)living);
        if (data == null || !((item = data.item()) instanceof TreasureBagItem)) {
            return null;
        }
        TreasureBagItem item2 = (TreasureBagItem)item;
        ItemStack itemStack = item2.getDefaultInstance();
        ResourceLocation lootTable = item2.lootTable.withSuffix(item2.suffix.apply(serverLevel, living.blockPosition()));
        itemStack.set(ModDataComponentTypes.LOOT, (Object)new LootComponent((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable)));
        return itemStack;
    }
}

