/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.map;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.confluence.mod.common.init.ModDataMaps;
import org.jetbrains.annotations.Nullable;

public record BugNetEntityToItem(List<Tuple<EntityPredicate, ItemStack>> list) {
    public static final EntityPredicate EMPTY_PREDICATE = EntityPredicate.Builder.entity().build();
    public static final Codec<BugNetEntityToItem> CODEC = Codec.lazyInitialized(() -> {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.CODEC.lenientOptionalFieldOf("predicate", (Object)EMPTY_PREDICATE).forGetter(Tuple::getA), (App)ItemStack.CODEC.fieldOf("result").forGetter(Tuple::getB)).apply((Applicative)instance, Tuple::new));
        return Codec.either((Codec)codec.listOf(), (Codec)codec).xmap(either -> (List)either.map(Function.identity(), List::of), tuples -> tuples.size() == 1 ? Either.right((Object)((Tuple)tuples.getFirst())) : Either.left((Object)tuples)).xmap(BugNetEntityToItem::new, BugNetEntityToItem::list);
    });

    @Nullable
    public static ItemStack getItem(ServerPlayer player, LivingEntity living) {
        BugNetEntityToItem data = ModDataMaps.getEntityData(ModDataMaps.BUG_NET_ENTITY_TO_ITEM, (Entity)living);
        if (data != null) {
            for (Tuple<EntityPredicate, ItemStack> tuple : data.list) {
                if (!((EntityPredicate)tuple.getA()).matches(player, (Entity)living)) continue;
                return ((ItemStack)tuple.getB()).copy();
            }
        }
        return null;
    }
}

