/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.fixer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.mixin.fixer.ChestBlockEntityAccessor;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.data.fixer.RegistriesFixer;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.mixed.IBaseContainerBlockEntity;
import org.jetbrains.annotations.Nullable;

public class FixedBaseChestBlock
extends ChestBlock {
    public static final BooleanProperty UNLOCKED = StateProperties.UNLOCKED;

    public FixedBaseChestBlock() {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST), RegistriesFixer.BASE_CHEST_BLOCK_ENTITY::get);
    }

    public FixedBaseChestBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier) {
        super(properties, supplier);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{UNLOCKED}));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof BEntity) {
            BEntity entity = (BEntity)((Object)object);
            return Collections.singletonList(FixedBaseChestBlock.setData(RegistriesFixer.BASE_CHEST_BLOCK.toStack(), entity.variant));
        }
        return Collections.emptyList();
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)UNLOCKED) != false ? super.getExplosionResistance(state, level, pos, explosion) : 18000.0f;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        Variant variantId = Variant.byId(LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getInt("VariantId"));
        BlockState blockState = (BlockState)state.setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(variantId.unlock < 0));
        level.setBlockAndUpdate(pos, blockState);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            entity.variant = variantId;
            entity.setBlockState(blockState);
        }
    }

    @Nullable
    protected Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockPos relative = context.getClickedPos().relative(direction);
        BlockEntity blockEntity = context.getLevel().getBlockEntity(relative);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            ItemStack itemStack = context.getItemInHand();
            if (LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack).getInt("VariantId") != entity.variant.id) {
                return null;
            }
            BlockState blockstate = context.getLevel().getBlockState(relative);
            return blockstate.is((Block)this) && blockstate.getValue((Property)TYPE) == ChestType.SINGLE ? (Direction)blockstate.getValue((Property)FACING) : null;
        }
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean isShadow;
        BEntity entity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity && (entity = (BEntity)blockEntity).isLocked() && ((isShadow = stack.is(ToolItems.SHADOW_KEY)) && entity.variant == Variant.LOCKED_SHADOW || stack.is(ToolItems.GOLDEN_KEY) && entity.variant == Variant.LOCKED_GOLDEN || stack.is(ToolItems.GOLDEN_DUNGEON_KEY) && entity.variant == Variant.LOCKED_DUNGEON)) {
            int unlock = entity.variant.unlock;
            if (unlock > 0) {
                BlockEntity blockEntity2;
                if (!isShadow && !player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                entity.variant = Variant.byId(unlock);
                MutableComponent name = Component.translatable((String)("block.confluence.base_chest_block." + entity.variant.name));
                IBaseContainerBlockEntity.of((BaseContainerBlockEntity)entity).confluence$setCustomName((Component)name);
                Direction relativeDir = ChestBlock.getConnectedDirection((BlockState)state);
                boolean isDouble = false;
                if (state.getValue((Property)TYPE) != ChestType.SINGLE && (blockEntity2 = level.getBlockEntity(pos.relative(relativeDir))) instanceof BEntity) {
                    BEntity entity1 = (BEntity)blockEntity2;
                    entity1.variant = entity.variant;
                    IBaseContainerBlockEntity.of((BaseContainerBlockEntity)entity).confluence$setCustomName((Component)name);
                    isDouble = true;
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.playSound(null, pos, SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS);
                    double posX = (double)pos.getX() + 0.5;
                    double posZ = (double)pos.getZ() + 0.5;
                    if (isDouble) {
                        posX += (double)relativeDir.getStepX() * 0.5;
                        posZ += (double)relativeDir.getStepZ() * 0.5;
                    }
                    serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.CHAIN.defaultBlockState()), posX, (double)pos.getY() + 0.5, posZ, 200, 0.0625, 0.0625, 0.0625, 0.15);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(true)));
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BEntity entity;
        BlockEntity blockEntity;
        if (!((Boolean)state.getValue((Property)UNLOCKED)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof BEntity && !(entity = (BEntity)blockEntity).isLocked()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(true)), 3);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            return FixedBaseChestBlock.setData(itemStack, entity.variant);
        }
        return itemStack;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return (Boolean)state.getValue((Property)UNLOCKED) != false && super.canEntityDestroy(state, level, pos, entity);
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)UNLOCKED) != false ? super.getDestroyProgress(state, player, level, pos) : 0.0f;
    }

    public static ItemStack setData(ItemStack itemStack, Variant variant) {
        LibUtils.updateItemStackNbt((ItemStack)itemStack, tag -> tag.putInt("VariantId", variant.id));
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("block.confluence.base_chest_block." + variant.name)).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        return itemStack;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : LibUtils.getTicker(blockEntityType, RegistriesFixer.BASE_CHEST_BLOCK_ENTITY.get(), BEntity::baseTick);
    }

    public static class BEntity
    extends ChestBlockEntity {
        public Variant variant = Variant.LOCKED_GOLDEN;
        private static final ResourceKey<LootTable> IVY_CHESTS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Confluence.asResource("chests/ivy_chests"));
        private static final ResourceKey<LootTable> LIVING_IVY_CHESTS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Confluence.asResource("chests/living_ivy_chests"));

        public BEntity(BlockPos pPos, BlockState pBlockState) {
            super(RegistriesFixer.BASE_CHEST_BLOCK_ENTITY.get(), pPos, pBlockState);
        }

        public BEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
            super(pType, pPos, pBlockState);
        }

        public boolean isLocked() {
            return this.variant.unlock > 0;
        }

        public boolean canOpen(Player pPlayer) {
            return !this.isLocked() && super.canOpen(pPlayer);
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            this.variant = Variant.byId(tag.getInt("VariantId"));
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            tag.putInt("VariantId", this.variant.id);
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            CompoundTag nbt = super.getUpdateTag(registries);
            nbt.putInt("VariantId", this.variant.id);
            return nbt;
        }

        public boolean canTakeItem(Container target, int slot, ItemStack stack) {
            return !this.isLocked();
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return !this.isLocked();
        }

        public static void baseTick(Level level, BlockPos blockPos, BlockState blockState, BEntity entity) {
            BlockState target = (BlockState)((BlockState)((BlockState)BEntity.getBlockByVariant(entity.variant).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)ChestBlock.FACING)))).setValue((Property)ChestBlock.WATERLOGGED, (Comparable)((Boolean)blockState.getValue((Property)ChestBlock.WATERLOGGED)))).setValue((Property)ChestBlock.TYPE, (Comparable)((ChestType)blockState.getValue((Property)ChestBlock.TYPE)));
            ResourceKey<LootTable> lootTable = entity.lootTable;
            if (lootTable != null) {
                if ("chests/lvy_chests".equals(lootTable.location().getPath())) {
                    lootTable = IVY_CHESTS;
                } else if ("chests/living_lvy_chests".equals(lootTable.location().getPath())) {
                    lootTable = LIVING_IVY_CHESTS;
                }
            }
            long lootTableSeed = entity.lootTableSeed;
            entity.setLootTable(null);
            NonNullList items = NonNullList.withSize((int)entity.getContainerSize(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < entity.getContainerSize(); ++i) {
                ItemStack itemStack = entity.getItem(i);
                if (itemStack.isEmpty()) continue;
                items.set(i, (Object)itemStack);
            }
            entity.clearContent();
            level.setBlockAndUpdate(blockPos, target.hasProperty((Property)UNLOCKED) ? (BlockState)target.setValue((Property)UNLOCKED, (Comparable)((Boolean)blockState.getValue((Property)UNLOCKED))) : target);
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity blockEntity2 = (ChestBlockEntity)blockEntity;
                ((ChestBlockEntityAccessor)blockEntity2).callSetItems(items);
                blockEntity2.setLootTable(lootTable);
                blockEntity2.setLootTableSeed(lootTableSeed);
            }
        }

        private static Block getBlockByVariant(Variant variant) {
            return switch (variant.ordinal()) {
                case 0, 1 -> (BaseChestBlock)((Object)ChestBlocks.GOLDEN_CHEST.get());
                case 2, 3 -> (BaseChestBlock)((Object)ChestBlocks.SHADOW_CHEST.get());
                case 4 -> (BaseChestBlock)((Object)ChestBlocks.FROZEN_CHEST.get());
                case 5 -> (BaseChestBlock)((Object)ChestBlocks.IVY_CHEST.get());
                case 6 -> (BaseChestBlock)((Object)ChestBlocks.WATER_CHEST.get());
                case 7 -> (BaseChestBlock)((Object)ChestBlocks.SKYWARE_CHEST.get());
                case 9 -> (BaseChestBlock)((Object)ChestBlocks.SANDSTONE_CHEST.get());
                case 10 -> (BaseChestBlock)((Object)ChestBlocks.LIVING_WOOD_CHEST.get());
                case 11, 12 -> (BaseChestBlock)((Object)ChestBlocks.DUNGEON_CHEST.get());
                default -> Blocks.CHEST;
            };
        }
    }

    public static enum Variant implements StringRepresentable
    {
        LOCKED_GOLDEN(0, "locked_golden", 1),
        UNLOCKED_GOLDEN(1, "unlocked_golden"),
        LOCKED_SHADOW(2, "locked_shadow", 3),
        UNLOCKED_SHADOW(3, "unlocked_shadow"),
        UNLOCKED_FROZEN(4, "unlocked_frozen"),
        UNLOCKED_LVY(5, "unlocked_lvy"),
        UNLOCKED_WATER(6, "unlocked_water"),
        UNLOCKED_SKYWARE(7, "unlocked_skyware"),
        UNLOCKED_NORMAL(8, "unlocked_normal"),
        UNLOCKED_SANDSTONE(9, "unlocked_sandstone"),
        UNLOCKED_LIVING_WOOD(10, "unlocked_living_wood"),
        LOCKED_DUNGEON(11, "locked_dungeon", 12),
        UNLOCKED_DUNGEON(12, "unlocked_dungeon");

        private static final IntFunction<Variant> BY_ID;
        private final int id;
        private final String name;
        private final int unlock;

        private Variant(int id, String name, int unlock) {
            this.id = id;
            this.name = name;
            this.unlock = unlock;
        }

        private Variant(int id, String name) {
            this(id, name, -1);
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public static class BItem
    extends BlockItem {
        public BItem(Block block) {
            super(block, new Item.Properties());
        }

        public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Variant variantId = Variant.byId(LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getInt("VariantId"));
                ItemStack itemStack = new ItemStack((ItemLike)BEntity.getBlockByVariant(variantId), stack.getCount());
                itemStack.set(DataComponents.BLOCK_STATE, (Object)new BlockItemStateProperties(Map.of("unlocked", variantId.unlock < 0 ? "true" : "false")));
                player.getInventory().setItem(slotId, itemStack);
            }
        }
    }
}

