/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.component.prefix;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.Tags;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.component.prefix.ModPrefix;
import org.confluence.mod.common.init.ModTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PrefixType implements StringRepresentable
{
    UNIVERSAL("universal"),
    MELEE("universal", "common", "melee"),
    RANGED("universal", "common", "ranged"),
    MAGIC("universal", "common", "magic"),
    ACCESSORY("accessory"),
    UNKNOWN(new String[0]){

        @Override
        public boolean isGroupAvailable(String group) {
            return false;
        }

        @Override
        public ModPrefix randomPrefix(RandomSource random) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updatePrefix(ModPrefix[] prefixes) {
        }
    };

    public static final Codec<PrefixType> CODEC;
    public static final StreamCodec<ByteBuf, PrefixType> STREAM_CODEC;
    private static PrefixType[] VALUES;
    public final String[] groups;
    private ModPrefix[] available;

    private PrefixType(String ... groups) {
        this.groups = groups;
        LinkedList<ModPrefix> list = new LinkedList<ModPrefix>();
        for (String group : groups) {
            Map<String, ? extends ModPrefix> map = ModPrefix.GROUPS.get(group);
            if (map == null) {
                Confluence.LOGGER.warn("Unknown group for prefix type: {}", (Object)group);
                continue;
            }
            for (Map.Entry<String, ? extends ModPrefix> entry : map.entrySet()) {
                list.add(entry.getValue());
            }
        }
        this.available = list.toArray(new ModPrefix[0]);
    }

    public boolean isGroupAvailable(String group) {
        for (String g : this.groups) {
            if (!g.equals(group)) continue;
            return true;
        }
        return false;
    }

    public ModPrefix[] getAvailable() {
        return this.available;
    }

    public ModPrefix randomPrefix(RandomSource random) {
        return this.available[random.nextInt(this.available.length)];
    }

    @Nullable
    public ModPrefix bestPrefix(RandomSource random, ItemStack itemStack) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (random.nextBoolean()) {
                    yield ModPrefix.Universal.GODLY;
                }
                yield ModPrefix.Universal.DEMONIC;
            }
            case 1 -> {
                if (itemStack.is(Tags.Items.MELEE_WEAPON_TOOLS)) {
                    yield ModPrefix.Melee.LEGENDARY;
                }
                yield ModPrefix.Melee.LIGHT;
            }
            case 2 -> ModPrefix.Ranged.UNREAL;
            case 3 -> {
                if (itemStack.is(ModTags.Items.MANA_WEAPON)) {
                    yield ModPrefix.Magic.MYTHICAL;
                }
                yield ModPrefix.Universal.RUTHLESS;
            }
            case 4 -> {
                switch (random.nextInt(6)) {
                    case 0: {
                        yield ModPrefix.Accessory.WARDING;
                    }
                    case 1: {
                        yield ModPrefix.Accessory.ARCANE;
                    }
                    case 2: {
                        yield ModPrefix.Accessory.LUCKY;
                    }
                    case 3: {
                        yield ModPrefix.Accessory.MENACING;
                    }
                    case 4: {
                        yield ModPrefix.Accessory.QUICK;
                    }
                    case 5: {
                        yield ModPrefix.Accessory.VIOLENT;
                    }
                }
                yield null;
            }
            case 5 -> null;
        };
    }

    public void updatePrefix(ModPrefix[] prefixes) {
        this.available = prefixes;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static PrefixType byId(int id) {
        if (VALUES == null) {
            VALUES = PrefixType.values();
        }
        if (id < 0 || id >= VALUES.length) {
            return UNKNOWN;
        }
        return VALUES[id];
    }

    static {
        CODEC = StringRepresentable.fromEnum(PrefixType::values);
        STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Enum::ordinal, PrefixType::byId);
    }
}

