/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terraentity.api.entity.IGeneration;
import org.confluence.terraentity.api.entity.ITrackType;
import org.confluence.terraentity.data.component.EffectStrategyComponent;
import org.confluence.terraentity.registries.generation.variant.AboveFallenGeneration;
import org.confluence.terraentity.registries.generation.variant.ForwardGeneration;
import org.confluence.terraentity.registries.hit_effect.IEffectStrategy;
import org.confluence.terraentity.registries.hit_effect.variant.TimePossibilityAmplifierEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SwordProjectileComponent(float damageFactor, float baseSpeed, float acceleration, int existTicks, float gravity, int cooldown, ResourceLocation soundEvent, ResourceLocation projType, Optional<ITrackType> trackType, IGeneration generation, Optional<EffectStrategyComponent> hitEffect) implements DataComponentType<SwordProjectileComponent>
{
    public static final Codec<SwordProjectileComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("damageFactor").forGetter(SwordProjectileComponent::damageFactor), (App)Codec.FLOAT.fieldOf("baseSpeed").forGetter(SwordProjectileComponent::baseSpeed), (App)Codec.FLOAT.fieldOf("acceleration").forGetter(SwordProjectileComponent::acceleration), (App)Codec.INT.fieldOf("existTicks").forGetter(SwordProjectileComponent::existTicks), (App)Codec.FLOAT.fieldOf("gravity").forGetter(SwordProjectileComponent::gravity), (App)Codec.INT.fieldOf("cooldown").forGetter(SwordProjectileComponent::cooldown), (App)ResourceLocation.CODEC.fieldOf("soundEvent").forGetter(SwordProjectileComponent::soundEvent), (App)ResourceLocation.CODEC.fieldOf("projType").forGetter(SwordProjectileComponent::projType), (App)ITrackType.TYPED_CODEC.optionalFieldOf("trackType").forGetter(SwordProjectileComponent::trackType), (App)IGeneration.TYPED_CODEC.fieldOf("generation").forGetter(SwordProjectileComponent::generation), (App)EffectStrategyComponent.CODEC.optionalFieldOf("hitEffect").forGetter(SwordProjectileComponent::hitEffect)).apply((Applicative)instance, SwordProjectileComponent::new));
    public static final Supplier<SwordProjectileComponent> ICE_PROJ = () -> new SwordProjectileComponent(1.0f, 0.6f, 0.9f, 40, 0.0f, 15, ModSoundEvents.FROZEN_ARROW.getId(), ModEntities.ICE_BLADE_SWORD_PROJECTILE.getId(), Optional.empty(), (IGeneration)ForwardGeneration.of((float)0.0f, (float)0.0f), Optional.empty());
    public static final Supplier<SwordProjectileComponent> STAR_FURY_PROJ = () -> new SwordProjectileComponent(1.5f, 1.5f, 0.9f, 100, 0.0f, 15, ModSoundEvents.STAR.getId(), ModEntities.STAR_FURY_PROJECTILE.getId(), Optional.empty(), (IGeneration)new AboveFallenGeneration(30.0f, 30.0f, 10.0f, 1.0f, 20.0f, 5.0f), Optional.empty());
    public static final Supplier<SwordProjectileComponent> ENCHANTED_SWORD_PROJ = () -> new SwordProjectileComponent(1.0f, 0.8f, 0.9f, 40, 0.0f, 10, ModSoundEvents.REGULAR_STAFF_SHOOT_2.getId(), ModEntities.ENCHANTED_SWORD_PROJECTILE.getId(), Optional.empty(), (IGeneration)ForwardGeneration.of((float)0.0f, (float)0.0f), Optional.empty());
    public static final Supplier<SwordProjectileComponent> GRASS_PROJ = () -> new SwordProjectileComponent(0.25f, 0.8f, 0.9f, 20, 0.0f, 10, ModSoundEvents.REGULAR_STAFF_SHOOT_2.getId(), ModEntities.GRASS_PROJECTILE.getId(), Optional.empty(), (IGeneration)ForwardGeneration.of((float)0.0f, (float)20.0f), Optional.of(EffectStrategyComponent.of((IEffectStrategy)TimePossibilityAmplifierEffect.of((String)"grass_effect", (Holder)MobEffects.POISON, (int)100, (int)1, (float)0.5f))));
    public static final Supplier<SwordProjectileComponent> NIGHT_PROJ = () -> new SwordProjectileComponent(1.0f, 0.8f, 0.9f, 20, 0.0f, 10, ModSoundEvents.REGULAR_STAFF_SHOOT_2.getId(), ModEntities.NIGHTS_EDGE_PROJECTILE.getId(), Optional.empty(), (IGeneration)ForwardGeneration.of((float)0.0f, (float)20.0f), Optional.empty());
    public static final StreamCodec<ByteBuf, SwordProjectileComponent> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public SoundEvent getSoundEvent() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(this.soundEvent);
    }

    @Nullable
    public Codec<SwordProjectileComponent> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<? super RegistryFriendlyByteBuf, SwordProjectileComponent> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SwordProjectileComponent) {
            SwordProjectileComponent other = (SwordProjectileComponent)o;
            return this.damageFactor == other.damageFactor && this.baseSpeed == other.baseSpeed && this.acceleration == other.acceleration && this.existTicks == other.existTicks && this.gravity == other.gravity && this.cooldown == other.cooldown && this.soundEvent.equals((Object)other.soundEvent) && this.trackType.equals(other.trackType) && this.generation.equals((Object)other.generation) && this.projType.equals((Object)other.projType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = Float.hashCode(this.damageFactor);
        result = 31 * result + Float.hashCode(this.baseSpeed);
        result = 31 * result + Float.hashCode(this.acceleration);
        result = 31 * result + this.existTicks;
        result = 31 * result + Float.hashCode(this.gravity);
        result = 31 * result + this.cooldown;
        result = 31 * result + this.soundEvent.hashCode();
        result = 31 * result + this.projType.hashCode();
        result = 31 * result + this.trackType.hashCode();
        result = 31 * result + this.generation.hashCode();
        result = 31 * result + this.hitEffect.hashCode();
        return result;
    }

    public float getVelocity(LivingEntity living) {
        float velocity = this.baseSpeed();
        AttributeInstance attributeInstance = living.getAttribute(TCAttributes.getRangedVelocity());
        if (attributeInstance != null) {
            return velocity * (float)attributeInstance.getValue();
        }
        return velocity;
    }

    public int getAttackSpeed(LivingEntity living) {
        int cooldown = this.cooldown();
        AttributeInstance attributeInstance = living.getAttribute(Attributes.ATTACK_SPEED);
        if (attributeInstance != null) {
            return Math.max(cooldown - (int)(attributeInstance.getValue() / 3.0), 0);
        }
        return cooldown;
    }
}

