/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.capability;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.confluence.mod.common.item.common.BottomlessBucketItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidBottomlessBucketWrapper
implements IFluidHandlerItem {
    protected final ItemStack container;

    public FluidBottomlessBucketWrapper(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public FluidStack getFluid() {
        Item item = this.container.getItem();
        if (item instanceof BottomlessBucketItem) {
            BottomlessBucketItem bucketItem = (BottomlessBucketItem)item;
            return new FluidStack(bucketItem.content, 1000);
        }
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)resource)) {
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

