/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;

public class SpreadingSandBlock
extends ColoredFallingBlock
implements ISpreadable {
    protected final ISpreadable.Type type;

    public SpreadingSandBlock(ISpreadable.Type type, int color, BlockBehaviour.Properties properties) {
        super(new ColorRGBA(color), properties.randomTicks().instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STILL_ALIVE, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STILL_ALIVE});
    }

    @Override
    public ISpreadable.Type getSpreadType() {
        return this.type;
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!serverLevel.isAreaLoaded(blockPos, 3)) {
            return;
        }
        this.spread(blockState, serverLevel, blockPos, randomSource);
    }
}

