/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.herbs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.particle.CrossDustParticleOptions;
import org.confluence.mod.common.block.natural.herbs.BaseHerbBlock;
import org.confluence.mod.common.init.item.FoodItems;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Waterleaf
extends BaseHerbBlock {
    @Override
    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)FoodItems.WATERLEAF_SEED.get();
    }

    @Override
    public boolean canBloom(ServerLevel level, BlockState state) {
        return level.isRaining();
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource random) {
        if (this.getAge(state) != 2) {
            return;
        }
        int r = random.nextInt(60);
        if (r > 3) {
            return;
        }
        Vec3 pos = blockPos.getCenter().add(state.getOffset((BlockGetter)level, blockPos)).offsetRandom(random, 0.3f);
        boolean large = level.random.nextBoolean();
        Vector4f curve = new Vector4f(0.0f, 0.33f, 0.66f, 1.0f);
        CrossDustParticleOptions sparkParticle = new CrossDustParticleOptions(large, -1330592787, -1603495177, new Vector3f((level.random.nextFloat() - 0.5f) / 40.0f, 0.02f, (level.random.nextFloat() - 0.5f) / 40.0f), curve, 0.7f, 15, 5, curve, true, true, false, true);
        level.addParticle((ParticleOptions)sparkParticle, pos.x, pos.y, pos.z, 0.0, (double)0.3f, 0.0);
    }
}

