/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.herbs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.particle.CrossDustParticleOptions;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.common.block.natural.herbs.BaseHerbBlock;
import org.confluence.mod.common.init.item.FoodItems;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;

public class Moonglow
extends BaseHerbBlock {
    public static final IntegerProperty PROP_LIGHT = IntegerProperty.create((String)"level", (int)3, (int)6);

    public Moonglow() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).randomTicks().lightLevel(value -> (Integer)value.getValue((Property)AGE) == 2 ? (Integer)value.getValue((Property)PROP_LIGHT) : 0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PROP_LIGHT});
    }

    @Override
    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)FoodItems.MOONGLOW_SEED.get();
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource random) {
        int brightness;
        if (this.getAge(state) != 2) {
            return;
        }
        int r = random.nextInt(200);
        if (r < 34) {
            boolean large = r < 6;
            Vector4f curve = new Vector4f(0.0f, random.nextFloat() * 2.0f - 0.5f, random.nextFloat() * 2.0f - 0.5f, random.nextFloat() * 2.0f - 0.5f);
            Vec3 pos = blockPos.getCenter().add(state.getOffset((BlockGetter)level, blockPos)).offsetRandom(random, 0.3f);
            CrossDustParticleOptions particle = large ? new CrossDustParticleOptions(true, 2139995647, 2135384292, Vec3.ZERO.offsetRandom(level.random, level.random.nextFloat() * 0.03f + 0.03f).toVector3f(), curve, level.random.nextFloat() * 0.4f + 0.6f, random.nextInt(60, 80), level.random.nextInt(-20, 20), curve, true, true, false, false) : new CrossDustParticleOptions(false, 2137764863, 2135459555, Vec3.ZERO.offsetRandom(level.random, level.random.nextFloat() * 0.03f + 0.03f).toVector3f(), curve, level.random.nextFloat() * 0.4f + 0.3f, random.nextInt(60, 80), level.random.nextInt(-20, 20), curve, true, true, false, false);
            level.addParticle((ParticleOptions)particle, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }
        if (r < 10) {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)PROP_LIGHT, (Comparable)Integer.valueOf(6)));
        } else if (r < 160 && (brightness = ((Integer)state.getValue((Property)PROP_LIGHT)).intValue()) > 3) {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)PROP_LIGHT, (Comparable)Integer.valueOf(brightness - 1)));
        }
    }

    @Override
    public boolean canBloom(ServerLevel level, BlockState state) {
        return LibDateUtils.isNight((Level)level);
    }
}

