/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.herbs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.particle.CrossDustParticleOptions;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.common.block.natural.herbs.BaseHerbBlock;
import org.confluence.mod.common.init.item.FoodItems;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Fireblossom
extends BaseHerbBlock {
    public Fireblossom() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).randomTicks().lightLevel(value -> (Integer)value.getValue((Property)AGE) == 2 ? 4 : 0));
    }

    @Override
    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)FoodItems.FIREBLOSSOM_SEED.get();
    }

    @Override
    public boolean canBloom(ServerLevel level, BlockState state) {
        if (level.dimensionType().natural()) {
            return LibDateUtils.isWithinDayTime((int)LibDateUtils.getDayTime((int)15, (int)45), (int)LibDateUtils._19$30, (Level)level) && !level.isRaining();
        }
        return true;
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource random) {
        if (this.getAge(state) != 2) {
            return;
        }
        int r = random.nextInt(60);
        if (r > 10) {
            return;
        }
        Vec3 pos = blockPos.getCenter().add(state.getOffset((BlockGetter)level, blockPos)).offsetRandom(random, 0.3f);
        boolean light = level.random.nextBoolean();
        Vector4f curve = new Vector4f(0.0f, 0.33f, 0.66f, 1.0f);
        CrossDustParticleOptions sparkParticle = new CrossDustParticleOptions(false, light ? -177 : -1325412530, -1325427633, new Vector3f((level.random.nextFloat() - 0.5f) / 20.0f, 0.2f, (level.random.nextFloat() - 0.5f) / 20.0f), curve, 1.0f, 8, 20, curve, true, true, true, false);
        level.addParticle((ParticleOptions)sparkParticle, pos.x, pos.y, pos.z, 0.0, (double)0.3f, 0.0);
    }
}

