/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.herbs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.particle.CrossDustParticleOptions;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.common.block.natural.herbs.BaseHerbBlock;
import org.confluence.mod.common.data.saved.MoonPhase;
import org.confluence.mod.common.gameevent.BloodMoonGameEvent;
import org.confluence.mod.common.init.item.FoodItems;
import org.joml.Vector4f;

public class DeathWeed
extends BaseHerbBlock {
    public static final IntegerProperty PROP_LIGHT = IntegerProperty.create((String)"level", (int)0, (int)7);

    public DeathWeed() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).randomTicks().lightLevel(value -> (Integer)value.getValue((Property)AGE) == 2 ? (Integer)value.getValue((Property)PROP_LIGHT) : 0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{PROP_LIGHT}));
    }

    @Override
    protected ItemLike getBaseSeedId() {
        return (ItemLike)FoodItems.DEATHWEED_SEED.get();
    }

    @Override
    public boolean canBloom(ServerLevel level, BlockState state) {
        return LibDateUtils.isNight((Level)level) && (MoonPhase.FULL_MOON.match((Level)level) || BloodMoonGameEvent.INSTANCE.started());
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource random) {
        int brightness;
        if (this.getAge(state) != 2) {
            return;
        }
        int r = random.nextInt(200);
        if (r < 34) {
            CrossDustParticleOptions particle;
            boolean dark = r < 17;
            Vector4f curve = new Vector4f(0.0f, 0.7f, 0.9f, 1.0f);
            Vec3 pos = blockPos.getCenter().add(state.getOffset((BlockGetter)level, blockPos)).offsetRandom(random, 0.3f);
            if (dark) {
                particle = new CrossDustParticleOptions(r < 12, 1725798911, 2138132098, Vec3.ZERO.offsetRandom(level.random, level.random.nextFloat() * 0.04f + 0.01f).toVector3f(), curve, level.random.nextFloat() * 0.6f + 0.6f, random.nextInt(20, 40), level.random.nextInt(-20, 20), curve, true, true, false, level.random.nextBoolean());
            } else {
                curve = new Vector4f(0.0f, 1.0f, 1.0f, 1.0f);
                particle = new CrossDustParticleOptions(false, -5267457, -6807041, Vec3.ZERO.offsetRandom(level.random, level.random.nextFloat() * 0.01f + 0.01f).toVector3f(), curve, level.random.nextFloat() * 0.6f + 0.3f, random.nextInt(20, 40), level.random.nextInt(-20, 20), curve, true, true, false, false);
            }
            level.addParticle((ParticleOptions)particle, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }
        if (r < 10) {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)PROP_LIGHT, (Comparable)Integer.valueOf(7)));
        } else if (r < 160 && (brightness = ((Integer)state.getValue((Property)PROP_LIGHT)).intValue()) > 0) {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)PROP_LIGHT, (Comparable)Integer.valueOf(brightness - 1)));
        }
    }
}

